/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geom.prep;

import com.vividsolutions.jts.algorithm.PointLocator;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.prep.PreparedLineString;
import com.vividsolutions.jts.geom.util.ComponentCoordinateExtracter;
import com.vividsolutions.jts.noding.SegmentStringUtil;
import java.util.List;

class PreparedLineStringIntersects {
    protected PreparedLineString prepLine;

    public static boolean intersects(PreparedLineString prep, Geometry geom) {
        PreparedLineStringIntersects op2 = new PreparedLineStringIntersects(prep);
        return op2.intersects(geom);
    }

    public PreparedLineStringIntersects(PreparedLineString prepLine) {
        this.prepLine = prepLine;
    }

    public boolean intersects(Geometry geom) {
        boolean segsIntersect;
        List lineSegStr = SegmentStringUtil.extractSegmentStrings(geom);
        if (lineSegStr.size() > 0 && (segsIntersect = this.prepLine.getIntersectionFinder().intersects(lineSegStr))) {
            return true;
        }
        if (geom.getDimension() == 1) {
            return false;
        }
        if (geom.getDimension() == 2 && this.prepLine.isAnyTargetComponentInTest(geom)) {
            return true;
        }
        if (geom.getDimension() == 0) {
            return this.isAnyTestPointInTarget(geom);
        }
        return false;
    }

    protected boolean isAnyTestPointInTarget(Geometry testGeom) {
        PointLocator locator = new PointLocator();
        List coords = ComponentCoordinateExtracter.getCoordinates(testGeom);
        for (Coordinate p2 : coords) {
            if (!locator.intersects(p2, this.prepLine.getGeometry())) continue;
            return true;
        }
        return false;
    }
}

