/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.densify;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateList;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineSegment;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.geom.util.GeometryTransformer;

public class Densifier {
    private Geometry inputGeom;
    private double distanceTolerance;

    public static Geometry densify(Geometry geom, double distanceTolerance) {
        Densifier densifier = new Densifier(geom);
        densifier.setDistanceTolerance(distanceTolerance);
        return densifier.getResultGeometry();
    }

    private static Coordinate[] densifyPoints(Coordinate[] pts, double distanceTolerance, PrecisionModel precModel) {
        LineSegment seg = new LineSegment();
        CoordinateList coordList = new CoordinateList();
        for (int i2 = 0; i2 < pts.length - 1; ++i2) {
            seg.p0 = pts[i2];
            seg.p1 = pts[i2 + 1];
            coordList.add(seg.p0, false);
            double len = seg.getLength();
            int densifiedSegCount = (int)(len / distanceTolerance) + 1;
            if (densifiedSegCount <= 1) continue;
            double densifiedSegLen = len / (double)densifiedSegCount;
            for (int j2 = 1; j2 < densifiedSegCount; ++j2) {
                double segFract = (double)j2 * densifiedSegLen / len;
                Coordinate p2 = seg.pointAlong(segFract);
                precModel.makePrecise(p2);
                coordList.add(p2, false);
            }
        }
        coordList.add(pts[pts.length - 1], false);
        return coordList.toCoordinateArray();
    }

    public Densifier(Geometry inputGeom) {
        this.inputGeom = inputGeom;
    }

    public void setDistanceTolerance(double distanceTolerance) {
        if (distanceTolerance <= 0.0) {
            throw new IllegalArgumentException("Tolerance must be positive");
        }
        this.distanceTolerance = distanceTolerance;
    }

    public Geometry getResultGeometry() {
        return new DensifyTransformer().transform(this.inputGeom);
    }

    class DensifyTransformer
    extends GeometryTransformer {
        DensifyTransformer() {
        }

        protected CoordinateSequence transformCoordinates(CoordinateSequence coords, Geometry parent) {
            Coordinate[] inputPts = coords.toCoordinateArray();
            Coordinate[] newPts = Densifier.densifyPoints(inputPts, Densifier.this.distanceTolerance, parent.getPrecisionModel());
            if (parent instanceof LineString && newPts.length == 1) {
                newPts = new Coordinate[]{};
            }
            return this.factory.getCoordinateSequenceFactory().create(newPts);
        }

        protected Geometry transformPolygon(Polygon geom, Geometry parent) {
            Geometry roughGeom = super.transformPolygon(geom, parent);
            if (parent instanceof MultiPolygon) {
                return roughGeom;
            }
            return this.createValidArea(roughGeom);
        }

        protected Geometry transformMultiPolygon(MultiPolygon geom, Geometry parent) {
            Geometry roughGeom = super.transformMultiPolygon(geom, parent);
            return this.createValidArea(roughGeom);
        }

        private Geometry createValidArea(Geometry roughAreaGeom) {
            return roughAreaGeom.buffer(0.0);
        }
    }
}

