/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.algorithm;

import com.vividsolutions.jts.algorithm.Angle;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateArrays;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Triangle;
import com.vividsolutions.jts.util.Assert;

public class MinimumBoundingCircle {
    private Geometry input;
    private Coordinate[] extremalPts = null;
    private Coordinate centre = null;
    private double radius = 0.0;

    public MinimumBoundingCircle(Geometry geom) {
        this.input = geom;
    }

    public Geometry getCircle() {
        this.compute();
        if (this.centre == null) {
            return this.input.getFactory().createPolygon(null, null);
        }
        Point centrePoint = this.input.getFactory().createPoint(this.centre);
        if (this.radius == 0.0) {
            return centrePoint;
        }
        return centrePoint.buffer(this.radius);
    }

    public Coordinate[] getExtremalPoints() {
        this.compute();
        return this.extremalPts;
    }

    public Coordinate getCentre() {
        this.compute();
        return this.centre;
    }

    public double getRadius() {
        this.compute();
        return this.radius;
    }

    private void computeCentre() {
        switch (this.extremalPts.length) {
            case 0: {
                this.centre = null;
                break;
            }
            case 1: {
                this.centre = this.extremalPts[0];
                break;
            }
            case 2: {
                this.centre = new Coordinate((this.extremalPts[0].x + this.extremalPts[1].x) / 2.0, (this.extremalPts[0].y + this.extremalPts[1].y) / 2.0);
                break;
            }
            case 3: {
                this.centre = Triangle.circumcentre(this.extremalPts[0], this.extremalPts[1], this.extremalPts[2]);
            }
        }
    }

    private void compute() {
        if (this.extremalPts != null) {
            return;
        }
        this.computeCirclePoints();
        this.computeCentre();
        if (this.centre != null) {
            this.radius = this.centre.distance(this.extremalPts[0]);
        }
    }

    private void computeCirclePoints() {
        Coordinate[] hullPts;
        if (this.input.isEmpty()) {
            this.extremalPts = new Coordinate[0];
            return;
        }
        if (this.input.getNumPoints() == 1) {
            Coordinate[] pts = this.input.getCoordinates();
            this.extremalPts = new Coordinate[]{new Coordinate(pts[0])};
            return;
        }
        Geometry convexHull = this.input.convexHull();
        Coordinate[] pts = hullPts = convexHull.getCoordinates();
        if (hullPts[0].equals2D(hullPts[hullPts.length - 1])) {
            pts = new Coordinate[hullPts.length - 1];
            CoordinateArrays.copyDeep(hullPts, 0, pts, 0, hullPts.length - 1);
        }
        if (pts.length <= 2) {
            this.extremalPts = CoordinateArrays.copyDeep(pts);
            return;
        }
        Coordinate P2 = MinimumBoundingCircle.lowestPoint(pts);
        Coordinate Q2 = MinimumBoundingCircle.pointWitMinAngleWithX(pts, P2);
        for (int i2 = 0; i2 < pts.length; ++i2) {
            Coordinate R2 = MinimumBoundingCircle.pointWithMinAngleWithSegment(pts, P2, Q2);
            if (Angle.isObtuse(P2, R2, Q2)) {
                this.extremalPts = new Coordinate[]{new Coordinate(P2), new Coordinate(Q2)};
                return;
            }
            if (Angle.isObtuse(R2, P2, Q2)) {
                P2 = R2;
                continue;
            }
            if (Angle.isObtuse(R2, Q2, P2)) {
                Q2 = R2;
                continue;
            }
            this.extremalPts = new Coordinate[]{new Coordinate(P2), new Coordinate(Q2), new Coordinate(R2)};
            return;
        }
        Assert.shouldNeverReachHere("Logic failure in Minimum Bounding Circle algorithm!");
    }

    private static Coordinate lowestPoint(Coordinate[] pts) {
        Coordinate min2 = pts[0];
        for (int i2 = 1; i2 < pts.length; ++i2) {
            if (!(pts[i2].y < min2.y)) continue;
            min2 = pts[i2];
        }
        return min2;
    }

    private static Coordinate pointWitMinAngleWithX(Coordinate[] pts, Coordinate P2) {
        double minSin = Double.MAX_VALUE;
        Coordinate minAngPt = null;
        for (int i2 = 0; i2 < pts.length; ++i2) {
            double len;
            double sin;
            Coordinate p2 = pts[i2];
            if (p2 == P2) continue;
            double dx2 = p2.x - P2.x;
            double dy2 = p2.y - P2.y;
            if (dy2 < 0.0) {
                dy2 = -dy2;
            }
            if (!((sin = dy2 / (len = Math.sqrt(dx2 * dx2 + dy2 * dy2))) < minSin)) continue;
            minSin = sin;
            minAngPt = p2;
        }
        return minAngPt;
    }

    private static Coordinate pointWithMinAngleWithSegment(Coordinate[] pts, Coordinate P2, Coordinate Q2) {
        double minAng = Double.MAX_VALUE;
        Coordinate minAngPt = null;
        for (int i2 = 0; i2 < pts.length; ++i2) {
            double ang;
            Coordinate p2 = pts[i2];
            if (p2 == P2 || p2 == Q2 || !((ang = Angle.angleBetween(P2, p2, Q2)) < minAng)) continue;
            minAng = ang;
            minAngPt = p2;
        }
        return minAngPt;
    }
}

