/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.algorithm;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;

public class InteriorPointLine {
    private Coordinate centroid;
    private double minDistance = Double.MAX_VALUE;
    private Coordinate interiorPoint = null;

    public InteriorPointLine(Geometry g2) {
        this.centroid = g2.getCentroid().getCoordinate();
        this.addInterior(g2);
        if (this.interiorPoint == null) {
            this.addEndpoints(g2);
        }
    }

    public Coordinate getInteriorPoint() {
        return this.interiorPoint;
    }

    private void addInterior(Geometry geom) {
        if (geom instanceof LineString) {
            this.addInterior(geom.getCoordinates());
        } else if (geom instanceof GeometryCollection) {
            GeometryCollection gc2 = (GeometryCollection)geom;
            for (int i2 = 0; i2 < gc2.getNumGeometries(); ++i2) {
                this.addInterior(gc2.getGeometryN(i2));
            }
        }
    }

    private void addInterior(Coordinate[] pts) {
        for (int i2 = 1; i2 < pts.length - 1; ++i2) {
            this.add(pts[i2]);
        }
    }

    private void addEndpoints(Geometry geom) {
        if (geom instanceof LineString) {
            this.addEndpoints(geom.getCoordinates());
        } else if (geom instanceof GeometryCollection) {
            GeometryCollection gc2 = (GeometryCollection)geom;
            for (int i2 = 0; i2 < gc2.getNumGeometries(); ++i2) {
                this.addEndpoints(gc2.getGeometryN(i2));
            }
        }
    }

    private void addEndpoints(Coordinate[] pts) {
        this.add(pts[0]);
        this.add(pts[pts.length - 1]);
    }

    private void add(Coordinate point) {
        double dist = point.distance(this.centroid);
        if (dist < this.minDistance) {
            this.interiorPoint = new Coordinate(point);
            this.minDistance = dist;
        }
    }
}

