/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.algorithm;

import com.vividsolutions.jts.geom.Coordinate;

public class CentralEndpointIntersector {
    private Coordinate[] pts;
    private Coordinate intPt = null;

    public static Coordinate getIntersection(Coordinate p00, Coordinate p01, Coordinate p10, Coordinate p11) {
        CentralEndpointIntersector intor = new CentralEndpointIntersector(p00, p01, p10, p11);
        return intor.getIntersection();
    }

    public CentralEndpointIntersector(Coordinate p00, Coordinate p01, Coordinate p10, Coordinate p11) {
        this.pts = new Coordinate[]{p00, p01, p10, p11};
        this.compute();
    }

    private void compute() {
        Coordinate centroid = CentralEndpointIntersector.average(this.pts);
        this.intPt = new Coordinate(this.findNearestPoint(centroid, this.pts));
    }

    public Coordinate getIntersection() {
        return this.intPt;
    }

    private static Coordinate average(Coordinate[] pts) {
        Coordinate avg = new Coordinate();
        int n2 = pts.length;
        for (int i2 = 0; i2 < pts.length; ++i2) {
            avg.x += pts[i2].x;
            avg.y += pts[i2].y;
        }
        if (n2 > 0) {
            avg.x /= (double)n2;
            avg.y /= (double)n2;
        }
        return avg;
    }

    private Coordinate findNearestPoint(Coordinate p2, Coordinate[] pts) {
        double minDist = Double.MAX_VALUE;
        Coordinate result = null;
        for (int i2 = 0; i2 < pts.length; ++i2) {
            double dist = p2.distance(pts[i2]);
            if (i2 != 0 && !(dist < minDist)) continue;
            minDist = dist;
            result = pts[i2];
        }
        return result;
    }
}

