/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.msgsimple.bundle;

import com.github.fge.Frozen;
import com.github.fge.msgsimple.InternalBundle;
import com.github.fge.msgsimple.bundle.MessageBundleBuilder;
import com.github.fge.msgsimple.locale.LocaleUtils;
import com.github.fge.msgsimple.provider.MessageSourceProvider;
import com.github.fge.msgsimple.provider.StaticMessageSourceProvider;
import com.github.fge.msgsimple.source.MessageSource;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.IllegalFormatException;
import java.util.List;
import java.util.Locale;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class MessageBundle
implements Frozen<MessageBundleBuilder> {
    private static final InternalBundle BUNDLE = InternalBundle.getInstance();
    final List<MessageSourceProvider> providers = new ArrayList<MessageSourceProvider>();

    public static MessageBundleBuilder newBuilder() {
        return new MessageBundleBuilder();
    }

    public static MessageBundle withSingleSource(MessageSource source) {
        MessageSourceProvider provider = StaticMessageSourceProvider.withSingleSource(source);
        return MessageBundle.newBuilder().appendProvider(provider).freeze();
    }

    MessageBundle(MessageBundleBuilder builder) {
        this.providers.addAll(builder.providers);
    }

    public String getMessage(Locale locale, String key) {
        BUNDLE.checkNotNull(key, "query.nullKey");
        BUNDLE.checkNotNull(locale, "query.nullLocale");
        for (Locale l2 : LocaleUtils.getApplicable(locale)) {
            for (MessageSourceProvider provider : this.providers) {
                String ret;
                MessageSource source = provider.getMessageSource(l2);
                if (source == null || (ret = source.getKey(key)) == null) continue;
                return ret;
            }
        }
        return key;
    }

    public String getMessage(String key) {
        return this.getMessage(Locale.getDefault(), key);
    }

    public String printf(Locale locale, String key, Object ... params) {
        String format = this.getMessage(locale, key);
        try {
            return String.format(locale, format, params);
        }
        catch (IllegalFormatException ignored) {
            return format;
        }
    }

    public String printf(String key, Object ... params) {
        return this.printf(Locale.getDefault(), key, params);
    }

    public String format(Locale locale, String key, Object ... params) {
        String pattern = this.getMessage(locale, key);
        try {
            return new MessageFormat(pattern, locale).format(params, new StringBuffer(pattern.length()), (FieldPosition)null).toString();
        }
        catch (IllegalArgumentException ignored) {
            return pattern;
        }
    }

    public String format(String key, Object ... params) {
        return this.format(Locale.getDefault(), key, params);
    }

    public <T> T checkNotNull(T reference, Locale locale, String key) {
        if (reference == null) {
            throw new NullPointerException(this.getMessage(locale, key));
        }
        return reference;
    }

    public <T> T checkNotNull(T reference, String key) {
        return this.checkNotNull(reference, Locale.getDefault(), key);
    }

    public void checkArgument(boolean condition, Locale locale, String key) {
        if (!condition) {
            throw new IllegalArgumentException(this.getMessage(locale, key));
        }
    }

    public void checkArgument(boolean condition, String key) {
        this.checkArgument(condition, Locale.getDefault(), key);
    }

    public <T> T checkNotNullPrintf(T reference, Locale locale, String key, Object ... params) {
        if (reference == null) {
            throw new NullPointerException(this.printf(locale, key, params));
        }
        return reference;
    }

    public <T> T checkNotNullPrintf(T reference, String key, Object ... params) {
        return this.checkNotNullPrintf(reference, Locale.getDefault(), key, params);
    }

    public void checkArgumentPrintf(boolean condition, Locale locale, String key, Object ... params) {
        if (!condition) {
            throw new IllegalArgumentException(this.printf(locale, key, params));
        }
    }

    public void checkArgumentPrintf(boolean condition, String key, Object ... params) {
        this.checkArgumentPrintf(condition, Locale.getDefault(), key, params);
    }

    public <T> T checkNotNullFormat(T reference, Locale locale, String key, Object ... params) {
        if (reference == null) {
            throw new NullPointerException(this.format(locale, key, params));
        }
        return reference;
    }

    public <T> T checkNotNullFormat(T reference, String key, Object ... params) {
        return this.checkNotNullFormat(reference, Locale.getDefault(), key, params);
    }

    public void checkArgumentFormat(boolean condition, Locale locale, String key, Object ... params) {
        if (!condition) {
            throw new IllegalArgumentException(this.format(locale, key, params));
        }
    }

    public void checkArgumentFormat(boolean condition, String key, Object ... params) {
        this.checkArgumentFormat(condition, Locale.getDefault(), key, params);
    }

    @Override
    public MessageBundleBuilder thaw() {
        return new MessageBundleBuilder(this);
    }
}

