/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonpatch.mergepatch;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.github.fge.jsonpatch.JsonPatchException;
import com.github.fge.jsonpatch.mergepatch.JsonMergePatch;
import java.io.IOException;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
final class NonObjectMergePatch
extends JsonMergePatch {
    private final JsonNode node;

    NonObjectMergePatch(JsonNode node) {
        if (node == null) {
            throw new NullPointerException();
        }
        this.node = node;
    }

    @Override
    public JsonNode apply(JsonNode input) throws JsonPatchException {
        BUNDLE.checkNotNull(input, "jsonPatch.nullValue");
        return this.node;
    }

    @Override
    public void serialize(JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
        jgen.writeTree(this.node);
    }

    @Override
    public void serializeWithType(JsonGenerator jgen, SerializerProvider provider, TypeSerializer typeSer) throws IOException, JsonProcessingException {
        this.serialize(jgen, provider);
    }
}

