/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.license;

import liquibase.Scope;
import liquibase.change.AbstractChange;
import liquibase.change.Change;
import liquibase.change.ChangeFactory;
import liquibase.changelog.ChangeSet;
import liquibase.database.Database;
import liquibase.exception.ValidationErrors;
import liquibase.license.LicenseService;
import liquibase.license.LicenseServiceFactory;
import liquibase.license.pro.LicenseTier;

public abstract class LicenseValidationChange
extends AbstractChange {
    @Override
    public ValidationErrors validate(Database database) {
        ValidationErrors validationErrors = LicenseValidationChange.checkForValidLicense(LicenseTier.PRO, this);
        if (validationErrors.hasErrors()) {
            return validationErrors;
        }
        return super.validate(database);
    }

    public static ValidationErrors checkForValidLicense(LicenseTier object, Change object2) {
        Object object3 = Scope.getCurrentScope().getSingleton(LicenseServiceFactory.class).getLicenseService();
        if (object3 == null) {
            return new ValidationErrors();
        }
        if (object3.licenseIsValid(((LicenseTier)((Object)object)).getSubject())) {
            object = String.format("Found valid license with subject '%s' for '%s'", ((LicenseTier)((Object)object)).getSubject(), object2.getDescription());
            Scope.getCurrentScope().getLog(LicenseService.class).fine((String)object);
            return new ValidationErrors();
        }
        object = object2.getChangeSet();
        object2 = Scope.getCurrentScope().getSingleton(ChangeFactory.class).getChangeMetaData((Change)object2).getName();
        object3 = new ValidationErrors();
        object = "Change Set ID: " + ((ChangeSet)object).getId() + " Change Set Author: " + ((ChangeSet)object).getAuthor() + "\n";
        object = (String)object + "Change Type 'pro:" + (String)object2 + "' is not allowed without a valid Liquibase Pro License.\n";
        object = (String)object + "To purchase or renew a Liquibase Pro license key, please contact sales@liquibase.com or\ngo to https://www.liquibase.org/download";
        ((ValidationErrors)object3).addError((String)object);
        return object3;
    }
}

