/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.checks.snapshot;

import java.util.concurrent.atomic.AtomicReference;
import liquibase.GlobalConfiguration;
import liquibase.command.CommandResults;
import liquibase.command.CommandScope;
import liquibase.command.core.SnapshotCommandStep;
import liquibase.database.Database;
import liquibase.database.OfflineConnection;
import liquibase.diff.output.ObjectChangeFilter;
import liquibase.diff.output.StandardObjectChangeFilter;
import liquibase.exception.DatabaseException;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.snapshot.SnapshotControl;
import liquibase.structure.core.DatabaseObjectFactory;

public class DatabaseSnapshotHelper {
    private DatabaseSnapshotHelper() {
    }

    public static DatabaseSnapshot takeSnapshot(String object, Database database, String string) {
        AtomicReference<DatabaseSnapshot> atomicReference = new AtomicReference<DatabaseSnapshot>();
        try {
            CommandScope commandScope = new CommandScope("snapshot");
            commandScope.addArgumentValue(SnapshotCommandStep.DATABASE_ARG, database);
            commandScope.addArgumentValue(SnapshotCommandStep.URL_ARG, object);
            commandScope.addArgumentValue(SnapshotCommandStep.SCHEMAS_ARG, string);
            commandScope.setOutput(null);
            commandScope.addArgumentValue(SnapshotCommandStep.SNAPSHOT_CONTROL_ARG, DatabaseSnapshotHelper.createSnapshotControl(database));
            object = commandScope.execute();
            atomicReference.set((DatabaseSnapshot)((CommandResults)object).getResult("snapshot"));
        }
        catch (Exception exception) {
            object = database.getConnection() instanceof OfflineConnection ? "The snapshot specified in the URL property cannot be accessed. Database-scoped checks cannot be completed.\nPlease check all database properties and credentials and try again." : "The database target specified in the URL property cannot be accessed. Database-scoped checks cannot be completed.\nPlease check all database properties and credentials and try again.";
            throw new DatabaseException((String)object, exception);
        }
        return (DatabaseSnapshot)atomicReference.get();
    }

    private static SnapshotControl createSnapshotControl(Database database) {
        Object object = GlobalConfiguration.DATABASECHANGELOG_TABLE_NAME.getCurrentValue();
        Class[] classArray = GlobalConfiguration.DATABASECHANGELOGLOCK_TABLE_NAME.getCurrentValue();
        object = new StandardObjectChangeFilter(StandardObjectChangeFilter.FilterType.EXCLUDE, "table:(?i)" + (String)object + ", table:(?i)" + (String)classArray);
        classArray = DatabaseObjectFactory.getInstance().getStandardTypes().toArray(new Class[0]);
        return new SnapshotControl(database, (ObjectChangeFilter)object, classArray);
    }
}

