/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.subst;

public class Node {
    Type type;
    Object payload;
    Object defaultPart;
    Node next;

    public Node(Type type, Object payload) {
        this.type = type;
        this.payload = payload;
    }

    public Node(Type type, Object payload, Object defaultPart) {
        this.type = type;
        this.payload = payload;
        this.defaultPart = defaultPart;
    }

    void append(Node newNode) {
        if (newNode == null) {
            return;
        }
        Node n2 = this;
        while (true) {
            if (n2.next == null) {
                n2.next = newNode;
                return;
            }
            n2 = n2.next;
        }
    }

    public String toString() {
        switch (this.type) {
            case LITERAL: {
                return "Node{type=" + String.valueOf((Object)this.type) + ", payload='" + String.valueOf(this.payload) + "'}";
            }
            case VARIABLE: {
                StringBuilder payloadBuf = new StringBuilder();
                StringBuilder defaultPartBuf2 = new StringBuilder();
                if (this.defaultPart != null) {
                    this.recursive((Node)this.defaultPart, defaultPartBuf2);
                }
                this.recursive((Node)this.payload, payloadBuf);
                String r2 = "Node{type=" + String.valueOf((Object)this.type) + ", payload='" + payloadBuf.toString() + "'";
                if (this.defaultPart != null) {
                    r2 = r2 + ", defaultPart=" + defaultPartBuf2.toString();
                }
                r2 = r2 + "}";
                return r2;
            }
        }
        return null;
    }

    public void dump() {
        System.out.print(this.toString());
        System.out.print(" -> ");
        if (this.next != null) {
            this.next.dump();
        } else {
            System.out.print(" null");
        }
    }

    void recursive(Node n2, StringBuilder sb) {
        Node c2 = n2;
        while (c2 != null) {
            sb.append(c2.toString()).append(" --> ");
            c2 = c2.next;
        }
        sb.append("null ");
    }

    public void setNext(Node n2) {
        this.next = n2;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        Node node = (Node)o2;
        if (this.type != node.type) {
            return false;
        }
        if (this.payload != null ? !this.payload.equals(node.payload) : node.payload != null) {
            return false;
        }
        if (this.defaultPart != null ? !this.defaultPart.equals(node.defaultPart) : node.defaultPart != null) {
            return false;
        }
        return !(this.next != null ? !this.next.equals(node.next) : node.next != null);
    }

    public int hashCode() {
        int result = this.type != null ? this.type.hashCode() : 0;
        result = 31 * result + (this.payload != null ? this.payload.hashCode() : 0);
        result = 31 * result + (this.defaultPart != null ? this.defaultPart.hashCode() : 0);
        result = 31 * result + (this.next != null ? this.next.hashCode() : 0);
        return result;
    }

    static enum Type {
        LITERAL,
        VARIABLE;

    }
}

