/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.joran.action;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.net.SocketAppender;
import ch.qos.logback.core.joran.action.Action;
import ch.qos.logback.core.joran.spi.ActionException;
import ch.qos.logback.core.joran.spi.SaxEventInterpretationContext;
import org.xml.sax.Attributes;

public class ConsolePluginAction
extends Action {
    private static final String PORT_ATTR = "port";
    private static final Integer DEFAULT_PORT = 4321;

    @Override
    public void begin(SaxEventInterpretationContext ec2, String name, Attributes attributes) throws ActionException {
        String portStr = attributes.getValue(PORT_ATTR);
        Integer port = null;
        if (portStr == null) {
            port = DEFAULT_PORT;
        } else {
            try {
                port = Integer.valueOf(portStr);
            }
            catch (NumberFormatException ex2) {
                this.addError("Port " + portStr + " in ConsolePlugin config is not a correct number");
                this.addError("Abandoning configuration of ConsolePlugin.");
                return;
            }
        }
        LoggerContext lc2 = (LoggerContext)ec2.getContext();
        SocketAppender appender = new SocketAppender();
        appender.setContext(lc2);
        appender.setIncludeCallerData(true);
        appender.setRemoteHost("localhost");
        appender.setPort(port);
        appender.start();
        Logger root = lc2.getLogger("ROOT");
        root.addAppender(appender);
        this.addInfo("Sending LoggingEvents to the plugin using port " + port);
    }

    @Override
    public void end(SaxEventInterpretationContext ec2, String name) throws ActionException {
    }
}

