/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.modelextractor;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import de.fraunhofer.iosb.ilt.configurable.ConfigEditor;
import de.fraunhofer.iosb.ilt.configurable.ConfigEditors;
import de.fraunhofer.iosb.ilt.configurable.ConfigurationException;
import de.fraunhofer.iosb.ilt.configurable.ContentConfigEditor;
import de.fraunhofer.iosb.ilt.configurable.editor.EditorNull;
import de.fraunhofer.iosb.ilt.frostserver.model.loader.DefEntityProperty;
import de.fraunhofer.iosb.ilt.frostserver.model.loader.DefEntityType;
import de.fraunhofer.iosb.ilt.frostserver.model.loader.DefModel;
import de.fraunhofer.iosb.ilt.frostserver.model.loader.DefNavigationProperty;
import de.fraunhofer.iosb.ilt.frostserver.model.loader.PropertyPersistenceMapper;
import de.fraunhofer.iosb.ilt.frostserver.modelextractor.TableDataController;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.utils.fieldmapper.FieldMapperBigDecimal;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.utils.fieldmapper.FieldMapperId;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.utils.fieldmapper.FieldMapperJson;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.utils.fieldmapper.FieldMapperManyToMany;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.utils.fieldmapper.FieldMapperOneToMany;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.utils.fieldmapper.FieldMapperString;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.utils.fieldmapper.FieldMapperTimeInstant;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.utils.fieldmapper.FieldMapperTimeInterval;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TreeMap;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TextField;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Pane;
import javafx.stage.DirectoryChooser;
import javafx.stage.FileChooser;
import javafx.util.Callback;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.commons.io.FileUtils;
import org.apache.commons.text.CaseUtils;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.ForeignKey;
import org.jooq.Meta;
import org.jooq.SQLDialect;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.UniqueKey;
import org.jooq.impl.DSL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FXMLController
implements Initializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(FXMLController.class);
    private static final String FAILED_TO_GENERATE_JSON = "Failed to generate JSON.";
    private static final String FAILED_TO_LOAD_DB_DRIVER = "Failed to load DB driver.";
    private static final String FAILED_TO_LOAD_JSON = "Failed to load JSON.";
    private static final String FAILED_TO_WRITE_FILE = "Failed to write file.";
    private static final String SELECT_TARGET_FILE_OR_DIRECTORY = "Select target file or directory";
    @FXML
    private AnchorPane paneRoot;
    @FXML
    private ScrollPane paneConfig;
    @FXML
    private Button buttonSave;
    @FXML
    private Button buttonRead;
    @FXML
    private Button buttonSelectDir;
    @FXML
    private Button buttonSelectFile;
    @FXML
    private Button buttonGenerate;
    @FXML
    private TextField textFieldDbUrl;
    @FXML
    private TextField textFieldDriver;
    @FXML
    private TextField textFieldUsername;
    @FXML
    private TextField textFieldPassword;
    @FXML
    private ListView<TableData> listViewFound;
    private ObservableList<TableData> tableList;
    @FXML
    private Label labelFile;
    private final EditorNull editorNull = new EditorNull();
    private final FileChooser fileChooser = new FileChooser();
    private final DirectoryChooser dirChooser = new DirectoryChooser();
    private File currentFile = null;
    private ObjectMapper objectMapper;
    private final Map<String, TableData> tables = new HashMap<String, TableData>();
    private final Map<String, ConfigEditor<DefModel>> models = new TreeMap<String, ConfigEditor<DefModel>>();

    private ObjectMapper getObjectMapper() {
        if (this.objectMapper == null) {
            this.objectMapper = new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_DEFAULT).enable(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS);
        }
        return this.objectMapper;
    }

    private void setCurrentFile(File file) {
        this.currentFile = file;
        this.buttonSave.setDisable(this.currentFile == null);
        if (this.currentFile != null) {
            this.labelFile.setText(this.currentFile.getAbsolutePath());
            if (this.currentFile.isDirectory()) {
                this.dirChooser.setInitialDirectory(this.currentFile);
                this.fileChooser.setInitialDirectory(this.currentFile);
            } else {
                this.dirChooser.setInitialDirectory(this.currentFile.getParentFile());
                this.fileChooser.setInitialDirectory(this.currentFile.getParentFile());
                this.fileChooser.setInitialFileName(this.currentFile.getName());
            }
        }
    }

    @FXML
    private void actionRead(ActionEvent event) {
        this.readFromDatabase();
    }

    private TableData getTable(String tableName) {
        return this.tables.computeIfAbsent(tableName, TableData::new);
    }

    private void readFromDatabase() {
        this.listViewFound.getItems().clear();
        this.tables.clear();
        DSLContext dslContext = this.getDslContext();
        if (dslContext == null) {
            return;
        }
        Meta meta = dslContext.meta();
        List dbTableList = meta.getTables();
        for (Table table : dbTableList) {
            TableData tableData = this.getTable(table.getName());
            UniqueKey primaryKey = table.getPrimaryKey();
            if (primaryKey != null) {
                List fields = primaryKey.getFields();
                tableData.setPkSize(fields.size());
                tableData.addFields(fields, true);
            }
            tableData.addFields(Arrays.asList(table.fields()), false);
            List references = table.getReferences();
            for (ForeignKey reference : references) {
                TableField[] otherFields = reference.getKeyFieldsArray();
                if (otherFields.length != 1) {
                    LOGGER.warn("      Multi-key FK: {}", (Object)reference.getName());
                    continue;
                }
                TableField otherField = otherFields[0];
                String otherTableName = otherField.getTable().getName();
                TableField[] myFields = reference.getFieldsArray();
                if (myFields.length != 1) {
                    LOGGER.warn("      Multi-source-field FK: {}", (Object)reference.getName());
                    continue;
                }
                FieldData fieldMine = tableData.getField(myFields[0].getName());
                fieldMine.setFk(true);
                ForeignKeyData fk = new ForeignKeyData(tableData.tableName, otherTableName).setFieldMine(fieldMine).setFieldTheirs(FieldData.from((Field)otherField, false));
                tableData.addReferenceToOther(fk);
                this.getTable(otherTableName).addReferenceFromOther(fk);
            }
            this.tableList.add((Object)tableData);
        }
        for (TableData tableData : this.tables.values()) {
            LOGGER.info("-> {}", (Object)tableData.tableName);
            LOGGER.info("  -> Fields");
            for (FieldData fieldData : tableData.getFields().values()) {
                LOGGER.info("    -> {}", (Object)fieldData);
            }
            LOGGER.info("  -> Relations");
            for (ForeignKeyData fk : tableData.refsToOther.values()) {
                LOGGER.info("    -> {}", (Object)fk);
            }
            tableData.analyse();
        }
        this.buttonGenerate.setDisable(false);
    }

    private DSLContext getDslContext() {
        try {
            Class.forName(this.textFieldDriver.getText());
        }
        catch (ClassNotFoundException ex) {
            LOGGER.error(FAILED_TO_LOAD_DB_DRIVER);
            this.alertError(FAILED_TO_LOAD_DB_DRIVER, ex);
            return null;
        }
        BasicDataSource ds = new BasicDataSource();
        ds.setUrl(this.textFieldDbUrl.getText());
        ds.setUsername(this.textFieldUsername.getText());
        ds.setPassword(this.textFieldPassword.getText());
        return DSL.using((DataSource)ds, (SQLDialect)SQLDialect.POSTGRES);
    }

    private void generate() {
        this.models.clear();
        TreeMap<String, DefEntityType> entityTypes = new TreeMap<String, DefEntityType>();
        DefModel fullModel = new DefModel();
        for (TableData tableData : this.tables.values()) {
            if (!tableData.isEntityType()) continue;
            DefEntityType defType = new DefEntityType().setName(tableData.getEntityName()).setPlural(tableData.getEntityPlural()).setTable(tableData.tableName);
            for (FieldData field : tableData.getFields().values()) {
                DefEntityProperty defEp = new DefEntityProperty();
                defEp.setName(CaseUtils.toCamelCase((String)field.name, (boolean)false, (char[])new char[]{'_'}));
                if (field.pk) {
                    defEp.addAlias("@iot.id");
                }
                if (!this.fieldMapperFromFieldData(field, defEp, tableData)) continue;
                defType.addEntityProperty(defEp);
            }
            entityTypes.put(tableData.tableName, defType);
            fullModel.addEntityType(defType);
        }
        for (TableData tableData : this.tables.values()) {
            TableData otherTableData;
            if (!tableData.isEntityType()) continue;
            DefEntityType entityType = (DefEntityType)entityTypes.get(tableData.tableName);
            for (ForeignKeyData fk : tableData.refsToOther.values()) {
                otherTableData = this.tables.get(fk.otherTableName);
                if (otherTableData.isEntityType()) {
                    DefEntityType otherEntityType = (DefEntityType)entityTypes.get(otherTableData.tableName);
                    DefNavigationProperty defNp = new DefNavigationProperty().setName(otherEntityType.getName()).setEntityType(otherEntityType.getName()).setRequired(true).addHandler((PropertyPersistenceMapper)new FieldMapperOneToMany().setField(fk.fieldMine.name).setOtherField(fk.fieldTheirs.name).setOtherTable(fk.otherTableName)).setInverse(new DefNavigationProperty.Inverse().setName(entityType.getPlural()).setEntitySet(true));
                    entityType.addNavigationProperty(defNp);
                    continue;
                }
                LOGGER.info("Ignoring fk from {} to {} ({})", new Object[]{tableData.tableName, otherTableData.tableName, otherTableData.getTableType()});
            }
            for (ForeignKeyData fk : tableData.refsFromOther.values()) {
                otherTableData = this.tables.get(fk.myTableName);
                if (otherTableData.isLinkTable()) {
                    TableData linkTableData = otherTableData;
                    String otherTableName = linkTableData.refsToOther.keySet().stream().findFirst().orElse("");
                    otherTableData = this.tables.get(otherTableName);
                    if (otherTableData == null || otherTableData == tableData) {
                        LOGGER.warn("Ignoring fk over linkTable for now {}, {}", (Object)linkTableData.tableName, (Object)otherTableName);
                        continue;
                    }
                    ForeignKeyData fk2 = linkTableData.refsToOther.get(otherTableName);
                    DefEntityType otherEntityType = (DefEntityType)entityTypes.get(otherTableData.tableName);
                    DefNavigationProperty defNp = new DefNavigationProperty().setName(otherEntityType.getPlural()).setEntityType(otherEntityType.getName()).addHandler((PropertyPersistenceMapper)new FieldMapperManyToMany().setField(fk.fieldMine.name).setLinkTable(linkTableData.tableName).setLinkOurField(fk.fieldTheirs.name).setLinkOtherField(fk2.fieldTheirs.name).setOtherTable(otherTableData.tableName).setOtherField(fk2.fieldMine.name)).setInverse(new DefNavigationProperty.Inverse().setName(entityType.getPlural()).setEntitySet(true));
                    entityType.addNavigationProperty(defNp);
                    continue;
                }
                LOGGER.info("Ignoring fk from {} to {} ({})", new Object[]{tableData.tableName, otherTableData.tableName, otherTableData.getTableType()});
            }
        }
        for (DefEntityType defEt : fullModel.getEntityTypes()) {
            this.models.put(defEt.getTable(), this.createEditorForModel(new DefModel().addEntityType(defEt)));
        }
    }

    private ConfigEditor<DefModel> createEditorForModel(DefModel model) {
        try {
            String stringData = this.getObjectMapper().writeValueAsString((Object)model);
            JsonElement json = JsonParser.parseString((String)stringData);
            if (json == null) {
                return null;
            }
            ConfigEditor configEditor = (ConfigEditor)ConfigEditors.buildEditorFromClass(DefModel.class, null, null).orElse(this.editorNull);
            configEditor.setConfig(json);
            return configEditor;
        }
        catch (JsonProcessingException ex) {
            LOGGER.error(FAILED_TO_GENERATE_JSON, (Throwable)ex);
            this.alertError(FAILED_TO_GENERATE_JSON, (Exception)((Object)ex));
            return null;
        }
    }

    private boolean fieldMapperFromFieldData(FieldData fieldData, DefEntityProperty defEp, TableData tableData) {
        if (fieldData.pk) {
            defEp.addHandler((PropertyPersistenceMapper)new FieldMapperId().setField(fieldData.name)).setType("Id");
            return true;
        }
        if (fieldData.fk) {
            return false;
        }
        switch (fieldData.typeName.toLowerCase()) {
            case "clob": 
            case "varchar": 
            case "uuid": {
                defEp.addHandler((PropertyPersistenceMapper)new FieldMapperString().setField(fieldData.name)).setType("String");
                return true;
            }
            case "smallint": 
            case "bigint": 
            case "float": {
                defEp.addHandler((PropertyPersistenceMapper)new FieldMapperBigDecimal().setField(fieldData.name)).setType("BigDecimal");
                return true;
            }
            case "jsonb": {
                defEp.addHandler((PropertyPersistenceMapper)new FieldMapperJson().setField(fieldData.name).setIsMap(false)).setType("Object");
                return true;
            }
            case "timestamp with time zone": {
                String endName;
                String fnl = fieldData.name.toLowerCase();
                if (fnl.endsWith("_end") && tableData.hasField(fnl.substring(0, fnl.length() - 3) + "start")) {
                    return false;
                }
                String string = endName = fnl.length() > 6 ? fnl.substring(0, fnl.length() - 5) + "end" : "";
                if (fnl.endsWith("_start") && tableData.hasField(endName)) {
                    FieldData fieldDataEnd = tableData.getField(endName);
                    defEp.setType("TimeInterval").setName(defEp.getName().substring(0, defEp.getName().length() - 5)).addHandler((PropertyPersistenceMapper)new FieldMapperTimeInterval().setFieldStart(fieldData.name).setFieldEnd(fieldDataEnd.name));
                    return true;
                }
                defEp.addHandler((PropertyPersistenceMapper)new FieldMapperTimeInstant().setField(fieldData.name)).setType("TimeInstant");
                return true;
            }
        }
        LOGGER.error("Unknown field type: {}", (Object)fieldData.typeName);
        return true;
    }

    @FXML
    private void actionSelectFile(ActionEvent event) {
        this.fileChooser.setTitle(SELECT_TARGET_FILE_OR_DIRECTORY);
        File file = this.fileChooser.showOpenDialog(this.paneConfig.getScene().getWindow());
        if (file == null) {
            return;
        }
        this.setCurrentFile(file);
    }

    @FXML
    private void actionSelectDir(ActionEvent event) {
        this.fileChooser.setTitle(SELECT_TARGET_FILE_OR_DIRECTORY);
        File file = this.dirChooser.showDialog(this.paneConfig.getScene().getWindow());
        if (file == null) {
            return;
        }
        this.setCurrentFile(file);
    }

    @FXML
    private void actionGenerate(ActionEvent event) {
        this.generate();
        this.listViewFound.getSelectionModel().clearSelection();
        this.listViewFound.getSelectionModel().selectFirst();
    }

    @FXML
    private void actionSave(ActionEvent event) {
        if (this.currentFile.isDirectory()) {
            for (ConfigEditor<DefModel> editor : this.models.values()) {
                try {
                    DefModel subModel = new DefModel();
                    ((ContentConfigEditor)editor).setContentsOn((Object)subModel);
                    String typeName = ((DefEntityType)subModel.getEntityTypes().get(0)).getName();
                    this.saveToFile(editor.getConfig(), new File(this.currentFile, typeName + ".json"));
                }
                catch (ConfigurationException ex) {
                    LOGGER.error(FAILED_TO_LOAD_JSON, (Throwable)ex);
                    this.alertError(FAILED_TO_LOAD_JSON, (Exception)((Object)ex));
                }
            }
        } else {
            DefModel composite = new DefModel();
            for (ConfigEditor<DefModel> editor : this.models.values()) {
                try {
                    DefModel subModel = new DefModel();
                    ((ContentConfigEditor)editor).setContentsOn((Object)subModel);
                    composite.getEntityTypes().addAll(subModel.getEntityTypes());
                    composite.getConformance().addAll(subModel.getConformance());
                    composite.getSimplePropertyTypes().addAll(subModel.getSimplePropertyTypes());
                }
                catch (ConfigurationException ex) {
                    LOGGER.error(FAILED_TO_LOAD_JSON, (Throwable)ex);
                    this.alertError(FAILED_TO_LOAD_JSON, (Exception)((Object)ex));
                }
            }
            try {
                String stringData = this.getObjectMapper().writeValueAsString((Object)composite);
                JsonElement json = JsonParser.parseString((String)stringData);
                this.saveToFile(json, this.currentFile);
            }
            catch (JsonProcessingException ex) {
                LOGGER.error(FAILED_TO_GENERATE_JSON, (Throwable)ex);
                this.alertError(FAILED_TO_GENERATE_JSON, (Exception)((Object)ex));
            }
        }
    }

    private void saveToFile(JsonElement json, File file) {
        if (file == null) {
            return;
        }
        String config = new GsonBuilder().setPrettyPrinting().create().toJson(json);
        try {
            FileUtils.writeStringToFile((File)file, (String)config, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException ex) {
            LOGGER.error(FAILED_TO_WRITE_FILE, (Throwable)ex);
            this.alertError(FAILED_TO_WRITE_FILE, ex);
        }
    }

    private void showModel(TableData table) {
        if (table == null) {
            this.paneConfig.setContent(null);
            return;
        }
        LOGGER.info("Selected: {}", (Object)table);
        ConfigEditor<DefModel> model = this.models.get(table.tableName);
        this.replaceEditor(model);
    }

    private void replaceEditor(ConfigEditor<?> editor) {
        if (editor == null) {
            this.paneConfig.setContent(null);
        } else {
            this.paneConfig.setContent(editor.getGuiFactoryFx().getNode());
        }
    }

    private void alertError(String text, Exception ex) {
        Alert alert = new Alert(Alert.AlertType.ERROR);
        alert.setTitle(text);
        alert.setContentText(ex.getLocalizedMessage());
        alert.showAndWait();
    }

    public void initialize(URL url, ResourceBundle rb) {
        this.tableList = FXCollections.observableArrayList();
        this.listViewFound.setItems(this.tableList);
        this.listViewFound.getSelectionModel().selectedItemProperty().addListener((ov, oldItem, newItem) -> this.showModel((TableData)newItem));
        this.listViewFound.setCellFactory((Callback)new TableDataCellFactory());
    }

    public class TableDataCellFactory
    implements Callback<ListView<TableData>, ListCell<TableData>> {
        public ListCell<TableData> call(ListView<TableData> list) {
            return new ListCell<TableData>(){

                public void updateItem(TableData tableData, boolean empty) {
                    super.updateItem((Object)tableData, empty);
                    if (empty) {
                        this.setText(null);
                        this.setGraphic(null);
                    } else {
                        this.setText(null);
                        this.setGraphic(tableData.getNode());
                    }
                }
            };
        }
    }

    static class TableData {
        private final String tableName;
        private final Map<String, ForeignKeyData> refsToOther = new TreeMap<String, ForeignKeyData>();
        private final Map<String, ForeignKeyData> refsFromOther = new TreeMap<String, ForeignKeyData>();
        private final Map<String, FieldData> fields = new TreeMap<String, FieldData>();
        private int pkSize;
        private Node node;
        private TableDataController controller;

        public TableData(String tableName) {
            this.tableName = tableName;
            this.getNode();
        }

        public Node getNode() {
            if (this.node == null) {
                try {
                    FXMLLoader loader = new FXMLLoader(TableDataController.class.getResource("/fxml/TableData.fxml"));
                    this.node = (Pane)loader.load();
                    this.controller = (TableDataController)loader.getController();
                    this.controller.setTableName(this.tableName);
                    String prettyName = CaseUtils.toCamelCase((String)this.tableName, (boolean)true, (char[])new char[]{'_'});
                    this.controller.setSingular(prettyName);
                    this.controller.setPlural(prettyName + "Set");
                }
                catch (IOException ex) {
                    LOGGER.error("Failed to load FXML", (Throwable)ex);
                }
            }
            return this.node;
        }

        public String getTableName() {
            return this.tableName;
        }

        public String getEntityName() {
            return this.controller.getSingular();
        }

        public String getEntityPlural() {
            return this.controller.getPlural();
        }

        public TableChoice getTableType() {
            return this.controller.getChoice();
        }

        public boolean isEntityType() {
            return this.controller.getChoice() == TableChoice.ENTITY_TYPE;
        }

        public boolean isLinkTable() {
            return this.controller.getChoice() == TableChoice.LINK_TABLE;
        }

        public boolean isIgnored() {
            return this.controller.getChoice() == TableChoice.IGNORE;
        }

        public void addReferenceToOther(ForeignKeyData fk) {
            this.refsToOther.put(fk.otherTableName, fk);
        }

        public void addReferenceFromOther(ForeignKeyData fk) {
            this.refsFromOther.put(fk.myTableName, fk);
        }

        public void setPkSize(int pkSize) {
            this.pkSize = pkSize;
        }

        public void analyse() {
            if ((this.pkSize == 0 || this.pkSize > 1) && this.refsToOther.size() == 2) {
                this.controller.setChoice(TableChoice.LINK_TABLE);
                return;
            }
            if (this.pkSize == 1 && this.refsFromOther.size() + this.refsToOther.size() > 0) {
                this.controller.setChoice(TableChoice.ENTITY_TYPE);
                return;
            }
            this.controller.setChoice(TableChoice.IGNORE);
        }

        public Map<String, FieldData> getFields() {
            return this.fields;
        }

        public boolean hasField(String fieldName) {
            return this.fields.containsKey(fieldName.toLowerCase());
        }

        public FieldData getField(String fieldName) {
            return this.fields.get(fieldName.toLowerCase());
        }

        public void addFields(List<Field> tableFields, boolean pks) {
            for (Field field : tableFields) {
                String fieldName = field.getName();
                if (this.fields.containsKey(fieldName.toLowerCase())) continue;
                FieldData fieldData = FieldData.from(field, pks);
                this.fields.put(fieldData.name.toLowerCase(), fieldData);
            }
        }

        public String toString() {
            return this.tableName;
        }
    }

    private static class ForeignKeyData {
        final String myTableName;
        final String otherTableName;
        FieldData fieldMine;
        FieldData fieldTheirs;

        public ForeignKeyData(String myTableName, String otherTableName) {
            this.myTableName = myTableName;
            this.otherTableName = otherTableName;
        }

        public ForeignKeyData setFieldMine(FieldData fieldMine) {
            this.fieldMine = fieldMine;
            return this;
        }

        public ForeignKeyData setFieldTheirs(FieldData fieldTheirs) {
            this.fieldTheirs = fieldTheirs;
            return this;
        }

        public String toString() {
            return this.myTableName + "." + this.fieldMine.name + " -> " + this.otherTableName + "." + this.fieldTheirs.name;
        }
    }

    private static class FieldData {
        final String name;
        boolean pk;
        boolean fk;
        String typeName;
        String castTypeName;
        String comment;

        public static FieldData from(Field field, boolean pk) {
            return new FieldData(field.getName()).setPk(pk).setTypeName(field.getDataType().getTypeName()).setCastTypeName(field.getDataType().getCastTypeName()).setComment(field.getComment());
        }

        public FieldData(String name) {
            this.name = name;
        }

        public FieldData setPk(boolean pk) {
            this.pk = pk;
            return this;
        }

        public FieldData setFk(boolean fk) {
            this.fk = fk;
            return this;
        }

        public FieldData setTypeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public FieldData setCastTypeName(String castTypeName) {
            this.castTypeName = castTypeName;
            return this;
        }

        public FieldData setComment(String comment) {
            this.comment = comment;
            return this;
        }

        public String toString() {
            return this.name + "(" + this.typeName + " / " + this.castTypeName + ") " + (this.pk ? "PK" : "") + (this.fk ? "FK" : "");
        }
    }

    public static enum TableChoice {
        IGNORE("-"),
        ENTITY_TYPE("Entity"),
        LINK_TABLE("Link");

        private final String label;

        private TableChoice(String label) {
            this.label = label;
        }

        public String toString() {
            return this.label;
        }
    }
}

