/*
 * Decompiled with CFR 0.152.
 */
package org.threeten.extra;

import java.io.Serializable;
import java.time.Clock;
import java.time.DateTimeException;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.Month;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.chrono.IsoChronology;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAdjuster;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalQueries;
import java.time.temporal.TemporalQuery;
import java.time.temporal.TemporalUnit;
import java.time.temporal.ValueRange;
import java.time.zone.ZoneRules;
import java.util.Objects;
import org.joda.convert.FromString;
import org.joda.convert.ToString;

public final class OffsetDate
implements Temporal,
TemporalAdjuster,
Comparable<OffsetDate>,
Serializable {
    public static final OffsetDate MIN = OffsetDate.of(LocalDate.MIN, ZoneOffset.MAX);
    public static final OffsetDate MAX = OffsetDate.of(LocalDate.MAX, ZoneOffset.MIN);
    private static final long serialVersionUID = -4382054179074397774L;
    private static final long SECONDS_PER_DAY = 86400L;
    private final LocalDate date;
    private final ZoneOffset offset;

    public static OffsetDate now() {
        return OffsetDate.now(Clock.systemDefaultZone());
    }

    public static OffsetDate now(ZoneId zone) {
        return OffsetDate.now(Clock.system(zone));
    }

    public static OffsetDate now(Clock clock) {
        Objects.requireNonNull(clock, "clock");
        Instant now = clock.instant();
        return OffsetDate.ofInstant(now, clock.getZone().getRules().getOffset(now));
    }

    public static OffsetDate of(LocalDate date, ZoneOffset offset) {
        return new OffsetDate(date, offset);
    }

    public static OffsetDate of(int year, int month, int dayOfMonth, ZoneOffset offset) {
        LocalDate d2 = LocalDate.of(year, month, dayOfMonth);
        return new OffsetDate(d2, offset);
    }

    public static OffsetDate ofInstant(Instant instant, ZoneId zone) {
        Objects.requireNonNull(instant, "instant");
        Objects.requireNonNull(zone, "zone");
        ZoneRules rules = zone.getRules();
        ZoneOffset offset = rules.getOffset(instant);
        long epochSec = instant.getEpochSecond() + (long)offset.getTotalSeconds();
        long epochDay = Math.floorDiv(epochSec, 86400L);
        LocalDate date = LocalDate.ofEpochDay(epochDay);
        return new OffsetDate(date, offset);
    }

    public static OffsetDate from(TemporalAccessor temporal) {
        if (temporal instanceof OffsetDate) {
            return (OffsetDate)temporal;
        }
        try {
            LocalDate date = LocalDate.from(temporal);
            ZoneOffset offset = ZoneOffset.from(temporal);
            return new OffsetDate(date, offset);
        }
        catch (DateTimeException ex2) {
            throw new DateTimeException("Unable to obtain OffsetDate from TemporalAccessor: " + temporal.getClass(), ex2);
        }
    }

    @FromString
    public static OffsetDate parse(CharSequence text) {
        return OffsetDate.parse(text, DateTimeFormatter.ISO_OFFSET_DATE);
    }

    public static OffsetDate parse(CharSequence text, DateTimeFormatter formatter) {
        Objects.requireNonNull(formatter, "formatter");
        return formatter.parse(text, OffsetDate::from);
    }

    private OffsetDate(LocalDate date, ZoneOffset offset) {
        this.date = Objects.requireNonNull(date, "date");
        this.offset = Objects.requireNonNull(offset, "offset");
    }

    private Object readResolve() {
        return OffsetDate.of(this.date, this.offset);
    }

    private OffsetDate with(LocalDate date, ZoneOffset offset) {
        if (this.date == date && this.offset.equals(offset)) {
            return this;
        }
        return new OffsetDate(date, offset);
    }

    @Override
    public boolean isSupported(TemporalField field) {
        if (field instanceof ChronoField) {
            return field.isDateBased() || field == ChronoField.OFFSET_SECONDS;
        }
        return field != null && field.isSupportedBy(this);
    }

    @Override
    public boolean isSupported(TemporalUnit unit) {
        if (unit instanceof ChronoUnit) {
            return unit.isDateBased();
        }
        return unit != null && unit.isSupportedBy(this);
    }

    @Override
    public ValueRange range(TemporalField field) {
        if (field instanceof ChronoField) {
            if (field == ChronoField.OFFSET_SECONDS) {
                return field.range();
            }
            return this.date.range(field);
        }
        return field.rangeRefinedBy(this);
    }

    @Override
    public int get(TemporalField field) {
        return Temporal.super.get(field);
    }

    @Override
    public long getLong(TemporalField field) {
        if (field instanceof ChronoField) {
            if (field == ChronoField.OFFSET_SECONDS) {
                return this.getOffset().getTotalSeconds();
            }
            return this.date.getLong(field);
        }
        return field.getFrom(this);
    }

    public ZoneOffset getOffset() {
        return this.offset;
    }

    public OffsetDate withOffsetSameLocal(ZoneOffset offset) {
        Objects.requireNonNull(offset, "offset");
        return this.with(this.date, offset);
    }

    public LocalDate toLocalDate() {
        return this.date;
    }

    public int getYear() {
        return this.date.getYear();
    }

    public int getMonthValue() {
        return this.date.getMonthValue();
    }

    public Month getMonth() {
        return this.date.getMonth();
    }

    public int getDayOfMonth() {
        return this.date.getDayOfMonth();
    }

    public int getDayOfYear() {
        return this.date.getDayOfYear();
    }

    public DayOfWeek getDayOfWeek() {
        return this.date.getDayOfWeek();
    }

    @Override
    public OffsetDate with(TemporalAdjuster adjuster) {
        if (adjuster instanceof LocalDate) {
            return this.with((LocalDate)adjuster, this.offset);
        }
        if (adjuster instanceof ZoneOffset) {
            return this.with(this.date, (ZoneOffset)adjuster);
        }
        if (adjuster instanceof OffsetDate) {
            return (OffsetDate)adjuster;
        }
        return (OffsetDate)adjuster.adjustInto(this);
    }

    @Override
    public OffsetDate with(TemporalField field, long newValue) {
        if (field instanceof ChronoField) {
            if (field == ChronoField.OFFSET_SECONDS) {
                ChronoField f2 = (ChronoField)field;
                return this.with(this.date, ZoneOffset.ofTotalSeconds(f2.checkValidIntValue(newValue)));
            }
            return this.with(this.date.with(field, newValue), this.offset);
        }
        return field.adjustInto(this, newValue);
    }

    public OffsetDate withYear(int year) {
        return this.with(this.date.withYear(year), this.offset);
    }

    public OffsetDate withMonth(int month) {
        return this.with(this.date.withMonth(month), this.offset);
    }

    public OffsetDate withDayOfMonth(int dayOfMonth) {
        return this.with(this.date.withDayOfMonth(dayOfMonth), this.offset);
    }

    public OffsetDate withDayOfYear(int dayOfYear) {
        return this.with(this.date.withDayOfYear(dayOfYear), this.offset);
    }

    @Override
    public OffsetDate plus(TemporalAmount amountToAdd) {
        return (OffsetDate)amountToAdd.addTo(this);
    }

    @Override
    public OffsetDate plus(long amountToAdd, TemporalUnit unit) {
        if (unit instanceof ChronoUnit) {
            return this.with(this.date.plus(amountToAdd, unit), this.offset);
        }
        return unit.addTo(this, amountToAdd);
    }

    public OffsetDate plusYears(long years) {
        return this.with(this.date.plusYears(years), this.offset);
    }

    public OffsetDate plusMonths(long months) {
        return this.with(this.date.plusMonths(months), this.offset);
    }

    public OffsetDate plusWeeks(long weeks) {
        return this.with(this.date.plusWeeks(weeks), this.offset);
    }

    public OffsetDate plusDays(long days) {
        return this.with(this.date.plusDays(days), this.offset);
    }

    @Override
    public OffsetDate minus(TemporalAmount amountToSubtract) {
        return (OffsetDate)amountToSubtract.subtractFrom(this);
    }

    @Override
    public OffsetDate minus(long amountToSubtract, TemporalUnit unit) {
        return amountToSubtract == Long.MIN_VALUE ? this.plus(Long.MAX_VALUE, unit).plus(1L, unit) : this.plus(-amountToSubtract, unit);
    }

    public OffsetDate minusYears(long years) {
        return this.with(this.date.minusYears(years), this.offset);
    }

    public OffsetDate minusMonths(long months) {
        return this.with(this.date.minusMonths(months), this.offset);
    }

    public OffsetDate minusWeeks(long weeks) {
        return this.with(this.date.minusWeeks(weeks), this.offset);
    }

    public OffsetDate minusDays(long days) {
        return this.with(this.date.minusDays(days), this.offset);
    }

    @Override
    public <R> R query(TemporalQuery<R> query) {
        if (query == TemporalQueries.chronology()) {
            return (R)IsoChronology.INSTANCE;
        }
        if (query == TemporalQueries.precision()) {
            return (R)ChronoUnit.DAYS;
        }
        if (query == TemporalQueries.offset() || query == TemporalQueries.zone()) {
            return (R)this.getOffset();
        }
        return Temporal.super.query(query);
    }

    @Override
    public Temporal adjustInto(Temporal temporal) {
        return temporal.with(ChronoField.OFFSET_SECONDS, this.getOffset().getTotalSeconds()).with(ChronoField.EPOCH_DAY, this.toLocalDate().toEpochDay());
    }

    @Override
    public long until(Temporal endExclusive, TemporalUnit unit) {
        OffsetDate end = OffsetDate.from(endExclusive);
        if (unit instanceof ChronoUnit) {
            long offsetDiff = end.offset.getTotalSeconds() - this.offset.getTotalSeconds();
            LocalDate endLocal = end.date.plusDays(Math.floorDiv(-offsetDiff, 86400L));
            return this.date.until(endLocal, unit);
        }
        return unit.between(this, end);
    }

    public String format(DateTimeFormatter formatter) {
        Objects.requireNonNull(formatter, "formatter");
        return formatter.format(this);
    }

    public OffsetDateTime atTime(LocalTime time) {
        return OffsetDateTime.of(this.date, time, this.offset);
    }

    private long toEpochSecond() {
        long epochDay = this.date.toEpochDay();
        long secs = epochDay * 86400L;
        return secs - (long)this.offset.getTotalSeconds();
    }

    public long toEpochSecond(LocalTime time) {
        Objects.requireNonNull(time, "time");
        return this.toEpochSecond() + (long)time.toSecondOfDay();
    }

    @Override
    public int compareTo(OffsetDate other) {
        if (this.offset.equals(other.offset)) {
            return this.date.compareTo(other.date);
        }
        int compare = Long.compare(this.toEpochSecond(), other.toEpochSecond());
        if (compare == 0) {
            compare = this.date.compareTo(other.date);
        }
        return compare;
    }

    public boolean isAfter(OffsetDate other) {
        return this.toEpochSecond() > other.toEpochSecond();
    }

    public boolean isBefore(OffsetDate other) {
        return this.toEpochSecond() < other.toEpochSecond();
    }

    public boolean isEqual(OffsetDate other) {
        return this.toEpochSecond() == other.toEpochSecond();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof OffsetDate) {
            OffsetDate other = (OffsetDate)obj;
            return this.date.equals(other.date) && this.offset.equals(other.offset);
        }
        return false;
    }

    public int hashCode() {
        return this.date.hashCode() ^ this.offset.hashCode();
    }

    @ToString
    public String toString() {
        return this.date.toString() + this.offset.toString();
    }
}

