/*
 * Decompiled with CFR 0.152.
 */
package org.threeten.extra;

import java.io.Serializable;
import java.time.DateTimeException;
import java.time.Period;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalUnit;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.joda.convert.FromString;
import org.joda.convert.ToString;
import org.threeten.extra.Temporals;

public final class Days
implements TemporalAmount,
Comparable<Days>,
Serializable {
    public static final Days ZERO = new Days(0);
    public static final Days ONE = new Days(1);
    private static final long serialVersionUID = -8903767091325669093L;
    private static final int DAYS_PER_WEEK = 7;
    private static final Pattern PATTERN = Pattern.compile("([-+]?)P(?:([-+]?[0-9]+)W)?(?:([-+]?[0-9]+)D)?", 2);
    private final int days;

    public static Days of(int days) {
        if (days == 0) {
            return ZERO;
        }
        if (days == 1) {
            return ONE;
        }
        return new Days(days);
    }

    public static Days ofWeeks(int weeks) {
        if (weeks == 0) {
            return ZERO;
        }
        return new Days(Math.multiplyExact(weeks, 7));
    }

    public static Days from(TemporalAmount amount) {
        if (amount instanceof Days) {
            return (Days)amount;
        }
        Objects.requireNonNull(amount, "amount");
        int days = 0;
        for (TemporalUnit unit : amount.getUnits()) {
            long value = amount.get(unit);
            if (value == 0L) continue;
            long[] converted = Temporals.convertAmount(value, unit, ChronoUnit.DAYS);
            if (converted[1] != 0L) {
                throw new DateTimeException("Amount could not be converted to a whole number of days: " + value + " " + unit);
            }
            days = Math.addExact(days, Math.toIntExact(converted[0]));
        }
        return Days.of(days);
    }

    @FromString
    public static Days parse(CharSequence text) {
        Objects.requireNonNull(text, "text");
        Matcher matcher = PATTERN.matcher(text);
        if (matcher.matches()) {
            int negate = "-".equals(matcher.group(1)) ? -1 : 1;
            String weeksStr = matcher.group(2);
            String daysStr = matcher.group(3);
            if (weeksStr != null || daysStr != null) {
                int days = 0;
                if (daysStr != null) {
                    try {
                        days = Integer.parseInt(daysStr);
                    }
                    catch (NumberFormatException ex2) {
                        throw new DateTimeParseException("Text cannot be parsed to a Days, non-numeric days", text, 0, ex2);
                    }
                }
                if (weeksStr != null) {
                    try {
                        int weeks = Math.multiplyExact(Integer.parseInt(weeksStr), 7);
                        days = Math.addExact(days, weeks);
                    }
                    catch (NumberFormatException ex3) {
                        throw new DateTimeParseException("Text cannot be parsed to a Days, non-numeric weeks", text, 0, ex3);
                    }
                }
                return Days.of(Math.multiplyExact(days, negate));
            }
        }
        throw new DateTimeParseException("Text cannot be parsed to a Days", text, 0);
    }

    public static Days between(Temporal startDateInclusive, Temporal endDateExclusive) {
        return Days.of(Math.toIntExact(ChronoUnit.DAYS.between(startDateInclusive, endDateExclusive)));
    }

    private Days(int days) {
        this.days = days;
    }

    private Object readResolve() {
        return Days.of(this.days);
    }

    @Override
    public long get(TemporalUnit unit) {
        if (unit == ChronoUnit.DAYS) {
            return this.days;
        }
        throw new UnsupportedTemporalTypeException("Unsupported unit: " + unit);
    }

    @Override
    public List<TemporalUnit> getUnits() {
        return Collections.singletonList(ChronoUnit.DAYS);
    }

    public int getAmount() {
        return this.days;
    }

    public boolean isNegative() {
        return this.getAmount() < 0;
    }

    public boolean isZero() {
        return this.getAmount() == 0;
    }

    public boolean isPositive() {
        return this.getAmount() > 0;
    }

    public Days plus(TemporalAmount amountToAdd) {
        return this.plus(Days.from(amountToAdd).getAmount());
    }

    public Days plus(int days) {
        if (days == 0) {
            return this;
        }
        return Days.of(Math.addExact(this.days, days));
    }

    public Days minus(TemporalAmount amountToSubtract) {
        return this.minus(Days.from(amountToSubtract).getAmount());
    }

    public Days minus(int days) {
        if (days == 0) {
            return this;
        }
        return Days.of(Math.subtractExact(this.days, days));
    }

    public Days multipliedBy(int scalar) {
        if (scalar == 1) {
            return this;
        }
        return Days.of(Math.multiplyExact(this.days, scalar));
    }

    public Days dividedBy(int divisor) {
        if (divisor == 1) {
            return this;
        }
        return Days.of(this.days / divisor);
    }

    public Days negated() {
        return this.multipliedBy(-1);
    }

    public Days abs() {
        return this.days < 0 ? this.negated() : this;
    }

    public Period toPeriod() {
        return Period.ofDays(this.days);
    }

    @Override
    public Temporal addTo(Temporal temporal) {
        if (this.days != 0) {
            temporal = temporal.plus(this.days, ChronoUnit.DAYS);
        }
        return temporal;
    }

    @Override
    public Temporal subtractFrom(Temporal temporal) {
        if (this.days != 0) {
            temporal = temporal.minus(this.days, ChronoUnit.DAYS);
        }
        return temporal;
    }

    @Override
    public int compareTo(Days otherAmount) {
        int thisValue = this.days;
        int otherValue = otherAmount.days;
        return Integer.compare(thisValue, otherValue);
    }

    public boolean equals(Object otherAmount) {
        if (this == otherAmount) {
            return true;
        }
        if (otherAmount instanceof Days) {
            Days other = (Days)otherAmount;
            return this.days == other.days;
        }
        return false;
    }

    public int hashCode() {
        return this.days;
    }

    @ToString
    public String toString() {
        return "P" + this.days + "D";
    }
}

