/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.shaded.com.ongres.scram.common.bouncycastle.pbkdf2;

import org.postgresql.shaded.com.ongres.scram.common.bouncycastle.pbkdf2.EncodableDigest;
import org.postgresql.shaded.com.ongres.scram.common.bouncycastle.pbkdf2.GeneralDigest;
import org.postgresql.shaded.com.ongres.scram.common.bouncycastle.pbkdf2.Memoable;
import org.postgresql.shaded.com.ongres.scram.common.bouncycastle.pbkdf2.Pack;

public class SHA256Digest
extends GeneralDigest
implements EncodableDigest {
    private static final int DIGEST_LENGTH = 32;
    private int H1;
    private int H2;
    private int H3;
    private int H4;
    private int H5;
    private int H6;
    private int H7;
    private int H8;
    private int[] X = new int[64];
    private int xOff;
    static final int[] K = new int[]{1116352408, 1899447441, -1245643825, -373957723, 961987163, 1508970993, -1841331548, -1424204075, -670586216, 310598401, 607225278, 1426881987, 1925078388, -2132889090, -1680079193, -1046744716, -459576895, -272742522, 264347078, 604807628, 770255983, 1249150122, 1555081692, 1996064986, -1740746414, -1473132947, -1341970488, -1084653625, -958395405, -710438585, 113926993, 338241895, 666307205, 773529912, 1294757372, 1396182291, 1695183700, 1986661051, -2117940946, -1838011259, -1564481375, -1474664885, -1035236496, -949202525, -778901479, -694614492, -200395387, 275423344, 430227734, 506948616, 659060556, 883997877, 958139571, 1322822218, 1537002063, 1747873779, 1955562222, 2024104815, -2067236844, -1933114872, -1866530822, -1538233109, -1090935817, -965641998};

    public SHA256Digest() {
        this.reset();
    }

    public SHA256Digest(SHA256Digest t2) {
        super(t2);
        this.copyIn(t2);
    }

    private void copyIn(SHA256Digest t2) {
        super.copyIn(t2);
        this.H1 = t2.H1;
        this.H2 = t2.H2;
        this.H3 = t2.H3;
        this.H4 = t2.H4;
        this.H5 = t2.H5;
        this.H6 = t2.H6;
        this.H7 = t2.H7;
        this.H8 = t2.H8;
        System.arraycopy(t2.X, 0, this.X, 0, t2.X.length);
        this.xOff = t2.xOff;
    }

    public SHA256Digest(byte[] encodedState) {
        super(encodedState);
        this.H1 = Pack.bigEndianToInt(encodedState, 16);
        this.H2 = Pack.bigEndianToInt(encodedState, 20);
        this.H3 = Pack.bigEndianToInt(encodedState, 24);
        this.H4 = Pack.bigEndianToInt(encodedState, 28);
        this.H5 = Pack.bigEndianToInt(encodedState, 32);
        this.H6 = Pack.bigEndianToInt(encodedState, 36);
        this.H7 = Pack.bigEndianToInt(encodedState, 40);
        this.H8 = Pack.bigEndianToInt(encodedState, 44);
        this.xOff = Pack.bigEndianToInt(encodedState, 48);
        for (int i2 = 0; i2 != this.xOff; ++i2) {
            this.X[i2] = Pack.bigEndianToInt(encodedState, 52 + i2 * 4);
        }
    }

    @Override
    public String getAlgorithmName() {
        return "SHA-256";
    }

    @Override
    public int getDigestSize() {
        return 32;
    }

    @Override
    protected void processWord(byte[] in2, int inOff) {
        int n2 = in2[inOff] << 24;
        n2 |= (in2[++inOff] & 0xFF) << 16;
        n2 |= (in2[++inOff] & 0xFF) << 8;
        this.X[this.xOff] = n2 |= in2[++inOff] & 0xFF;
        if (++this.xOff == 16) {
            this.processBlock();
        }
    }

    @Override
    protected void processLength(long bitLength) {
        if (this.xOff > 14) {
            this.processBlock();
        }
        this.X[14] = (int)(bitLength >>> 32);
        this.X[15] = (int)(bitLength & 0xFFFFFFFFFFFFFFFFL);
    }

    @Override
    public int doFinal(byte[] out, int outOff) {
        this.finish();
        Pack.intToBigEndian(this.H1, out, outOff);
        Pack.intToBigEndian(this.H2, out, outOff + 4);
        Pack.intToBigEndian(this.H3, out, outOff + 8);
        Pack.intToBigEndian(this.H4, out, outOff + 12);
        Pack.intToBigEndian(this.H5, out, outOff + 16);
        Pack.intToBigEndian(this.H6, out, outOff + 20);
        Pack.intToBigEndian(this.H7, out, outOff + 24);
        Pack.intToBigEndian(this.H8, out, outOff + 28);
        this.reset();
        return 32;
    }

    @Override
    public void reset() {
        super.reset();
        this.H1 = 1779033703;
        this.H2 = -1150833019;
        this.H3 = 1013904242;
        this.H4 = -1521486534;
        this.H5 = 1359893119;
        this.H6 = -1694144372;
        this.H7 = 528734635;
        this.H8 = 1541459225;
        this.xOff = 0;
        for (int i2 = 0; i2 != this.X.length; ++i2) {
            this.X[i2] = 0;
        }
    }

    @Override
    protected void processBlock() {
        int i2;
        for (int t2 = 16; t2 <= 63; ++t2) {
            this.X[t2] = this.Theta1(this.X[t2 - 2]) + this.X[t2 - 7] + this.Theta0(this.X[t2 - 15]) + this.X[t2 - 16];
        }
        int a2 = this.H1;
        int b2 = this.H2;
        int c2 = this.H3;
        int d2 = this.H4;
        int e2 = this.H5;
        int f2 = this.H6;
        int g2 = this.H7;
        int h2 = this.H8;
        int t3 = 0;
        for (i2 = 0; i2 < 8; ++i2) {
            d2 += (h2 += this.Sum1(e2) + this.Ch(e2, f2, g2) + K[t3] + this.X[t3]);
            h2 += this.Sum0(a2) + this.Maj(a2, b2, c2);
            c2 += (g2 += this.Sum1(d2) + this.Ch(d2, e2, f2) + K[++t3] + this.X[t3]);
            g2 += this.Sum0(h2) + this.Maj(h2, a2, b2);
            b2 += (f2 += this.Sum1(c2) + this.Ch(c2, d2, e2) + K[++t3] + this.X[t3]);
            f2 += this.Sum0(g2) + this.Maj(g2, h2, a2);
            a2 += (e2 += this.Sum1(b2) + this.Ch(b2, c2, d2) + K[++t3] + this.X[t3]);
            e2 += this.Sum0(f2) + this.Maj(f2, g2, h2);
            h2 += (d2 += this.Sum1(a2) + this.Ch(a2, b2, c2) + K[++t3] + this.X[t3]);
            d2 += this.Sum0(e2) + this.Maj(e2, f2, g2);
            g2 += (c2 += this.Sum1(h2) + this.Ch(h2, a2, b2) + K[++t3] + this.X[t3]);
            c2 += this.Sum0(d2) + this.Maj(d2, e2, f2);
            f2 += (b2 += this.Sum1(g2) + this.Ch(g2, h2, a2) + K[++t3] + this.X[t3]);
            b2 += this.Sum0(c2) + this.Maj(c2, d2, e2);
            e2 += (a2 += this.Sum1(f2) + this.Ch(f2, g2, h2) + K[++t3] + this.X[t3]);
            a2 += this.Sum0(b2) + this.Maj(b2, c2, d2);
            ++t3;
        }
        this.H1 += a2;
        this.H2 += b2;
        this.H3 += c2;
        this.H4 += d2;
        this.H5 += e2;
        this.H6 += f2;
        this.H7 += g2;
        this.H8 += h2;
        this.xOff = 0;
        for (i2 = 0; i2 < 16; ++i2) {
            this.X[i2] = 0;
        }
    }

    private int Ch(int x2, int y2, int z2) {
        return x2 & y2 ^ ~x2 & z2;
    }

    private int Maj(int x2, int y2, int z2) {
        return x2 & y2 ^ x2 & z2 ^ y2 & z2;
    }

    private int Sum0(int x2) {
        return (x2 >>> 2 | x2 << 30) ^ (x2 >>> 13 | x2 << 19) ^ (x2 >>> 22 | x2 << 10);
    }

    private int Sum1(int x2) {
        return (x2 >>> 6 | x2 << 26) ^ (x2 >>> 11 | x2 << 21) ^ (x2 >>> 25 | x2 << 7);
    }

    private int Theta0(int x2) {
        return (x2 >>> 7 | x2 << 25) ^ (x2 >>> 18 | x2 << 14) ^ x2 >>> 3;
    }

    private int Theta1(int x2) {
        return (x2 >>> 17 | x2 << 15) ^ (x2 >>> 19 | x2 << 13) ^ x2 >>> 10;
    }

    @Override
    public Memoable copy() {
        return new SHA256Digest(this);
    }

    @Override
    public void reset(Memoable other) {
        SHA256Digest d2 = (SHA256Digest)other;
        this.copyIn(d2);
    }

    @Override
    public byte[] getEncodedState() {
        byte[] state = new byte[52 + this.xOff * 4];
        super.populateState(state);
        Pack.intToBigEndian(this.H1, state, 16);
        Pack.intToBigEndian(this.H2, state, 20);
        Pack.intToBigEndian(this.H3, state, 24);
        Pack.intToBigEndian(this.H4, state, 28);
        Pack.intToBigEndian(this.H5, state, 32);
        Pack.intToBigEndian(this.H6, state, 36);
        Pack.intToBigEndian(this.H7, state, 40);
        Pack.intToBigEndian(this.H8, state, 44);
        Pack.intToBigEndian(this.xOff, state, 48);
        for (int i2 = 0; i2 != this.xOff; ++i2) {
            Pack.intToBigEndian(this.X[i2], state, 52 + i2 * 4);
        }
        return state;
    }
}

