/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.shaded.com.ongres.scram.common.bouncycastle.pbkdf2;

public abstract class Pack {
    public static int bigEndianToInt(byte[] bs2, int off) {
        int n2 = bs2[off] << 24;
        n2 |= (bs2[++off] & 0xFF) << 16;
        n2 |= (bs2[++off] & 0xFF) << 8;
        return n2 |= bs2[++off] & 0xFF;
    }

    public static long bigEndianToLong(byte[] bs2, int off) {
        int hi2 = Pack.bigEndianToInt(bs2, off);
        int lo2 = Pack.bigEndianToInt(bs2, off + 4);
        return ((long)hi2 & 0xFFFFFFFFL) << 32 | (long)lo2 & 0xFFFFFFFFL;
    }

    public static void longToBigEndian(long n2, byte[] bs2, int off) {
        Pack.intToBigEndian((int)(n2 >>> 32), bs2, off);
        Pack.intToBigEndian((int)(n2 & 0xFFFFFFFFL), bs2, off + 4);
    }

    public static byte[] longToBigEndian(long[] ns2) {
        byte[] bs2 = new byte[8 * ns2.length];
        Pack.longToBigEndian(ns2, bs2, 0);
        return bs2;
    }

    public static void longToBigEndian(long[] ns2, byte[] bs2, int off) {
        for (int i2 = 0; i2 < ns2.length; ++i2) {
            Pack.longToBigEndian(ns2[i2], bs2, off);
            off += 8;
        }
    }

    public static short littleEndianToShort(byte[] bs2, int off) {
        int n2 = bs2[off] & 0xFF;
        return (short)(n2 |= (bs2[++off] & 0xFF) << 8);
    }

    public static void intToBigEndian(int n2, byte[] bs2, int off) {
        bs2[off] = (byte)(n2 >>> 24);
        bs2[++off] = (byte)(n2 >>> 16);
        bs2[++off] = (byte)(n2 >>> 8);
        bs2[++off] = (byte)n2;
    }
}

