/*
 * Decompiled with CFR 0.152.
 */
package org.postgis.binary;

public abstract class ByteSetter {
    public abstract void set(byte var1, int var2);

    public static class StringByteSetter
    extends ByteSetter {
        protected static final char[] hextypes = "0123456789ABCDEF".toCharArray();
        private char[] rep;

        public StringByteSetter(int length) {
            this.rep = new char[length * 2];
        }

        @Override
        public void set(byte b2, int index) {
            this.rep[index *= 2] = hextypes[b2 >>> 4 & 0xF];
            this.rep[index + 1] = hextypes[b2 & 0xF];
        }

        public char[] resultAsArray() {
            return this.rep;
        }

        public String result() {
            return new String(this.rep);
        }

        public String toString() {
            return new String(this.rep);
        }
    }

    public static class BinaryByteSetter
    extends ByteSetter {
        private byte[] array;

        public BinaryByteSetter(int length) {
            this.array = new byte[length];
        }

        @Override
        public void set(byte b2, int index) {
            this.array[index] = b2;
        }

        public byte[] result() {
            return this.array;
        }

        public String toString() {
            char[] arr = new char[this.array.length];
            for (int i2 = 0; i2 < this.array.length; ++i2) {
                arr[i2] = (char)(this.array[i2] & 0xFF);
            }
            return new String(arr);
        }
    }
}

