/*
 * Decompiled with CFR 0.152.
 */
package org.postgis;

import java.sql.SQLException;
import org.postgis.Geometry;
import org.postgis.GeometryCollection;
import org.postgis.LineString;
import org.postgis.MultiLineString;
import org.postgis.MultiPoint;
import org.postgis.MultiPolygon;
import org.postgis.Point;
import org.postgis.Polygon;
import org.postgis.binary.BinaryParser;

public class GeometryBuilder {
    public static final String SRIDPREFIX = "SRID=";

    public static Geometry geomFromString(String value) throws SQLException {
        return GeometryBuilder.geomFromString(value, false);
    }

    public static Geometry geomFromString(String value, boolean haveM) throws SQLException {
        BinaryParser bp2 = new BinaryParser();
        return GeometryBuilder.geomFromString(value, bp2, haveM);
    }

    public static Geometry geomFromString(String value, BinaryParser bp2) throws SQLException {
        return GeometryBuilder.geomFromString(value, bp2, false);
    }

    public static Geometry geomFromString(String value, BinaryParser bp2, boolean haveM) throws SQLException {
        Geometry result;
        value = value.trim();
        int srid = 0;
        if (value.startsWith(SRIDPREFIX)) {
            String[] parts = GeometryBuilder.splitSRID(value);
            value = parts[1].trim();
            srid = Geometry.parseSRID(Integer.parseInt(parts[0].substring(5)));
        }
        if (value.startsWith("00") || value.startsWith("01")) {
            result = bp2.parse(value);
        } else if (value.endsWith("EMPTY")) {
            result = new GeometryCollection();
        } else if (value.startsWith("MULTIPOLYGON")) {
            result = new MultiPolygon(value, haveM);
        } else if (value.startsWith("MULTILINESTRING")) {
            result = new MultiLineString(value, haveM);
        } else if (value.startsWith("MULTIPOINT")) {
            result = new MultiPoint(value, haveM);
        } else if (value.startsWith("POLYGON")) {
            result = new Polygon(value, haveM);
        } else if (value.startsWith("LINESTRING")) {
            result = new LineString(value, haveM);
        } else if (value.startsWith("POINT")) {
            result = new Point(value, haveM);
        } else if (value.startsWith("GEOMETRYCOLLECTION")) {
            result = new GeometryCollection(value, haveM);
        } else {
            throw new SQLException("Unknown type: " + value);
        }
        if (srid != 0) {
            result.srid = srid;
        }
        return result;
    }

    public static String[] splitSRID(String whole) throws SQLException {
        int index = whole.indexOf(59, 5);
        if (index == -1) {
            throw new SQLException("Error parsing Geometry - SRID not delimited with ';' ");
        }
        return new String[]{whole.substring(0, index), whole.substring(index + 1)};
    }
}

