/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.util.postgres;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jooq.EnumType;
import org.jooq.Record;
import org.jooq.exception.DataTypeException;
import org.jooq.tools.StringUtils;
import org.jooq.types.DayToSecond;
import org.jooq.types.YearToMonth;
import org.jooq.types.YearToSecond;
import org.postgresql.util.PGInterval;

public class PostgresUtils {
    private static final String POSTGRESQL_HEX_STRING_PREFIX = "\\x";
    private static final int PG_OBJECT_INIT = 0;
    private static final int PG_OBJECT_BEFORE_VALUE = 1;
    private static final int PG_OBJECT_QUOTED_VALUE = 2;
    private static final int PG_OBJECT_UNQUOTED_VALUE = 3;
    private static final int PG_OBJECT_AFTER_VALUE = 4;
    private static final int PG_OBJECT_END = 5;
    private static volatile Boolean pgIntervalAvailable;

    public static byte[] toBytes(String string) {
        if (string.startsWith(POSTGRESQL_HEX_STRING_PREFIX)) {
            return PostgresUtils.toBytesFromHexEncoding(string);
        }
        return PostgresUtils.toBytesFromOctalEncoding(string);
    }

    private static byte[] toBytesFromOctalEncoding(String string) {
        StringReader reader = new StringReader(string);
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        try {
            PostgresUtils.convertOctalToBytes(reader, bytes);
            return bytes.toByteArray();
        }
        catch (IOException x2) {
            throw new DataTypeException("failed to parse octal hex string: " + x2.getMessage(), x2);
        }
    }

    private static void convertOctalToBytes(Reader reader, OutputStream bytes) throws IOException {
        int ch2;
        while ((ch2 = reader.read()) != -1) {
            if (ch2 == 92) {
                ch2 = reader.read();
                if (ch2 == -1) {
                    throw new DataTypeException("unexpected end of stream after initial backslash");
                }
                if (ch2 == 92) {
                    bytes.write(92);
                    continue;
                }
                int val = PostgresUtils.octalValue(ch2);
                ch2 = reader.read();
                if (ch2 == -1) {
                    throw new DataTypeException("unexpected end of octal value");
                }
                val <<= 3;
                val += PostgresUtils.octalValue(ch2);
                ch2 = reader.read();
                if (ch2 == -1) {
                    throw new DataTypeException("unexpected end of octal value");
                }
                val <<= 3;
                bytes.write(val += PostgresUtils.octalValue(ch2));
                continue;
            }
            bytes.write(ch2);
        }
    }

    private static byte[] toBytesFromHexEncoding(String string) {
        String hex = string.substring(POSTGRESQL_HEX_STRING_PREFIX.length());
        StringReader input = new StringReader(hex);
        ByteArrayOutputStream bytes = new ByteArrayOutputStream(hex.length() / 2);
        try {
            int hexDigit;
            while ((hexDigit = input.read()) != -1) {
                int byteValue = PostgresUtils.hexValue(hexDigit) << 4;
                hexDigit = input.read();
                if (hexDigit != -1) {
                    bytes.write(byteValue += PostgresUtils.hexValue(hexDigit));
                    continue;
                }
                break;
            }
        }
        catch (IOException e2) {
            throw new DataTypeException("Error while decoding hex string", e2);
        }
        input.close();
        return bytes.toByteArray();
    }

    private static int hexValue(int hexDigit) {
        if (hexDigit >= 48 && hexDigit <= 57) {
            return hexDigit - 48;
        }
        if (hexDigit >= 97 && hexDigit <= 102) {
            return hexDigit - 97 + 10;
        }
        if (hexDigit >= 65 && hexDigit <= 70) {
            return hexDigit - 65 + 10;
        }
        throw new DataTypeException("unknown postgresql character format for hexValue: " + hexDigit);
    }

    private static int octalValue(int octalDigit) {
        if (octalDigit < 48 || octalDigit > 55) {
            throw new DataTypeException("unknown postgresql character format for octalValue: " + octalDigit);
        }
        return octalDigit - 48;
    }

    public static Object toPGInterval(DayToSecond interval) {
        return new PGInterval(0, 0, interval.getSign() * interval.getDays(), interval.getSign() * interval.getHours(), interval.getSign() * interval.getMinutes(), (double)(interval.getSign() * interval.getSeconds()) + (double)(interval.getSign() * interval.getNano()) / 1.0E9);
    }

    public static Object toPGInterval(YearToSecond interval) {
        return new PGInterval(interval.getSign() * interval.getYears(), interval.getSign() * interval.getMonths(), interval.getSign() * interval.getDays(), interval.getSign() * interval.getHours(), interval.getSign() * interval.getMinutes(), (double)(interval.getSign() * interval.getSeconds()) + (double)(interval.getSign() * interval.getNano()) / 1.0E9);
    }

    public static Object toPGInterval(YearToMonth interval) {
        return new PGInterval(interval.getSign() * interval.getYears(), interval.getSign() * interval.getMonths(), 0, 0, 0, 0.0);
    }

    public static DayToSecond toDayToSecond(Object pgInterval) {
        boolean negative = pgInterval.toString().contains("-");
        if (PostgresUtils.pgIntervalAvailable() && pgInterval instanceof PGInterval) {
            PGInterval i2 = (PGInterval)pgInterval;
            if (negative) {
                i2.scale(-1);
            }
            Double seconds = i2.getSeconds();
            DayToSecond result = new DayToSecond(i2.getDays(), i2.getHours(), i2.getMinutes(), seconds.intValue(), (int)(1.0E9 * (seconds - (double)seconds.intValue())));
            if (negative) {
                result = result.neg();
            }
            return result;
        }
        throw new IllegalArgumentException("Unsupported interval type. Make sure you have the pgjdbc or redshift driver on your classpath: " + pgInterval);
    }

    public static YearToMonth toYearToMonth(Object pgInterval) {
        boolean negative = pgInterval.toString().contains("-");
        if (PostgresUtils.pgIntervalAvailable() && pgInterval instanceof PGInterval) {
            PGInterval i2 = (PGInterval)pgInterval;
            if (negative) {
                i2.scale(-1);
            }
            YearToMonth result = new YearToMonth(i2.getYears(), i2.getMonths());
            if (negative) {
                result = result.neg();
            }
            return result;
        }
        throw new IllegalArgumentException("Unsupported interval type. Make sure you have the pgjdbc or redshift driver on your classpath: " + pgInterval);
    }

    public static YearToSecond toYearToSecond(Object pgInterval) {
        return new YearToSecond(PostgresUtils.toYearToMonth(pgInterval), PostgresUtils.toDayToSecond(pgInterval));
    }

    public static List<String> toPGArray(String input) {
        if ("{}".equals(input)) {
            return Collections.emptyList();
        }
        return PostgresUtils.toPGObjectOrArray(input, '{', '}');
    }

    public static List<String> toPGObject(String input) {
        return PostgresUtils.toPGObjectOrArray(input, '(', ')');
    }

    private static List<String> toPGObjectOrArray(String input, char open, char close) {
        ArrayList<String> values = new ArrayList<String>();
        int state = 0;
        StringBuilder sb = null;
        block7: for (int i2 = 0; i2 < input.length(); ++i2) {
            char c2 = input.charAt(i2);
            switch (state) {
                case 0: {
                    if (c2 != open) continue block7;
                    state = 1;
                    continue block7;
                }
                case 1: {
                    sb = new StringBuilder();
                    if (c2 == ',') {
                        values.add(null);
                        state = 1;
                        continue block7;
                    }
                    if (c2 == close) {
                        values.add(null);
                        state = 5;
                        continue block7;
                    }
                    if (c2 == '\"') {
                        state = 2;
                        continue block7;
                    }
                    if ((c2 == 'n' || c2 == 'N') && i2 + 4 < input.length() && open == '{' && input.substring(i2, i2 + 4).equalsIgnoreCase("null")) {
                        values.add(null);
                        i2 += 3;
                        state = 4;
                        continue block7;
                    }
                    sb.append(c2);
                    state = 3;
                    continue block7;
                }
                case 2: {
                    if (c2 == '\"') {
                        if (input.charAt(i2 + 1) == '\"') {
                            sb.append(c2);
                            ++i2;
                            continue block7;
                        }
                        values.add(sb.toString());
                        state = 4;
                        continue block7;
                    }
                    if (c2 == '\\') {
                        char n2 = input.charAt(i2 + 1);
                        if (n2 == '\\' || n2 == '\"') {
                            sb.append(n2);
                            ++i2;
                            continue block7;
                        }
                        sb.append(c2);
                        continue block7;
                    }
                    sb.append(c2);
                    continue block7;
                }
                case 3: {
                    if (c2 == close) {
                        values.add(sb.toString());
                        state = 5;
                        continue block7;
                    }
                    if (c2 == ',') {
                        values.add(sb.toString());
                        state = 1;
                        continue block7;
                    }
                    sb.append(c2);
                    continue block7;
                }
                case 4: {
                    if (c2 == close) {
                        state = 5;
                        continue block7;
                    }
                    if (c2 != ',') continue block7;
                    state = 1;
                }
            }
        }
        return values;
    }

    public static String toPGArrayString(Object[] value) {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        String separator = "";
        for (Object o2 : value) {
            sb.append(separator);
            if (o2 == null) {
                sb.append(o2);
            } else if (o2 instanceof byte[]) {
                sb.append(PostgresUtils.toPGString((byte[])o2));
            } else {
                sb.append("\"").append(StringUtils.replace(StringUtils.replace(PostgresUtils.toPGString(o2), "\\", "\\\\"), "\"", "\\\"")).append("\"");
            }
            separator = ",";
        }
        sb.append("}");
        return sb.toString();
    }

    public static String toPGString(Object o2) {
        if (o2 instanceof byte[]) {
            return PostgresUtils.toPGString((byte[])o2);
        }
        if (o2 instanceof Object[]) {
            return PostgresUtils.toPGArrayString((Object[])o2);
        }
        if (o2 instanceof Record) {
            return PostgresUtils.toPGString((Record)o2);
        }
        if (o2 instanceof EnumType) {
            return ((EnumType)o2).getLiteral();
        }
        return "" + o2;
    }

    public static String toPGString(Record r2) {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        String separator = "";
        for (int i2 = 0; i2 < r2.size(); ++i2) {
            Object a2 = r2.field(i2).getConverter().to(r2.get(i2));
            sb.append(separator);
            if (a2 != null) {
                if (a2 instanceof byte[]) {
                    sb.append(PostgresUtils.toPGString((byte[])a2));
                } else {
                    sb.append("\"").append(StringUtils.replace(StringUtils.replace(PostgresUtils.toPGString(a2), "\\", "\\\\"), "\"", "\\\"")).append("\"");
                }
            }
            separator = ",";
        }
        sb.append(")");
        return sb.toString();
    }

    public static String toPGString(byte[] binary) {
        StringBuilder sb = new StringBuilder();
        for (byte b2 : binary) {
            sb.append("\\\\");
            sb.append(StringUtils.leftPad(Integer.toOctalString(b2 & 0xFF), 3, '0'));
        }
        return sb.toString();
    }

    private static final boolean pgIntervalAvailable() {
        if (pgIntervalAvailable == null) {
            try {
                new PGInterval();
                pgIntervalAvailable = true;
            }
            catch (NoClassDefFoundError e2) {
                pgIntervalAvailable = false;
            }
        }
        return pgIntervalAvailable;
    }
}

