/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.meta.postgres;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.Select;
import org.jooq.TableLike;
import org.jooq.TableOptions;
import org.jooq.impl.DSL;
import org.jooq.meta.AbstractTableDefinition;
import org.jooq.meta.ColumnDefinition;
import org.jooq.meta.DataTypeDefinition;
import org.jooq.meta.DefaultColumnDefinition;
import org.jooq.meta.DefaultDataTypeDefinition;
import org.jooq.meta.ParameterDefinition;
import org.jooq.meta.SchemaDefinition;
import org.jooq.meta.postgres.PostgresDatabase;
import org.jooq.meta.postgres.PostgresRoutineDefinition;
import org.jooq.meta.postgres.information_schema.Tables;
import org.jooq.meta.postgres.information_schema.tables.Columns;
import org.jooq.meta.postgres.information_schema.tables.Parameters;
import org.jooq.meta.postgres.information_schema.tables.Routines;
import org.jooq.meta.postgres.pg_catalog.tables.PgNamespace;
import org.jooq.meta.postgres.pg_catalog.tables.PgProc;
import org.jooq.meta.postgres.pg_catalog.tables.PgType;
import org.jooq.tools.StringUtils;

public class PostgresTableValuedFunction
extends AbstractTableDefinition {
    private final PostgresRoutineDefinition routine;
    private final String specificName;

    public PostgresTableValuedFunction(SchemaDefinition schema, String name, String specificName, String comment) {
        this(schema, name, specificName, comment, null);
    }

    public PostgresTableValuedFunction(SchemaDefinition schema, String name, String specificName, String comment, String source) {
        super(schema, name, comment, TableOptions.TableType.FUNCTION, source);
        this.routine = new PostgresRoutineDefinition(schema.getDatabase(), schema.getInputName(), name, specificName);
        this.specificName = specificName;
    }

    @Override
    public List<ColumnDefinition> getElements0() throws SQLException {
        ArrayList<ColumnDefinition> result = new ArrayList<ColumnDefinition>();
        Routines r2 = Tables.ROUTINES;
        Parameters p2 = Tables.PARAMETERS;
        PgNamespace pg_n = org.jooq.meta.postgres.pg_catalog.Tables.PG_NAMESPACE;
        PgProc pg_p = org.jooq.meta.postgres.pg_catalog.Tables.PG_PROC;
        Columns c2 = Tables.COLUMNS;
        PgType pg_t = org.jooq.meta.postgres.pg_catalog.Tables.PG_TYPE;
        Field<Integer> pPrecision = PostgresRoutineDefinition.pNumericPrecision(p2);
        Field cPrecision = DSL.nvl(c2.DATETIME_PRECISION, c2.NUMERIC_PRECISION);
        Field rPrecision = DSL.nvl(r2.DATETIME_PRECISION, r2.NUMERIC_PRECISION);
        for (Record record : this.create().select(p2.PARAMETER_NAME, DSL.rowNumber().over(DSL.partitionBy(p2.SPECIFIC_NAME).orderBy(p2.ORDINAL_POSITION)).as(p2.ORDINAL_POSITION), p2.DATA_TYPE, p2.CHARACTER_MAXIMUM_LENGTH, pPrecision.as(p2.NUMERIC_PRECISION), p2.NUMERIC_SCALE, DSL.inline("true").as(c2.IS_NULLABLE), (((PostgresDatabase)this.getDatabase()).is94() ? Tables.PARAMETERS.PARAMETER_DEFAULT : DSL.inline((String)null)).as(c2.COLUMN_DEFAULT), p2.UDT_SCHEMA, p2.UDT_NAME).from((TableLike<?>)r2).join(p2).on(DSL.row(r2.SPECIFIC_CATALOG, r2.SPECIFIC_SCHEMA, r2.SPECIFIC_NAME).eq(p2.SPECIFIC_CATALOG, p2.SPECIFIC_SCHEMA, p2.SPECIFIC_NAME)).join(pg_n).on(r2.SPECIFIC_SCHEMA.eq(pg_n.NSPNAME)).join(pg_p).on(pg_p.PRONAMESPACE.eq(pg_n.OID)).and(pg_p.PRONAME.concat("_").concat(pg_p.OID).eq(r2.SPECIFIC_NAME)).where(r2.SPECIFIC_NAME.eq(this.specificName)).and(p2.PARAMETER_MODE.ne("IN")).and(pg_p.PRORETSET).unionAll((Select)DSL.select(DSL.coalesce(c2.COLUMN_NAME, this.getName()).as(c2.COLUMN_NAME), DSL.coalesce(c2.ORDINAL_POSITION, new Field[]{DSL.inline(1)}).as(c2.ORDINAL_POSITION), DSL.coalesce(c2.DATA_TYPE, new Field[]{r2.DATA_TYPE}).as(c2.DATA_TYPE), DSL.coalesce(c2.CHARACTER_MAXIMUM_LENGTH, new Field[]{r2.CHARACTER_MAXIMUM_LENGTH}).as(c2.CHARACTER_MAXIMUM_LENGTH), DSL.coalesce(cPrecision, rPrecision).as(c2.NUMERIC_PRECISION), DSL.coalesce(c2.NUMERIC_SCALE, new Field[]{r2.NUMERIC_SCALE}).as(c2.NUMERIC_SCALE), DSL.coalesce(c2.IS_NULLABLE, "true").as(c2.IS_NULLABLE), DSL.coalesce(c2.COLUMN_DEFAULT, new Field[]{DSL.inline((String)null)}).as(c2.COLUMN_DEFAULT), DSL.coalesce(c2.UDT_SCHEMA, new Field[]{DSL.inline((String)null)}).as(c2.UDT_SCHEMA), DSL.coalesce(c2.UDT_NAME, new Field[]{r2.UDT_NAME, DSL.field(DSL.select(pg_t.TYPNAME).from((TableLike<?>)pg_t).where(pg_t.OID.eq(pg_p.PRORETTYPE)))}).as(c2.UDT_NAME)).from((TableLike<?>)r2).leftOuterJoin(c2).on(DSL.row(r2.TYPE_UDT_CATALOG, r2.TYPE_UDT_SCHEMA, r2.TYPE_UDT_NAME).eq(c2.TABLE_CATALOG, c2.TABLE_SCHEMA, c2.TABLE_NAME)).join(pg_n).on(r2.SPECIFIC_SCHEMA.eq(pg_n.NSPNAME)).join(pg_p).on(pg_p.PRONAMESPACE.eq(pg_n.OID)).and(pg_p.PRONAME.concat("_").concat(pg_p.OID).eq(r2.SPECIFIC_NAME)).where(r2.SPECIFIC_NAME.eq(this.specificName)).and(DSL.row(r2.SPECIFIC_CATALOG, r2.SPECIFIC_SCHEMA, r2.SPECIFIC_NAME).notIn(DSL.select(p2.SPECIFIC_CATALOG, p2.SPECIFIC_SCHEMA, p2.SPECIFIC_NAME).from((TableLike<?>)p2).where(p2.PARAMETER_MODE.eq("OUT")))).and(pg_p.PRORETSET)).orderBy(2)) {
            SchemaDefinition typeSchema = null;
            String schemaName = (String)record.get(p2.UDT_SCHEMA);
            if (schemaName != null) {
                typeSchema = this.getDatabase().getSchema(schemaName);
            }
            DefaultDataTypeDefinition type = new DefaultDataTypeDefinition(this.getDatabase(), typeSchema, (String)record.get(p2.DATA_TYPE), (Number)record.get(p2.CHARACTER_MAXIMUM_LENGTH), (Number)record.get(p2.NUMERIC_PRECISION), (Number)record.get(p2.NUMERIC_SCALE), record.get(c2.IS_NULLABLE, Boolean.TYPE), (String)record.get(c2.COLUMN_DEFAULT), DSL.name((String)record.get(p2.UDT_SCHEMA), (String)record.get(p2.UDT_NAME)));
            result.add(new DefaultColumnDefinition(this.getDatabase().getTable(this.getSchema(), this.getName()), (String)record.get(p2.PARAMETER_NAME), result.size() + 1, (DataTypeDefinition)type, StringUtils.defaultString((String)record.get(c2.COLUMN_DEFAULT)).startsWith("nextval"), null));
        }
        return result;
    }

    @Override
    protected List<ParameterDefinition> getParameters0() {
        return this.routine.getInParameters();
    }
}

