/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.meta.postgres;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jooq.CommonTableExpression;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Name;
import org.jooq.QueryPart;
import org.jooq.Record;
import org.jooq.Record12;
import org.jooq.Record5;
import org.jooq.Record6;
import org.jooq.Records;
import org.jooq.Result;
import org.jooq.ResultQuery;
import org.jooq.Rows;
import org.jooq.SQLDialect;
import org.jooq.Select;
import org.jooq.SelectConditionStep;
import org.jooq.SelectFieldOrAsterisk;
import org.jooq.SortOrder;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.TableLike;
import org.jooq.TableOptions;
import org.jooq.conf.ParseUnknownFunctions;
import org.jooq.exception.DataAccessException;
import org.jooq.impl.DSL;
import org.jooq.impl.ParserException;
import org.jooq.impl.SQLDataType;
import org.jooq.meta.AbstractDatabase;
import org.jooq.meta.AbstractDefinition;
import org.jooq.meta.AbstractIndexDefinition;
import org.jooq.meta.ArrayDefinition;
import org.jooq.meta.CatalogDefinition;
import org.jooq.meta.ColumnDefinition;
import org.jooq.meta.Database;
import org.jooq.meta.DefaultCheckConstraintDefinition;
import org.jooq.meta.DefaultDataTypeDefinition;
import org.jooq.meta.DefaultDomainDefinition;
import org.jooq.meta.DefaultEnumDefinition;
import org.jooq.meta.DefaultIndexColumnDefinition;
import org.jooq.meta.DefaultRelations;
import org.jooq.meta.DefaultSequenceDefinition;
import org.jooq.meta.DomainDefinition;
import org.jooq.meta.EnumDefinition;
import org.jooq.meta.IndexColumnDefinition;
import org.jooq.meta.IndexDefinition;
import org.jooq.meta.PackageDefinition;
import org.jooq.meta.ResultQueryDatabase;
import org.jooq.meta.RoutineDefinition;
import org.jooq.meta.SchemaDefinition;
import org.jooq.meta.SequenceDefinition;
import org.jooq.meta.TableDefinition;
import org.jooq.meta.UDTDefinition;
import org.jooq.meta.postgres.PostgresMaterializedViewDefinition;
import org.jooq.meta.postgres.PostgresRoutineDefinition;
import org.jooq.meta.postgres.PostgresTableDefinition;
import org.jooq.meta.postgres.PostgresTableValuedFunction;
import org.jooq.meta.postgres.PostgresUDTDefinition;
import org.jooq.meta.postgres.information_schema.Tables;
import org.jooq.meta.postgres.information_schema.tables.CheckConstraints;
import org.jooq.meta.postgres.information_schema.tables.KeyColumnUsage;
import org.jooq.meta.postgres.information_schema.tables.Routines;
import org.jooq.meta.postgres.pg_catalog.tables.PgClass;
import org.jooq.meta.postgres.pg_catalog.tables.PgConstraint;
import org.jooq.meta.postgres.pg_catalog.tables.PgIndex;
import org.jooq.meta.postgres.pg_catalog.tables.PgInherits;
import org.jooq.meta.postgres.pg_catalog.tables.PgNamespace;
import org.jooq.meta.postgres.pg_catalog.tables.PgType;
import org.jooq.tools.JooqLogger;
import org.jooq.util.postgres.PostgresDSL;

public class PostgresDatabase
extends AbstractDatabase
implements ResultQueryDatabase {
    private static final JooqLogger log = JooqLogger.getLogger(PostgresDatabase.class);
    private Boolean is84;
    private Boolean is94;
    private Boolean is10;
    private Boolean is11;
    private Boolean is12;
    private Boolean canUseRoutines;
    private Boolean canCastToEnumType;
    private Boolean canCombineArrays;
    private Boolean canUseTupleInPredicates;

    @Override
    protected List<IndexDefinition> getIndexes0() throws SQLException {
        ArrayList<IndexDefinition> result = new ArrayList<IndexDefinition>();
        PgIndex i2 = org.jooq.meta.postgres.pg_catalog.Tables.PG_INDEX.as("i");
        PgClass trel = org.jooq.meta.postgres.pg_catalog.Tables.PG_CLASS.as("trel");
        PgConstraint c2 = org.jooq.meta.postgres.pg_catalog.Tables.PG_CONSTRAINT.as("c");
        block0: for (Record6 record : this.create().select(trel.pgNamespace().NSPNAME, trel.RELNAME, i2.indexClass().RELNAME, i2.INDISUNIQUE, DSL.array(DSL.select(DSL.field("pg_get_indexdef({0}, k + 1, true)", String.class, i2.INDEXRELID)).from("generate_subscripts({0}, 1) as k", i2.INDKEY).orderBy(DSL.field("k"))).as("columns"), DSL.field("{0}::int[]", Integer[].class, i2.INDOPTION).as("asc_or_desc")).from((TableLike<?>)i2).join(trel).on(trel.OID.eq(i2.INDRELID)).where(trel.pgNamespace().NSPNAME.in((Collection<?>)this.getInputSchemata())).and(this.getIncludeSystemIndexes() ? DSL.noCondition() : DSL.row(trel.pgNamespace().NSPNAME, i2.indexClass().RELNAME).notIn(DSL.select(c2.pgNamespace().NSPNAME, c2.CONNAME).from((TableLike<?>)c2))).orderBy(1, 2, 3)) {
            SchemaDefinition tableSchema = this.getSchema((String)record.get(trel.pgNamespace().NSPNAME));
            if (tableSchema == null) continue;
            String indexName = (String)record.get(i2.indexClass().RELNAME);
            String tableName = (String)record.get(trel.RELNAME);
            final String[] columns = (String[])record.value5();
            final Integer[] options = (Integer[])record.value6();
            final TableDefinition table = this.getTable(tableSchema, tableName);
            if (table == null) continue;
            boolean unique = (Boolean)record.get(i2.INDISUNIQUE);
            for (int k2 = 0; k2 < columns.length; ++k2) {
                if (table.getColumn(columns[k2]) == null && table.getColumn(columns[k2] = this.tryParseColumnName(columns[k2])) == null || k2 >= options.length) continue block0;
            }
            result.add(new AbstractIndexDefinition(tableSchema, indexName, table, unique){
                List<IndexColumnDefinition> indexColumns;
                {
                    super(schema, name, table2, unique);
                    this.indexColumns = new ArrayList<IndexColumnDefinition>();
                    for (int ordinal = 0; ordinal < columns.length; ++ordinal) {
                        ColumnDefinition column = table.getColumn(columns[ordinal]);
                        SortOrder order = (options[ordinal] & 1) == 1 ? SortOrder.DESC : SortOrder.ASC;
                        this.indexColumns.add(new DefaultIndexColumnDefinition(this, column, order, ordinal + 1));
                    }
                }

                @Override
                protected List<IndexColumnDefinition> getIndexColumns0() {
                    return this.indexColumns;
                }
            });
        }
        return result;
    }

    private String tryParseColumnName(String string) {
        try {
            return this.create().configuration().deriveSettings(s2 -> s2.withParseUnknownFunctions(ParseUnknownFunctions.IGNORE)).dsl().parser().parseField(string).getName();
        }
        catch (ParserException e2) {
            log.info("Parse error", "Error when parsing column name : " + string, e2);
            return string;
        }
    }

    @Override
    protected void loadPrimaryKeys(DefaultRelations relations2) throws SQLException {
        for (Record record : this.primaryKeys(this.getInputSchemata())) {
            SchemaDefinition schema = this.getSchema((String)record.get(Tables.KEY_COLUMN_USAGE.TABLE_SCHEMA));
            String key = (String)record.get(Tables.KEY_COLUMN_USAGE.CONSTRAINT_NAME);
            String tableName = (String)record.get(Tables.KEY_COLUMN_USAGE.TABLE_NAME);
            String columnName = (String)record.get(Tables.KEY_COLUMN_USAGE.COLUMN_NAME);
            TableDefinition table = this.getTable(schema, tableName);
            if (table == null) continue;
            relations2.addPrimaryKey(key, table, table.getColumn(columnName));
        }
    }

    @Override
    protected void loadUniqueKeys(DefaultRelations relations2) throws SQLException {
        for (Record record : this.uniqueKeys(this.getInputSchemata())) {
            SchemaDefinition schema = this.getSchema((String)record.get(Tables.KEY_COLUMN_USAGE.TABLE_SCHEMA));
            String key = (String)record.get(Tables.KEY_COLUMN_USAGE.CONSTRAINT_NAME);
            String tableName = (String)record.get(Tables.KEY_COLUMN_USAGE.TABLE_NAME);
            String columnName = (String)record.get(Tables.KEY_COLUMN_USAGE.COLUMN_NAME);
            TableDefinition table = this.getTable(schema, tableName);
            if (table == null) continue;
            relations2.addUniqueKey(key, table, table.getColumn(columnName));
        }
    }

    @Override
    public ResultQuery<Record6<String, String, String, String, String, Integer>> primaryKeys(List<String> schemas) {
        return this.keys(schemas, DSL.inline("p"));
    }

    @Override
    public ResultQuery<Record6<String, String, String, String, String, Integer>> uniqueKeys(List<String> schemas) {
        return this.keys(schemas, DSL.inline("u"));
    }

    private ResultQuery<Record6<String, String, String, String, String, Integer>> keys(List<String> schemas, Field<String> constraintType) {
        KeyColumnUsage k2 = Tables.KEY_COLUMN_USAGE.as("k");
        PgConstraint c2 = org.jooq.meta.postgres.pg_catalog.Tables.PG_CONSTRAINT.as("c");
        return this.create().select(k2.TABLE_CATALOG, k2.TABLE_SCHEMA, k2.TABLE_NAME, k2.CONSTRAINT_NAME, k2.COLUMN_NAME, k2.ORDINAL_POSITION).from((TableLike<?>)c2).join(k2).on(k2.TABLE_SCHEMA.eq(c2.pgClass().pgNamespace().NSPNAME)).and(k2.TABLE_NAME.eq(c2.pgClass().RELNAME)).and(k2.CONSTRAINT_SCHEMA.eq(c2.pgNamespace().NSPNAME)).and(k2.CONSTRAINT_NAME.eq(c2.CONNAME)).where(c2.CONTYPE.eq(constraintType)).and(c2.pgNamespace().NSPNAME.in((Collection<?>)schemas)).orderBy(k2.TABLE_SCHEMA.asc(), k2.TABLE_NAME.asc(), k2.CONSTRAINT_NAME.asc(), k2.ORDINAL_POSITION.asc());
    }

    @Override
    protected void loadForeignKeys(DefaultRelations relations2) throws SQLException {
        Result<Record> result = this.create().fetch(this.getConnection().getMetaData().getExportedKeys(null, null, null)).sortAsc("key_seq").sortAsc("fk_name").sortAsc("fktable_name").sortAsc("fktable_schem");
        for (Record record : result) {
            SchemaDefinition foreignKeySchema = this.getSchema(record.get("fktable_schem", String.class));
            SchemaDefinition uniqueKeySchema = this.getSchema(record.get("pktable_schem", String.class));
            if (foreignKeySchema == null || uniqueKeySchema == null) continue;
            String foreignKey = record.get("fk_name", String.class);
            String foreignKeyTableName = record.get("fktable_name", String.class);
            String foreignKeyColumn = record.get("fkcolumn_name", String.class);
            String uniqueKey = record.get("pk_name", String.class);
            String uniqueKeyTableName = record.get("pktable_name", String.class);
            String uniqueKeyColumn = record.get("pkcolumn_name", String.class);
            TableDefinition foreignKeyTable = this.getTable(foreignKeySchema, foreignKeyTableName);
            TableDefinition uniqueKeyTable = this.getTable(uniqueKeySchema, uniqueKeyTableName);
            if (foreignKeyTable == null || uniqueKeyTable == null) continue;
            relations2.addForeignKey(foreignKey, foreignKeyTable, foreignKeyTable.getColumn(foreignKeyColumn), uniqueKey, uniqueKeyTable, uniqueKeyTable.getColumn(uniqueKeyColumn), true);
        }
    }

    @Override
    protected void loadCheckConstraints(DefaultRelations relations2) throws SQLException {
        CheckConstraints cc2 = Tables.CHECK_CONSTRAINTS.as("cc");
        PgConstraint pc2 = org.jooq.meta.postgres.pg_catalog.Tables.PG_CONSTRAINT.as("pc");
        for (Record record : this.create().select(pc2.pgClass().pgNamespace().NSPNAME, pc2.pgClass().RELNAME, pc2.CONNAME.as(cc2.CONSTRAINT_NAME), DSL.replace(DSL.field("pg_get_constraintdef({0}.oid)", SQLDataType.VARCHAR, new QueryPart[]{pc2}), DSL.inline("CHECK "), DSL.inline("")).as(cc2.CHECK_CLAUSE)).from((TableLike<?>)pc2).where(pc2.pgClass().pgNamespace().NSPNAME.in((Collection<?>)this.getInputSchemata())).and(pc2.CONTYPE.eq(DSL.inline("c"))).unionAll((Select)(this.getIncludeSystemCheckConstraints() ? DSL.select(pc2.pgClass().pgNamespace().NSPNAME, pc2.pgClass().RELNAME, cc2.CONSTRAINT_NAME, cc2.CHECK_CLAUSE).from((TableLike<?>)pc2).join(cc2).on(pc2.CONNAME.eq(cc2.CONSTRAINT_NAME)).and(pc2.pgNamespace().NSPNAME.eq(cc2.CONSTRAINT_NAME)).where(pc2.pgNamespace().NSPNAME.in((Collection<?>)this.getInputSchemata())).and(DSL.row(pc2.pgClass().pgNamespace().NSPNAME, pc2.pgClass().RELNAME, cc2.CONSTRAINT_NAME).notIn(DSL.select(pc2.pgClass().pgNamespace().NSPNAME, pc2.pgClass().RELNAME, pc2.CONNAME).from((TableLike<?>)pc2).where(pc2.CONTYPE.eq(DSL.inline("c"))))) : DSL.select(DSL.inline(""), DSL.inline(""), DSL.inline(""), DSL.inline("")).where((Condition)DSL.falseCondition()))).orderBy(1, 2, 3)) {
            SchemaDefinition schema = this.getSchema((String)record.get(pc2.pgClass().pgNamespace().NSPNAME));
            TableDefinition table = this.getTable(schema, (String)record.get(pc2.pgClass().RELNAME));
            if (table == null) continue;
            relations2.addCheckConstraint(table, new DefaultCheckConstraintDefinition(schema, table, (String)record.get(cc2.CONSTRAINT_NAME), (String)record.get(cc2.CHECK_CLAUSE)));
        }
    }

    @Override
    protected List<TableDefinition> getTables0() throws SQLException {
        ArrayList<TableDefinition> result = new ArrayList<TableDefinition>();
        HashMap<Name, PostgresTableDefinition> map = new HashMap<Name, PostgresTableDefinition>();
        SelectConditionStep empty = DSL.select(DSL.inline(""), DSL.inline(""), DSL.inline(""), DSL.inline(""), DSL.inline(""), DSL.inline("")).where((Condition)DSL.falseCondition());
        block4: for (Record record : this.create().select(new SelectFieldOrAsterisk[0]).from((TableLike<?>)DSL.select(Tables.TABLES.TABLE_SCHEMA, Tables.TABLES.TABLE_NAME, Tables.TABLES.TABLE_NAME.as("specific_name"), org.jooq.meta.postgres.pg_catalog.Tables.PG_DESCRIPTION.DESCRIPTION, DSL.when(Tables.TABLES.TABLE_TYPE.eq(DSL.inline("VIEW")), DSL.inline(TableOptions.TableType.VIEW.name())).else_(DSL.inline(TableOptions.TableType.TABLE.name())).as("table_type"), Tables.VIEWS.VIEW_DEFINITION).from((TableLike<?>)Tables.TABLES).join(org.jooq.meta.postgres.pg_catalog.Tables.PG_NAMESPACE).on(Tables.TABLES.TABLE_SCHEMA.eq(org.jooq.meta.postgres.pg_catalog.Tables.PG_NAMESPACE.NSPNAME)).join(org.jooq.meta.postgres.pg_catalog.Tables.PG_CLASS).on(org.jooq.meta.postgres.pg_catalog.Tables.PG_CLASS.RELNAME.eq(Tables.TABLES.TABLE_NAME)).and(org.jooq.meta.postgres.pg_catalog.Tables.PG_CLASS.RELNAMESPACE.eq(org.jooq.meta.postgres.pg_catalog.Tables.PG_NAMESPACE.OID)).leftJoin(org.jooq.meta.postgres.pg_catalog.Tables.PG_DESCRIPTION).on(org.jooq.meta.postgres.pg_catalog.Tables.PG_DESCRIPTION.OBJOID.eq(org.jooq.meta.postgres.pg_catalog.Tables.PG_CLASS.OID)).and(org.jooq.meta.postgres.pg_catalog.Tables.PG_DESCRIPTION.OBJSUBID.eq(0)).leftJoin(Tables.VIEWS).on(Tables.TABLES.TABLE_SCHEMA.eq(Tables.VIEWS.TABLE_SCHEMA)).and(Tables.TABLES.TABLE_NAME.eq(Tables.VIEWS.TABLE_NAME)).where(Tables.TABLES.TABLE_SCHEMA.in((Collection<?>)this.getInputSchemata())).and(this.canUseTupleInPredicates() ? DSL.row(Tables.TABLES.TABLE_SCHEMA, Tables.TABLES.TABLE_NAME).notIn(DSL.select(org.jooq.meta.postgres.pg_catalog.Tables.PG_NAMESPACE.NSPNAME, org.jooq.meta.postgres.pg_catalog.Tables.PG_CLASS.RELNAME).from((TableLike<?>)org.jooq.meta.postgres.pg_catalog.Tables.PG_CLASS).join(org.jooq.meta.postgres.pg_catalog.Tables.PG_NAMESPACE).on(org.jooq.meta.postgres.pg_catalog.Tables.PG_CLASS.RELNAMESPACE.eq(org.jooq.meta.postgres.pg_catalog.Tables.PG_NAMESPACE.OID)).where(org.jooq.meta.postgres.pg_catalog.Tables.PG_CLASS.RELKIND.eq(DSL.inline("m")))) : DSL.noCondition()).unionAll((Select)DSL.select(DSL.field("{0}::varchar", org.jooq.meta.postgres.pg_catalog.Tables.PG_NAMESPACE.NSPNAME.getDataType(), new QueryPart[]{org.jooq.meta.postgres.pg_catalog.Tables.PG_NAMESPACE.NSPNAME}), DSL.field("{0}::varchar", org.jooq.meta.postgres.pg_catalog.Tables.PG_CLASS.RELNAME.getDataType(), new QueryPart[]{org.jooq.meta.postgres.pg_catalog.Tables.PG_CLASS.RELNAME}), DSL.field("{0}::varchar", org.jooq.meta.postgres.pg_catalog.Tables.PG_CLASS.RELNAME.getDataType(), new QueryPart[]{org.jooq.meta.postgres.pg_catalog.Tables.PG_CLASS.RELNAME}), org.jooq.meta.postgres.pg_catalog.Tables.PG_DESCRIPTION.DESCRIPTION, DSL.inline(TableOptions.TableType.MATERIALIZED_VIEW.name()).as("table_type"), DSL.inline("")).from((TableLike<?>)org.jooq.meta.postgres.pg_catalog.Tables.PG_CLASS).join(org.jooq.meta.postgres.pg_catalog.Tables.PG_NAMESPACE).on(org.jooq.meta.postgres.pg_catalog.Tables.PG_CLASS.RELNAMESPACE.eq(org.jooq.meta.postgres.pg_catalog.Tables.PG_NAMESPACE.OID)).leftOuterJoin(org.jooq.meta.postgres.pg_catalog.Tables.PG_DESCRIPTION).on(org.jooq.meta.postgres.pg_catalog.Tables.PG_DESCRIPTION.OBJOID.eq(org.jooq.meta.postgres.pg_catalog.Tables.PG_CLASS.OID)).and(org.jooq.meta.postgres.pg_catalog.Tables.PG_DESCRIPTION.OBJSUBID.eq(0)).where(org.jooq.meta.postgres.pg_catalog.Tables.PG_NAMESPACE.NSPNAME.in((Collection<?>)this.getInputSchemata())).and(org.jooq.meta.postgres.pg_catalog.Tables.PG_CLASS.RELKIND.eq(DSL.inline("m")))).unionAll((Select)(this.tableValuedFunctions() ? DSL.select(Tables.ROUTINES.ROUTINE_SCHEMA, Tables.ROUTINES.ROUTINE_NAME, Tables.ROUTINES.SPECIFIC_NAME, DSL.inline(""), DSL.inline(TableOptions.TableType.FUNCTION.name()).as("table_type"), DSL.inline("")).from((TableLike<?>)Tables.ROUTINES).join(org.jooq.meta.postgres.pg_catalog.Tables.PG_NAMESPACE).on(Tables.ROUTINES.SPECIFIC_SCHEMA.eq(org.jooq.meta.postgres.pg_catalog.Tables.PG_NAMESPACE.NSPNAME)).join(org.jooq.meta.postgres.pg_catalog.Tables.PG_PROC).on(org.jooq.meta.postgres.pg_catalog.Tables.PG_PROC.PRONAMESPACE.eq(org.jooq.meta.postgres.pg_catalog.Tables.PG_NAMESPACE.OID)).and(org.jooq.meta.postgres.pg_catalog.Tables.PG_PROC.PRONAME.concat("_").concat(org.jooq.meta.postgres.pg_catalog.Tables.PG_PROC.OID).eq(Tables.ROUTINES.SPECIFIC_NAME)).where(Tables.ROUTINES.ROUTINE_SCHEMA.in((Collection<?>)this.getInputSchemata())).and(org.jooq.meta.postgres.pg_catalog.Tables.PG_PROC.PRORETSET) : empty)).asTable("tables")).orderBy(1, 2).fetch()) {
            SchemaDefinition schema = this.getSchema((String)record.get(Tables.TABLES.TABLE_SCHEMA));
            String name = (String)record.get(Tables.TABLES.TABLE_NAME);
            String comment = record.get(org.jooq.meta.postgres.pg_catalog.Tables.PG_DESCRIPTION.DESCRIPTION, String.class);
            TableOptions.TableType tableType = record.get("table_type", TableOptions.TableType.class);
            Object source = (String)record.get(Tables.VIEWS.VIEW_DEFINITION);
            if (source != null && !((String)source).toLowerCase().startsWith("create")) {
                source = "create view \"" + name + "\" as " + (String)source;
            }
            switch (tableType) {
                case FUNCTION: {
                    result.add(new PostgresTableValuedFunction(schema, name, (String)record.get(Tables.ROUTINES.SPECIFIC_NAME), comment));
                    continue block4;
                }
                case MATERIALIZED_VIEW: {
                    result.add(new PostgresMaterializedViewDefinition(schema, name, comment));
                    continue block4;
                }
            }
            PostgresTableDefinition t2 = new PostgresTableDefinition(schema, name, comment, tableType, (String)source);
            result.add(t2);
            map.put(DSL.name(schema.getName(), name), t2);
        }
        PgClass ct2 = org.jooq.meta.postgres.pg_catalog.Tables.PG_CLASS.as("ct");
        PgNamespace cn2 = org.jooq.meta.postgres.pg_catalog.Tables.PG_NAMESPACE.as("cn");
        PgInherits i2 = org.jooq.meta.postgres.pg_catalog.Tables.PG_INHERITS.as("i");
        PgClass pt2 = org.jooq.meta.postgres.pg_catalog.Tables.PG_CLASS.as("pt");
        PgNamespace pn2 = org.jooq.meta.postgres.pg_catalog.Tables.PG_NAMESPACE.as("pn");
        if (this.is84()) {
            for (Record5 inheritance : this.create().select(cn2.NSPNAME, ct2.RELNAME, pn2.NSPNAME, pt2.RELNAME, DSL.max(i2.INHSEQNO).over().partitionBy(i2.INHRELID).as("m")).from((TableLike<?>)ct2).join(cn2).on(ct2.RELNAMESPACE.eq(cn2.OID)).join(i2).on(i2.INHRELID.eq(ct2.OID)).join(pt2).on(i2.INHPARENT.eq(pt2.OID)).join(pn2).on(pt2.RELNAMESPACE.eq(pn2.OID)).where(cn2.NSPNAME.in((Collection<?>)this.getInputSchemata())).and(pn2.NSPNAME.in((Collection<?>)this.getInputSchemata())).fetch()) {
                Name child = DSL.name((String)inheritance.value1(), (String)inheritance.value2());
                Name parent = DSL.name((String)inheritance.value3(), (String)inheritance.value4());
                if ((Integer)inheritance.value5() > 1) {
                    log.info((Object)"Multiple inheritance", "Multiple inheritance is not supported by jOOQ: " + child + " inherits from " + parent);
                    continue;
                }
                PostgresTableDefinition childTable = (PostgresTableDefinition)map.get(child);
                PostgresTableDefinition parentTable = (PostgresTableDefinition)map.get(parent);
                if (childTable == null || parentTable == null) continue;
                childTable.setParentTable(parentTable);
                parentTable.getChildTables().add(childTable);
            }
        }
        return result;
    }

    @Override
    protected List<CatalogDefinition> getCatalogs0() throws SQLException {
        ArrayList<CatalogDefinition> result = new ArrayList<CatalogDefinition>();
        result.add(new CatalogDefinition((Database)this, "", ""));
        return result;
    }

    @Override
    protected List<SchemaDefinition> getSchemata0() throws SQLException {
        return this.create().select(org.jooq.meta.postgres.pg_catalog.Tables.PG_NAMESPACE.NSPNAME).from((TableLike<?>)org.jooq.meta.postgres.pg_catalog.Tables.PG_NAMESPACE).orderBy(org.jooq.meta.postgres.pg_catalog.Tables.PG_NAMESPACE.NSPNAME).collect(Collectors.mapping(r2 -> new SchemaDefinition((Database)this, (String)r2.value1(), ""), Collectors.toList()));
    }

    @Override
    public ResultQuery<Record12<String, String, String, String, Integer, Integer, Long, Long, BigDecimal, BigDecimal, Boolean, Long>> sequences(List<String> schemas) {
        CommonTableExpression s2 = DSL.name("schemas").fields("schema").as(DSL.selectFrom(DSL.values(schemas.stream().collect(Rows.toRowArray(DSL::val)))));
        return this.create().with(s2).select(DSL.inline(null, SQLDataType.VARCHAR).as("catalog"), Tables.SEQUENCES.SEQUENCE_SCHEMA, Tables.SEQUENCES.SEQUENCE_NAME, Tables.SEQUENCES.DATA_TYPE, Tables.SEQUENCES.NUMERIC_PRECISION, Tables.SEQUENCES.NUMERIC_SCALE, DSL.nullif(Tables.SEQUENCES.START_VALUE.cast(SQLDataType.BIGINT), DSL.inline(1L)).as(Tables.SEQUENCES.START_VALUE), DSL.nullif(Tables.SEQUENCES.INCREMENT.cast(SQLDataType.BIGINT), DSL.inline(1L)).as(Tables.SEQUENCES.INCREMENT), DSL.nullif(Tables.SEQUENCES.MINIMUM_VALUE.cast(SQLDataType.BIGINT), DSL.inline(1L)).coerce(SQLDataType.NUMERIC).as(Tables.SEQUENCES.MINIMUM_VALUE), DSL.nullif(Tables.SEQUENCES.MAXIMUM_VALUE.cast(SQLDataType.DECIMAL_INTEGER), DSL.power(DSL.cast(DSL.inline(2L), SQLDataType.DECIMAL_INTEGER), DSL.cast(Tables.SEQUENCES.NUMERIC_PRECISION.minus(DSL.inline(1L)), SQLDataType.DECIMAL_INTEGER)).minus(DSL.inline(1L))).coerce(SQLDataType.NUMERIC).as(Tables.SEQUENCES.MAXIMUM_VALUE), Tables.SEQUENCES.CYCLE_OPTION.cast(SQLDataType.BOOLEAN).as(Tables.SEQUENCES.CYCLE_OPTION), DSL.inline(null, SQLDataType.BIGINT).as("cache")).from((TableLike<?>)Tables.SEQUENCES).where(Tables.SEQUENCES.SEQUENCE_SCHEMA.in(DSL.selectFrom(s2))).and(!this.getIncludeSystemSequences() ? DSL.row(Tables.SEQUENCES.SEQUENCE_SCHEMA, Tables.SEQUENCES.SEQUENCE_NAME).notIn(DSL.select(Tables.COLUMNS.TABLE_SCHEMA, Tables.COLUMNS.TABLE_NAME.concat(DSL.inline("_")).concat(Tables.COLUMNS.COLUMN_NAME).concat(DSL.inline("_seq"))).from((TableLike<?>)Tables.COLUMNS).where(Tables.COLUMNS.COLUMN_DEFAULT.eq(DSL.inline("nextval('").concat(Tables.COLUMNS.TABLE_NAME.concat(DSL.inline("_")).concat(Tables.COLUMNS.COLUMN_NAME)).concat(DSL.inline("_seq'::regclass)")))).or(Tables.COLUMNS.COLUMN_DEFAULT.eq(DSL.inline("nextval('").concat(Tables.COLUMNS.TABLE_SCHEMA.concat(DSL.inline(".")).concat(Tables.COLUMNS.TABLE_NAME).concat(DSL.inline("_")).concat(Tables.COLUMNS.COLUMN_NAME)).concat(DSL.inline("_seq'::regclass)"))))) : DSL.noCondition()).unionAll((Select)(this.is10() && this.getIncludeSystemSequences() ? DSL.select(DSL.inline(null, SQLDataType.VARCHAR), org.jooq.meta.postgres.pg_catalog.Tables.PG_SEQUENCE.pgClass().pgNamespace().NSPNAME, org.jooq.meta.postgres.pg_catalog.Tables.PG_SEQUENCE.pgClass().RELNAME, org.jooq.meta.postgres.pg_catalog.Tables.PG_SEQUENCE.pgType().TYPNAME, DSL.field("information_schema._pg_numeric_precision({0}, {1})", SQLDataType.INTEGER, new QueryPart[]{org.jooq.meta.postgres.pg_catalog.Tables.PG_SEQUENCE.pgType().TYPBASETYPE, org.jooq.meta.postgres.pg_catalog.Tables.PG_SEQUENCE.pgType().TYPTYPMOD}), DSL.inline(0), org.jooq.meta.postgres.pg_catalog.Tables.PG_SEQUENCE.SEQSTART, org.jooq.meta.postgres.pg_catalog.Tables.PG_SEQUENCE.SEQINCREMENT, org.jooq.meta.postgres.pg_catalog.Tables.PG_SEQUENCE.SEQMIN.coerce(SQLDataType.NUMERIC), org.jooq.meta.postgres.pg_catalog.Tables.PG_SEQUENCE.SEQMAX.coerce(SQLDataType.NUMERIC), org.jooq.meta.postgres.pg_catalog.Tables.PG_SEQUENCE.SEQCYCLE, DSL.inline(null, SQLDataType.BIGINT).as("cache")).from((TableLike<?>)org.jooq.meta.postgres.pg_catalog.Tables.PG_SEQUENCE).where(org.jooq.meta.postgres.pg_catalog.Tables.PG_SEQUENCE.pgClass().pgNamespace().NSPNAME.in(DSL.selectFrom(s2))).and(org.jooq.meta.postgres.pg_catalog.Tables.PG_SEQUENCE.pgClass().OID.in(DSL.select(org.jooq.meta.postgres.pg_catalog.Tables.PG_DEPEND.OBJID).from((TableLike<?>)org.jooq.meta.postgres.pg_catalog.Tables.PG_DEPEND).where(org.jooq.meta.postgres.pg_catalog.Tables.PG_DEPEND.DEPTYPE.eq(DSL.inline("i"))).and(org.jooq.meta.postgres.pg_catalog.Tables.PG_DEPEND.CLASSID.eq(DSL.field("'pg_class'::regclass", org.jooq.meta.postgres.pg_catalog.Tables.PG_DEPEND.CLASSID.getDataType()))))) : DSL.select(DSL.inline(""), DSL.inline(""), DSL.inline(""), DSL.inline(""), DSL.inline(0), DSL.inline(0), DSL.inline(0L), DSL.inline(0L), DSL.inline(BigDecimal.ZERO), DSL.inline(BigDecimal.ZERO), DSL.inline(false), DSL.inline(0L)).where((Condition)DSL.falseCondition()))).orderBy(2, 3);
    }

    @Override
    protected List<SequenceDefinition> getSequences0() throws SQLException {
        ArrayList<SequenceDefinition> result = new ArrayList<SequenceDefinition>();
        for (Record record : this.sequences(this.getInputSchemata())) {
            SchemaDefinition schema = this.getSchema((String)record.get(Tables.SEQUENCES.SEQUENCE_SCHEMA));
            DefaultDataTypeDefinition type = new DefaultDataTypeDefinition((Database)this, schema, (String)record.get(Tables.SEQUENCES.DATA_TYPE), (Number)0, (Number)record.get(Tables.SEQUENCES.NUMERIC_PRECISION), (Number)record.get(Tables.SEQUENCES.NUMERIC_SCALE), (Boolean)false, (String)null);
            result.add(new DefaultSequenceDefinition(schema, (String)record.get(Tables.SEQUENCES.SEQUENCE_NAME), type, null, record.get(Tables.SEQUENCES.START_VALUE, BigInteger.class), record.get(Tables.SEQUENCES.INCREMENT, BigInteger.class), record.get(Tables.SEQUENCES.MINIMUM_VALUE, BigInteger.class), record.get(Tables.SEQUENCES.MAXIMUM_VALUE, BigInteger.class), record.get(Tables.SEQUENCES.CYCLE_OPTION, Boolean.class), null));
        }
        return result;
    }

    @Override
    protected List<EnumDefinition> getEnums0() throws SQLException {
        ArrayList<EnumDefinition> result = new ArrayList<EnumDefinition>();
        if (this.exists(org.jooq.meta.postgres.pg_catalog.Tables.PG_ENUM)) {
            for (Identifier type : this.create().select(org.jooq.meta.postgres.pg_catalog.Tables.PG_TYPE.pgNamespace().NSPNAME, org.jooq.meta.postgres.pg_catalog.Tables.PG_TYPE.TYPNAME).from((TableLike<?>)org.jooq.meta.postgres.pg_catalog.Tables.PG_TYPE).where(org.jooq.meta.postgres.pg_catalog.Tables.PG_TYPE.pgNamespace().NSPNAME.in((Collection<?>)this.getInputSchemata())).and(org.jooq.meta.postgres.pg_catalog.Tables.PG_TYPE.OID.in(DSL.select(org.jooq.meta.postgres.pg_catalog.Tables.PG_ENUM.ENUMTYPID).from((TableLike<?>)org.jooq.meta.postgres.pg_catalog.Tables.PG_ENUM))).orderBy(org.jooq.meta.postgres.pg_catalog.Tables.PG_TYPE.pgNamespace().NSPNAME, org.jooq.meta.postgres.pg_catalog.Tables.PG_TYPE.TYPNAME).fetch(Records.mapping(Identifier::new))) {
                AbstractDefinition definition = null;
                for (String label : this.enumLabels(type.schema, type.name)) {
                    SchemaDefinition schema = this.getSchema(type.schema);
                    String typeName = String.valueOf(type.name);
                    if (definition == null || !definition.getName().equals(typeName)) {
                        definition = new DefaultEnumDefinition(schema, typeName, null);
                        result.add((EnumDefinition)((Object)definition));
                    }
                    ((DefaultEnumDefinition)definition).addLiteral(label);
                }
            }
        }
        return result;
    }

    @Override
    protected List<DomainDefinition> getDomains0() throws SQLException {
        ArrayList<DomainDefinition> result = new ArrayList<DomainDefinition>();
        if (this.existAll(org.jooq.meta.postgres.pg_catalog.Tables.PG_CONSTRAINT, org.jooq.meta.postgres.pg_catalog.Tables.PG_TYPE)) {
            PgNamespace n2 = org.jooq.meta.postgres.pg_catalog.Tables.PG_NAMESPACE.as("n");
            PgConstraint c2 = org.jooq.meta.postgres.pg_catalog.Tables.PG_CONSTRAINT.as("c");
            PgType d2 = org.jooq.meta.postgres.pg_catalog.Tables.PG_TYPE.as("d");
            PgType b2 = org.jooq.meta.postgres.pg_catalog.Tables.PG_TYPE.as("b");
            Field<String[]> src = DSL.field(DSL.name("domains", "src"), String[].class);
            Field<String> constraintDef = DSL.field("pg_get_constraintdef({0})", SQLDataType.VARCHAR, new QueryPart[]{c2.OID});
            for (Record record : this.create().withRecursive("domains", "domain_id", "base_id", "typbasetype", "src").as(DSL.select(d2.OID, d2.OID, d2.TYPBASETYPE, DSL.when(c2.OID.isNotNull(), DSL.array(constraintDef))).from((TableLike<?>)d2).join(n2).on(n2.OID.eq(d2.TYPNAMESPACE)).leftJoin(c2).on(d2.OID.eq(c2.CONTYPID)).where(d2.TYPTYPE.eq("d")).and(n2.NSPNAME.in((Collection<?>)this.getInputSchemata())).unionAll((Select)DSL.select(DSL.field(DSL.name("domains", "domain_id"), Long.class), d2.OID, d2.TYPBASETYPE, DSL.decode().when(c2.CONBIN.isNull(), src).otherwise(PostgresDSL.arrayAppend(src, constraintDef))).from(DSL.name("domains")).join(d2).on(DSL.field(DSL.name("domains", d2.TYPBASETYPE.getName())).eq(d2.OID)).leftJoin(c2).on(d2.OID.eq(c2.CONTYPID)))).select(n2.NSPNAME, d2.TYPNAME, d2.TYPNOTNULL, d2.TYPDEFAULT, b2.TYPNAME, DSL.field("information_schema._pg_char_max_length({0}, {1})", SQLDataType.INTEGER, new QueryPart[]{d2.TYPBASETYPE, d2.TYPTYPMOD}).as(Tables.DOMAINS.CHARACTER_MAXIMUM_LENGTH), DSL.field("information_schema._pg_numeric_precision({0}, {1})", SQLDataType.INTEGER, new QueryPart[]{d2.TYPBASETYPE, d2.TYPTYPMOD}).as(Tables.DOMAINS.NUMERIC_PRECISION), DSL.field("information_schema._pg_numeric_scale({0}, {1})", SQLDataType.INTEGER, new QueryPart[]{d2.TYPBASETYPE, d2.TYPTYPMOD}).as(Tables.DOMAINS.NUMERIC_SCALE), src).from((TableLike<?>)d2).join(DSL.name("domains")).on(DSL.field(DSL.name("domains", "typbasetype")).eq(0)).and(DSL.field(DSL.name("domains", "domain_id")).eq(d2.OID)).join(b2).on(DSL.field(DSL.name("domains", "base_id")).eq(b2.OID)).join(n2).on(n2.OID.eq(d2.TYPNAMESPACE)).where(d2.TYPTYPE.eq("d")).and(n2.NSPNAME.in((Collection<?>)this.getInputSchemata())).orderBy(n2.NSPNAME, d2.TYPNAME)) {
                SchemaDefinition schema = this.getSchema((String)record.get(n2.NSPNAME));
                DefaultDataTypeDefinition baseType = new DefaultDataTypeDefinition((Database)this, schema, (String)record.get(b2.TYPNAME), (Number)record.get(Tables.DOMAINS.CHARACTER_MAXIMUM_LENGTH), (Number)record.get(Tables.DOMAINS.NUMERIC_PRECISION), (Number)record.get(Tables.DOMAINS.NUMERIC_SCALE), (Boolean)(record.get(d2.TYPNOTNULL, Boolean.TYPE) == false ? 1 : 0), (String)record.get(d2.TYPDEFAULT), DSL.name((String)record.get(n2.NSPNAME), (String)record.get(b2.TYPNAME)));
                DefaultDomainDefinition domain = new DefaultDomainDefinition(schema, (String)record.get(d2.TYPNAME), baseType);
                domain.addCheckClause(record.get(src));
                result.add(domain);
            }
        }
        return result;
    }

    @Override
    protected List<UDTDefinition> getUDTs0() throws SQLException {
        ArrayList<UDTDefinition> result = new ArrayList<UDTDefinition>();
        if (this.exists(Tables.ATTRIBUTES)) {
            for (Identifier udt : this.create().selectDistinct(Tables.ATTRIBUTES.UDT_SCHEMA, Tables.ATTRIBUTES.UDT_NAME).from((TableLike<?>)Tables.ATTRIBUTES).where(Tables.ATTRIBUTES.UDT_SCHEMA.in((Collection<?>)this.getInputSchemata())).orderBy(Tables.ATTRIBUTES.UDT_SCHEMA, Tables.ATTRIBUTES.UDT_NAME).fetch(Records.mapping(Identifier::new))) {
                SchemaDefinition schema = this.getSchema(udt.schema);
                if (schema == null) continue;
                result.add(new PostgresUDTDefinition(schema, udt.name, null));
            }
        }
        return result;
    }

    @Override
    protected List<ArrayDefinition> getArrays0() throws SQLException {
        ArrayList<ArrayDefinition> result = new ArrayList<ArrayDefinition>();
        return result;
    }

    @Override
    protected List<RoutineDefinition> getRoutines0() throws SQLException {
        ArrayList<RoutineDefinition> result = new ArrayList<RoutineDefinition>();
        if (!this.canUseRoutines()) {
            return result;
        }
        Routines r1 = Tables.ROUTINES.as("r1");
        Field isAgg = (this.is11() ? DSL.field(org.jooq.meta.postgres.pg_catalog.Tables.PG_PROC.PROKIND.eq(DSL.inline("a"))) : DSL.field("{0}.proisagg", SQLDataType.BOOLEAN, new QueryPart[]{org.jooq.meta.postgres.pg_catalog.Tables.PG_PROC})).as("is_agg");
        return this.create().select(r1.ROUTINE_SCHEMA, r1.ROUTINE_NAME, r1.SPECIFIC_NAME, r1.ROUTINE_TYPE, DSL.when(r1.DATA_TYPE.eq(DSL.inline("USER-DEFINED")).and(r1.TYPE_UDT_NAME.eq(DSL.inline("geometry"))), DSL.inline("geometry")).else_(this.canCombineArrays() ? DSL.when(DSL.condition("{0} && ARRAY['o','b']::\"char\"[]", org.jooq.meta.postgres.pg_catalog.Tables.PG_PROC.PROARGMODES), DSL.inline("void")).else_(r1.DATA_TYPE) : r1.DATA_TYPE).as("data_type"), r1.CHARACTER_MAXIMUM_LENGTH, DSL.when(r1.NUMERIC_PRECISION.isNull().and(r1.DATA_TYPE.in(new Field[]{DSL.inline("time"), DSL.inline("timetz"), DSL.inline("time without time zone"), DSL.inline("time with time zone"), DSL.inline("timestamp"), DSL.inline("timestamptz"), DSL.inline("timestamp without time zone"), DSL.inline("timestamp with time zone")})), DSL.inline(6)).else_(r1.NUMERIC_PRECISION).as(r1.NUMERIC_PRECISION), r1.NUMERIC_SCALE, r1.TYPE_UDT_SCHEMA, r1.TYPE_UDT_NAME, DSL.when(DSL.count().over(DSL.partitionBy(r1.ROUTINE_SCHEMA, r1.ROUTINE_NAME)).gt(DSL.one()), DSL.rowNumber().over(DSL.partitionBy(r1.ROUTINE_SCHEMA, r1.ROUTINE_NAME).orderBy(r1.SPECIFIC_NAME))).as("overload"), isAgg).from((TableLike<?>)r1).join(org.jooq.meta.postgres.pg_catalog.Tables.PG_NAMESPACE).on(org.jooq.meta.postgres.pg_catalog.Tables.PG_NAMESPACE.NSPNAME.eq(r1.SPECIFIC_SCHEMA)).join(org.jooq.meta.postgres.pg_catalog.Tables.PG_PROC).on(org.jooq.meta.postgres.pg_catalog.Tables.PG_PROC.PRONAMESPACE.eq(org.jooq.meta.postgres.pg_catalog.Tables.PG_NAMESPACE.OID)).and(this.nameconcatoid(r1)).where(r1.ROUTINE_SCHEMA.in((Collection<?>)this.getInputSchemata())).and(this.tableValuedFunctions() ? DSL.condition(DSL.not(org.jooq.meta.postgres.pg_catalog.Tables.PG_PROC.PRORETSET)) : DSL.noCondition()).and(!this.getIncludeTriggerRoutines() ? r1.DATA_TYPE.isDistinctFrom(DSL.inline("trigger")) : DSL.noCondition()).orderBy(r1.ROUTINE_SCHEMA.asc(), r1.ROUTINE_NAME.asc(), DSL.field(DSL.name("overload")).asc()).collect(Collectors.mapping(r2 -> new PostgresRoutineDefinition(this, (Record)r2), Collectors.toList()));
    }

    protected Condition nameconcatoid(Routines r1) {
        return this.is12() ? DSL.condition("nameconcatoid({0}, {1}) = {2}", org.jooq.meta.postgres.pg_catalog.Tables.PG_PROC.PRONAME, org.jooq.meta.postgres.pg_catalog.Tables.PG_PROC.OID, r1.SPECIFIC_NAME) : org.jooq.meta.postgres.pg_catalog.Tables.PG_PROC.PRONAME.concat("_").concat(org.jooq.meta.postgres.pg_catalog.Tables.PG_PROC.OID).eq(r1.SPECIFIC_NAME);
    }

    @Override
    protected List<PackageDefinition> getPackages0() throws SQLException {
        ArrayList<PackageDefinition> result = new ArrayList<PackageDefinition>();
        return result;
    }

    @Override
    protected DSLContext create0() {
        return DSL.using(this.getConnection(), SQLDialect.POSTGRES);
    }

    boolean is84() {
        if (this.is84 == null) {
            this.is84 = this.configuredDialectIsNotFamilyAndSupports(Arrays.asList(SQLDialect.POSTGRES), () -> {
                try {
                    this.create(true).select(DSL.count().over()).fetch();
                    return true;
                }
                catch (DataAccessException e2) {
                    return false;
                }
            });
        }
        return this.is84;
    }

    boolean is94() {
        if (this.is94 == null) {
            this.is94 = this.configuredDialectIsNotFamilyAndSupports(Arrays.asList(SQLDialect.POSTGRES), () -> this.exists(Tables.PARAMETERS.PARAMETER_DEFAULT));
        }
        return this.is94;
    }

    boolean is10() {
        if (this.is10 == null) {
            this.is10 = this.configuredDialectIsNotFamilyAndSupports(Arrays.asList(SQLDialect.POSTGRES), () -> this.exists(org.jooq.meta.postgres.pg_catalog.Tables.PG_SEQUENCE.SEQRELID));
        }
        return this.is10;
    }

    boolean is11() {
        if (this.is11 == null) {
            this.is11 = this.configuredDialectIsNotFamilyAndSupports(Arrays.asList(SQLDialect.POSTGRES), () -> this.exists(org.jooq.meta.postgres.pg_catalog.Tables.PG_PROC.PROKIND));
        }
        return this.is11;
    }

    boolean is12() {
        if (this.is12 == null) {
            this.is12 = this.configuredDialectIsNotFamilyAndSupports(Arrays.asList(SQLDialect.POSTGRES), () -> this.exists(DSL.table("column_column_usage")));
        }
        return this.is12;
    }

    @Override
    protected boolean exists0(TableField<?, ?> field) {
        return this.exists1(field, Tables.COLUMNS, Tables.COLUMNS.TABLE_SCHEMA, Tables.COLUMNS.TABLE_NAME, Tables.COLUMNS.COLUMN_NAME);
    }

    @Override
    protected boolean exists0(Table<?> table) {
        return this.exists1(table, Tables.TABLES, Tables.TABLES.TABLE_SCHEMA, Tables.TABLES.TABLE_NAME);
    }

    boolean canCombineArrays() {
        if (this.canCombineArrays == null) {
            try {
                this.create(true).select(DSL.field("array[1, 2] && array[2, 3]")).fetch();
                this.canCombineArrays = true;
            }
            catch (DataAccessException e2) {
                this.canCombineArrays = false;
            }
        }
        return this.canCombineArrays;
    }

    boolean canUseTupleInPredicates() {
        if (this.canUseTupleInPredicates == null) {
            try {
                this.create(true).select(DSL.field("(1, 2) in (select 1, 2)")).fetch();
                this.create(true).select(DSL.field("(1, 2) not in (select 1, 2)")).fetch();
                this.canUseTupleInPredicates = true;
            }
            catch (DataAccessException e2) {
                this.canUseTupleInPredicates = false;
            }
        }
        return this.canUseTupleInPredicates;
    }

    boolean canUseRoutines() {
        if (this.canUseRoutines == null) {
            this.canUseRoutines = this.exists(Tables.ROUTINES);
        }
        return this.canUseRoutines;
    }

    private List<String> enumLabels(String nspname, String typname) {
        TableField<Record, Float> orderBy;
        Field<Object> field = orderBy = this.exists(org.jooq.meta.postgres.pg_catalog.Tables.PG_ENUM.ENUMSORTORDER) ? org.jooq.meta.postgres.pg_catalog.Tables.PG_ENUM.ENUMSORTORDER : DSL.field("{0}::{1}", org.jooq.meta.postgres.pg_catalog.Tables.PG_ENUM.ENUMLABEL, DSL.sql("" + DSL.name(nspname, typname)));
        if (this.canCastToEnumType == null) {
            try {
                this.canCastToEnumType = true;
                return this.enumLabels(nspname, typname, orderBy);
            }
            catch (DataAccessException e2) {
                this.canCastToEnumType = false;
            }
        }
        return this.canCastToEnumType != false ? this.enumLabels(nspname, typname, orderBy) : this.enumLabels(nspname, typname, org.jooq.meta.postgres.pg_catalog.Tables.PG_ENUM.ENUMLABEL);
    }

    private List<String> enumLabels(String nspname, String typname, Field<?> orderBy) {
        return this.create().select(org.jooq.meta.postgres.pg_catalog.Tables.PG_ENUM.ENUMLABEL).from((TableLike<?>)org.jooq.meta.postgres.pg_catalog.Tables.PG_ENUM).where(org.jooq.meta.postgres.pg_catalog.Tables.PG_ENUM.pgType().pgNamespace().NSPNAME.eq(nspname)).and(org.jooq.meta.postgres.pg_catalog.Tables.PG_ENUM.pgType().TYPNAME.eq(typname)).orderBy(orderBy).collect(Records.intoList());
    }

    static final class Identifier {
        private final String schema;
        private final String name;

        public Identifier(String schema, String name) {
            this.schema = schema;
            this.name = name;
        }

        public String schema() {
            return this.schema;
        }

        public String name() {
            return this.name;
        }

        public boolean equals(Object o2) {
            if (!(o2 instanceof Identifier)) {
                return false;
            }
            Identifier other = (Identifier)o2;
            if (!Objects.equals(this.schema, other.schema)) {
                return false;
            }
            return Objects.equals(this.name, other.name);
        }

        public int hashCode() {
            return Objects.hash(this.schema, this.name);
        }

        public String toString() {
            return "Identifier[" + "schema=" + this.schema + ", name=" + this.name + "]";
        }
    }
}

