/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.meta.h2;

import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.Record12;
import org.jooq.Record6;
import org.jooq.Records;
import org.jooq.Result;
import org.jooq.ResultQuery;
import org.jooq.SQLDialect;
import org.jooq.Select;
import org.jooq.SelectConditionStep;
import org.jooq.SortOrder;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.TableLike;
import org.jooq.TableOptions;
import org.jooq.impl.DSL;
import org.jooq.impl.SQLDataType;
import org.jooq.meta.AbstractDatabase;
import org.jooq.meta.AbstractIndexDefinition;
import org.jooq.meta.ArrayDefinition;
import org.jooq.meta.CatalogDefinition;
import org.jooq.meta.ColumnDefinition;
import org.jooq.meta.Database;
import org.jooq.meta.DefaultCheckConstraintDefinition;
import org.jooq.meta.DefaultDataTypeDefinition;
import org.jooq.meta.DefaultDomainDefinition;
import org.jooq.meta.DefaultEnumDefinition;
import org.jooq.meta.DefaultIndexColumnDefinition;
import org.jooq.meta.DefaultRelations;
import org.jooq.meta.DefaultSequenceDefinition;
import org.jooq.meta.DomainDefinition;
import org.jooq.meta.EnumDefinition;
import org.jooq.meta.IndexColumnDefinition;
import org.jooq.meta.IndexDefinition;
import org.jooq.meta.PackageDefinition;
import org.jooq.meta.ResultQueryDatabase;
import org.jooq.meta.RoutineDefinition;
import org.jooq.meta.SchemaDefinition;
import org.jooq.meta.SequenceDefinition;
import org.jooq.meta.TableDefinition;
import org.jooq.meta.UDTDefinition;
import org.jooq.meta.h2.H2RoutineDefinition;
import org.jooq.meta.h2.H2TableDefinition;
import org.jooq.meta.h2.information_schema.Tables;
import org.jooq.meta.hsqldb.information_schema.tables.CheckConstraints;
import org.jooq.meta.hsqldb.information_schema.tables.DomainConstraints;
import org.jooq.meta.hsqldb.information_schema.tables.Domains;
import org.jooq.meta.hsqldb.information_schema.tables.KeyColumnUsage;
import org.jooq.tools.StringUtils;
import org.jooq.tools.csv.CSVReader;
import org.jooq.util.h2.H2DataType;

public class H2Database
extends AbstractDatabase
implements ResultQueryDatabase {
    private static final long DEFAULT_SEQUENCE_CACHE = 32L;
    private static final long DEFAULT_SEQUENCE_MAXVALUE = Long.MAX_VALUE;
    private Boolean is1_4_197;
    private Boolean is1_4_198;
    private Boolean is2_0_202;

    @Override
    protected DSLContext create0() {
        return DSL.using(this.getConnection(), SQLDialect.H2);
    }

    @Override
    protected boolean exists0(TableField<?, ?> field) {
        return this.exists1(field, Tables.COLUMNS, Tables.COLUMNS.TABLE_SCHEMA, Tables.COLUMNS.TABLE_NAME, Tables.COLUMNS.COLUMN_NAME);
    }

    @Override
    protected boolean exists0(Table<?> table) {
        return this.exists1(table, Tables.TABLES, Tables.TABLES.TABLE_SCHEMA, Tables.TABLES.TABLE_NAME);
    }

    @Override
    protected List<IndexDefinition> getIndexes0() throws SQLException {
        ArrayList<IndexDefinition> result = new ArrayList<IndexDefinition>();
        Map<Record, Result<Record>> indexes = this.indexes().fetchGroups(new Field[]{Tables.INDEXES.TABLE_SCHEMA, Tables.INDEXES.TABLE_NAME, Tables.INDEXES.INDEX_NAME, Tables.INDEXES.NON_UNIQUE}, new Field[]{Tables.INDEXES.COLUMN_NAME, Tables.INDEXES.ORDINAL_POSITION});
        block0: for (Map.Entry<Record, Result<Record>> entry : indexes.entrySet()) {
            Record index = entry.getKey();
            final Result<Record> columns = entry.getValue();
            SchemaDefinition tableSchema = this.getSchema((String)index.get(Tables.INDEXES.TABLE_SCHEMA));
            if (tableSchema == null) continue;
            String indexName = (String)index.get(Tables.INDEXES.INDEX_NAME);
            String tableName = (String)index.get(Tables.INDEXES.TABLE_NAME);
            final TableDefinition table = this.getTable(tableSchema, tableName);
            if (table == null) continue;
            boolean unique = index.get(Tables.INDEXES.NON_UNIQUE, Boolean.TYPE) == false;
            for (Record column : columns) {
                if (table.getColumn((String)column.get(Tables.INDEXES.COLUMN_NAME)) != null) continue;
                continue block0;
            }
            result.add(new AbstractIndexDefinition(tableSchema, indexName, table, unique){
                List<IndexColumnDefinition> indexColumns;
                {
                    super(schema, name, table2, unique);
                    this.indexColumns = new ArrayList<IndexColumnDefinition>();
                    for (Record column : columns) {
                        this.indexColumns.add(new DefaultIndexColumnDefinition(this, table.getColumn((String)column.get(Tables.INDEXES.COLUMN_NAME)), SortOrder.ASC, column.get(Tables.INDEXES.ORDINAL_POSITION, Integer.TYPE)));
                    }
                }

                @Override
                protected List<IndexColumnDefinition> getIndexColumns0() {
                    return this.indexColumns;
                }
            });
        }
        return result;
    }

    private ResultQuery<?> indexes() {
        if (this.is2_0_202()) {
            return this.indexes2_0();
        }
        return this.indexes1_4();
    }

    private ResultQuery<?> indexes2_0() {
        return this.create().select(Tables.INDEXES.TABLE_SCHEMA, Tables.INDEXES.TABLE_NAME, Tables.INDEXES.INDEX_NAME, DSL.field(DSL.field(Tables.INDEXES.getQualifiedName().append("INDEX_TYPE_NAME")).ne(DSL.inline("UNIQUE INDEX"))).as(Tables.INDEXES.NON_UNIQUE), DSL.field("I.COLUMN_NAME", Tables.INDEXES.COLUMN_NAME).as(Tables.INDEXES.COLUMN_NAME), DSL.field("I.ORDINAL_POSITION", Tables.INDEXES.ORDINAL_POSITION).as(Tables.INDEXES.ORDINAL_POSITION), DSL.field("I.ORDERING_SPECIFICATION", Tables.INDEXES.ASC_OR_DESC).as(Tables.INDEXES.ASC_OR_DESC)).from((TableLike<?>)Tables.INDEXES).join("INFORMATION_SCHEMA.INDEX_COLUMNS I").on("{0} = I.TABLE_SCHEMA", Tables.INDEXES.TABLE_SCHEMA).and("{0} = I.TABLE_NAME", Tables.INDEXES.TABLE_NAME).and("{0} = I.INDEX_NAME", Tables.INDEXES.INDEX_NAME).where(Tables.INDEXES.TABLE_SCHEMA.in((Collection<?>)this.getInputSchemata())).and(this.getIncludeSystemIndexes() ? DSL.noCondition() : DSL.not(DSL.condition(Tables.INDEXES.IS_GENERATED))).orderBy(Tables.INDEXES.TABLE_SCHEMA, Tables.INDEXES.TABLE_NAME, Tables.INDEXES.INDEX_NAME, DSL.field("I.ORDINAL_POSITION"));
    }

    private ResultQuery<?> indexes1_4() {
        return this.create().select(Tables.INDEXES.TABLE_SCHEMA, Tables.INDEXES.TABLE_NAME, Tables.INDEXES.INDEX_NAME, Tables.INDEXES.NON_UNIQUE, Tables.INDEXES.COLUMN_NAME, Tables.INDEXES.ORDINAL_POSITION, Tables.INDEXES.ASC_OR_DESC).from((TableLike<?>)Tables.INDEXES).where(Tables.INDEXES.TABLE_SCHEMA.in((Collection<?>)this.getInputSchemata())).and(this.getIncludeSystemIndexes() ? DSL.noCondition() : DSL.not(DSL.condition(Tables.INDEXES.IS_GENERATED))).orderBy(Tables.INDEXES.TABLE_SCHEMA, Tables.INDEXES.TABLE_NAME, Tables.INDEXES.INDEX_NAME, Tables.INDEXES.ORDINAL_POSITION);
    }

    @Override
    protected void loadPrimaryKeys(DefaultRelations relations2) throws SQLException {
        for (Record record : this.primaryKeys(this.getInputSchemata())) {
            SchemaDefinition schema = this.getSchema((String)record.get(Tables.CONSTRAINTS.TABLE_SCHEMA));
            if (schema == null) continue;
            String tableName = (String)record.get(Tables.CONSTRAINTS.TABLE_NAME);
            String primaryKey = (String)record.get(Tables.CONSTRAINTS.CONSTRAINT_NAME);
            String columnName = (String)record.get(Tables.INDEXES.COLUMN_NAME);
            TableDefinition table = this.getTable(schema, tableName);
            if (table == null) continue;
            relations2.addPrimaryKey(primaryKey, table, table.getColumn(columnName));
        }
    }

    @Override
    protected void loadUniqueKeys(DefaultRelations relations2) throws SQLException {
        for (Record record : this.uniqueKeys(this.getInputSchemata())) {
            SchemaDefinition schema = this.getSchema((String)record.get(Tables.CONSTRAINTS.TABLE_SCHEMA));
            if (schema == null) continue;
            String tableName = (String)record.get(Tables.CONSTRAINTS.TABLE_NAME);
            String primaryKey = (String)record.get(Tables.CONSTRAINTS.CONSTRAINT_NAME);
            String columnName = (String)record.get(Tables.INDEXES.COLUMN_NAME);
            TableDefinition table = this.getTable(schema, tableName);
            if (table == null) continue;
            relations2.addUniqueKey(primaryKey, table, table.getColumn(columnName));
        }
    }

    @Override
    public ResultQuery<Record6<String, String, String, String, String, Integer>> primaryKeys(List<String> schemas) {
        if (this.is2_0_202()) {
            return this.keys2_0(schemas, Arrays.asList(DSL.inline("PRIMARY KEY"), DSL.inline("PRIMARY_KEY")));
        }
        return this.keys1_4(schemas, Arrays.asList(DSL.inline("PRIMARY KEY"), DSL.inline("PRIMARY_KEY")));
    }

    @Override
    public ResultQuery<Record6<String, String, String, String, String, Integer>> uniqueKeys(List<String> schemas) {
        if (this.is2_0_202()) {
            return this.keys2_0(schemas, Arrays.asList(DSL.inline("UNIQUE")));
        }
        return this.keys1_4(schemas, Arrays.asList(DSL.inline("UNIQUE")));
    }

    private ResultQuery<Record6<String, String, String, String, String, Integer>> keys2_0(List<String> schemas, List<Field<String>> constraintTypes) {
        return this.create().select(org.jooq.meta.hsqldb.information_schema.Tables.KEY_COLUMN_USAGE.TABLE_CATALOG, org.jooq.meta.hsqldb.information_schema.Tables.KEY_COLUMN_USAGE.TABLE_SCHEMA, org.jooq.meta.hsqldb.information_schema.Tables.KEY_COLUMN_USAGE.TABLE_NAME, org.jooq.meta.hsqldb.information_schema.Tables.KEY_COLUMN_USAGE.CONSTRAINT_NAME, org.jooq.meta.hsqldb.information_schema.Tables.KEY_COLUMN_USAGE.COLUMN_NAME, org.jooq.meta.hsqldb.information_schema.Tables.KEY_COLUMN_USAGE.ORDINAL_POSITION.coerce(SQLDataType.INTEGER)).from((TableLike<?>)org.jooq.meta.hsqldb.information_schema.Tables.KEY_COLUMN_USAGE).where(org.jooq.meta.hsqldb.information_schema.Tables.KEY_COLUMN_USAGE.tableConstraints().CONSTRAINT_TYPE.in((Collection<?>)constraintTypes)).and(org.jooq.meta.hsqldb.information_schema.Tables.KEY_COLUMN_USAGE.tableConstraints().TABLE_SCHEMA.in((Collection<?>)schemas)).orderBy(org.jooq.meta.hsqldb.information_schema.Tables.KEY_COLUMN_USAGE.TABLE_SCHEMA.asc(), org.jooq.meta.hsqldb.information_schema.Tables.KEY_COLUMN_USAGE.TABLE_NAME.asc(), org.jooq.meta.hsqldb.information_schema.Tables.KEY_COLUMN_USAGE.CONSTRAINT_NAME.asc(), org.jooq.meta.hsqldb.information_schema.Tables.KEY_COLUMN_USAGE.ORDINAL_POSITION.asc());
    }

    private ResultQuery<Record6<String, String, String, String, String, Integer>> keys1_4(List<String> schemas, List<Field<String>> constraintTypes) {
        return this.create().select(Tables.CONSTRAINTS.TABLE_CATALOG, Tables.CONSTRAINTS.TABLE_SCHEMA, Tables.CONSTRAINTS.TABLE_NAME, Tables.CONSTRAINTS.CONSTRAINT_NAME, Tables.INDEXES.COLUMN_NAME, Tables.INDEXES.ORDINAL_POSITION.coerce(SQLDataType.INTEGER)).from((TableLike<?>)Tables.CONSTRAINTS).join(Tables.INDEXES).on(Tables.CONSTRAINTS.TABLE_SCHEMA.eq(Tables.INDEXES.TABLE_SCHEMA)).and(Tables.CONSTRAINTS.TABLE_NAME.eq(Tables.INDEXES.TABLE_NAME)).and(Tables.CONSTRAINTS.UNIQUE_INDEX_NAME.eq(Tables.INDEXES.INDEX_NAME)).where(Tables.CONSTRAINTS.TABLE_SCHEMA.in((Collection<?>)schemas)).and(Tables.CONSTRAINTS.CONSTRAINT_TYPE.in((Collection<?>)constraintTypes)).orderBy(Tables.CONSTRAINTS.TABLE_SCHEMA, Tables.CONSTRAINTS.CONSTRAINT_NAME, Tables.INDEXES.ORDINAL_POSITION);
    }

    @Override
    protected void loadForeignKeys(DefaultRelations relations2) throws SQLException {
        if (this.is2_0_202()) {
            this.loadForeignKeys2_0(relations2);
        } else {
            this.loadForeignKeys1_4(relations2);
        }
    }

    private void loadForeignKeys2_0(DefaultRelations relations2) {
        KeyColumnUsage fkKcu = org.jooq.meta.hsqldb.information_schema.Tables.KEY_COLUMN_USAGE.as("fk_kcu");
        KeyColumnUsage pkKcu = org.jooq.meta.hsqldb.information_schema.Tables.KEY_COLUMN_USAGE.as("pk_kcu");
        for (Record record : this.create().select(org.jooq.meta.hsqldb.information_schema.Tables.REFERENTIAL_CONSTRAINTS.UNIQUE_CONSTRAINT_NAME, org.jooq.meta.hsqldb.information_schema.Tables.REFERENTIAL_CONSTRAINTS.UNIQUE_CONSTRAINT_SCHEMA, org.jooq.meta.hsqldb.information_schema.Tables.TABLE_CONSTRAINTS.TABLE_NAME, fkKcu.CONSTRAINT_NAME, fkKcu.TABLE_SCHEMA, fkKcu.TABLE_NAME, fkKcu.COLUMN_NAME, pkKcu.COLUMN_NAME).from((TableLike<?>)org.jooq.meta.hsqldb.information_schema.Tables.REFERENTIAL_CONSTRAINTS).join(fkKcu).on(fkKcu.CONSTRAINT_SCHEMA.equal(org.jooq.meta.hsqldb.information_schema.Tables.REFERENTIAL_CONSTRAINTS.CONSTRAINT_SCHEMA)).and(fkKcu.CONSTRAINT_NAME.equal(org.jooq.meta.hsqldb.information_schema.Tables.REFERENTIAL_CONSTRAINTS.CONSTRAINT_NAME)).join(org.jooq.meta.hsqldb.information_schema.Tables.TABLE_CONSTRAINTS).on(org.jooq.meta.hsqldb.information_schema.Tables.TABLE_CONSTRAINTS.CONSTRAINT_SCHEMA.eq(org.jooq.meta.hsqldb.information_schema.Tables.REFERENTIAL_CONSTRAINTS.UNIQUE_CONSTRAINT_SCHEMA)).and(org.jooq.meta.hsqldb.information_schema.Tables.TABLE_CONSTRAINTS.CONSTRAINT_NAME.eq(org.jooq.meta.hsqldb.information_schema.Tables.REFERENTIAL_CONSTRAINTS.UNIQUE_CONSTRAINT_NAME)).join(pkKcu).on(pkKcu.CONSTRAINT_SCHEMA.eq(org.jooq.meta.hsqldb.information_schema.Tables.TABLE_CONSTRAINTS.CONSTRAINT_SCHEMA)).and(pkKcu.CONSTRAINT_NAME.eq(org.jooq.meta.hsqldb.information_schema.Tables.TABLE_CONSTRAINTS.CONSTRAINT_NAME)).and(pkKcu.ORDINAL_POSITION.eq(fkKcu.POSITION_IN_UNIQUE_CONSTRAINT)).where(fkKcu.TABLE_SCHEMA.in((Collection<?>)this.getInputSchemata())).orderBy(fkKcu.TABLE_SCHEMA.asc(), fkKcu.TABLE_NAME.asc(), fkKcu.CONSTRAINT_NAME.asc(), fkKcu.ORDINAL_POSITION.asc())) {
            SchemaDefinition foreignKeySchema = this.getSchema((String)record.get(fkKcu.TABLE_SCHEMA));
            SchemaDefinition uniqueKeySchema = this.getSchema((String)record.get(org.jooq.meta.hsqldb.information_schema.Tables.REFERENTIAL_CONSTRAINTS.UNIQUE_CONSTRAINT_SCHEMA));
            String foreignKey = (String)record.get(fkKcu.CONSTRAINT_NAME);
            String foreignKeyTableName = (String)record.get(fkKcu.TABLE_NAME);
            String foreignKeyColumn = (String)record.get(fkKcu.COLUMN_NAME);
            String uniqueKey = (String)record.get(org.jooq.meta.hsqldb.information_schema.Tables.REFERENTIAL_CONSTRAINTS.UNIQUE_CONSTRAINT_NAME);
            String uniqueKeyTableName = (String)record.get(org.jooq.meta.hsqldb.information_schema.Tables.TABLE_CONSTRAINTS.TABLE_NAME);
            String uniqueKeyColumn = (String)record.get(pkKcu.COLUMN_NAME);
            TableDefinition foreignKeyTable = this.getTable(foreignKeySchema, foreignKeyTableName);
            TableDefinition uniqueKeyTable = this.getTable(uniqueKeySchema, uniqueKeyTableName);
            if (foreignKeyTable == null || uniqueKeyTable == null) continue;
            relations2.addForeignKey(foreignKey, foreignKeyTable, foreignKeyTable.getColumn(foreignKeyColumn), uniqueKey, uniqueKeyTable, uniqueKeyTable.getColumn(uniqueKeyColumn), true);
        }
    }

    private void loadForeignKeys1_4(DefaultRelations relations2) {
        for (Record record : this.create().select(Tables.CROSS_REFERENCES.FK_NAME, Tables.CROSS_REFERENCES.FKTABLE_NAME, Tables.CROSS_REFERENCES.FKTABLE_SCHEMA, Tables.CROSS_REFERENCES.FKCOLUMN_NAME, Tables.CROSS_REFERENCES.PKCOLUMN_NAME, Tables.CROSS_REFERENCES.referencedConstraint().CONSTRAINT_NAME, Tables.CROSS_REFERENCES.referencedConstraint().TABLE_NAME, Tables.CROSS_REFERENCES.referencedConstraint().CONSTRAINT_SCHEMA).from((TableLike<?>)Tables.CROSS_REFERENCES).where(Tables.CROSS_REFERENCES.FKTABLE_SCHEMA.in((Collection<?>)this.getInputSchemata())).and(Tables.CROSS_REFERENCES.referencedConstraint().CONSTRAINT_TYPE.in("PRIMARY KEY", "PRIMARY_KEY", "UNIQUE")).orderBy(Tables.CROSS_REFERENCES.FKTABLE_SCHEMA.asc(), Tables.CROSS_REFERENCES.FK_NAME.asc(), Tables.CROSS_REFERENCES.ORDINAL_POSITION.asc()).fetch()) {
            SchemaDefinition foreignKeySchema = this.getSchema((String)record.get(Tables.CROSS_REFERENCES.FKTABLE_SCHEMA));
            SchemaDefinition uniqueKeySchema = this.getSchema((String)record.get(Tables.CROSS_REFERENCES.referencedConstraint().CONSTRAINT_SCHEMA));
            if (foreignKeySchema == null || uniqueKeySchema == null) continue;
            String foreignKey = (String)record.get(Tables.CROSS_REFERENCES.FK_NAME);
            String foreignKeyTableName = (String)record.get(Tables.CROSS_REFERENCES.FKTABLE_NAME);
            String foreignKeyColumn = (String)record.get(Tables.CROSS_REFERENCES.FKCOLUMN_NAME);
            String uniqueKey = (String)record.get(Tables.CROSS_REFERENCES.referencedConstraint().CONSTRAINT_NAME);
            String uniqueKeyTableName = (String)record.get(Tables.CROSS_REFERENCES.referencedConstraint().TABLE_NAME);
            String uniqueKeyColumn = (String)record.get(Tables.CROSS_REFERENCES.PKCOLUMN_NAME);
            TableDefinition foreignKeyTable = this.getTable(foreignKeySchema, foreignKeyTableName);
            TableDefinition uniqueKeyTable = this.getTable(uniqueKeySchema, uniqueKeyTableName);
            if (foreignKeyTable == null || uniqueKeyTable == null) continue;
            relations2.addForeignKey(foreignKey, foreignKeyTable, foreignKeyTable.getColumn(foreignKeyColumn), uniqueKey, uniqueKeyTable, uniqueKeyTable.getColumn(uniqueKeyColumn), true);
        }
    }

    @Override
    protected void loadCheckConstraints(DefaultRelations relations2) throws SQLException {
        if (this.is2_0_202()) {
            this.loadCheckConstraints2_0(relations2);
        } else {
            this.loadCheckConstraints1_4(relations2);
        }
    }

    private void loadCheckConstraints2_0(DefaultRelations relations2) {
        CheckConstraints cc2 = org.jooq.meta.hsqldb.information_schema.Tables.CHECK_CONSTRAINTS.as("cc");
        for (Record record : this.create().select(cc2.tableConstraints().TABLE_SCHEMA, cc2.tableConstraints().TABLE_NAME, cc2.CONSTRAINT_NAME, cc2.CHECK_CLAUSE).from((TableLike<?>)cc2).where(cc2.tableConstraints().TABLE_SCHEMA.in((Collection<?>)this.getInputSchemata()))) {
            SchemaDefinition schema = this.getSchema((String)record.get(cc2.tableConstraints().TABLE_SCHEMA));
            TableDefinition table = this.getTable(schema, (String)record.get(cc2.tableConstraints().TABLE_NAME));
            if (table == null) continue;
            relations2.addCheckConstraint(table, new DefaultCheckConstraintDefinition(schema, table, (String)record.get(cc2.CONSTRAINT_NAME), (String)record.get(cc2.CHECK_CLAUSE)));
        }
    }

    private void loadCheckConstraints1_4(DefaultRelations relations2) {
        SelectConditionStep inlineChecks = this.is2_0_202() ? DSL.select(DSL.inline(""), DSL.inline(""), DSL.inline(""), DSL.inline("")).where((Condition)DSL.falseCondition()) : DSL.select(Tables.COLUMNS.TABLE_SCHEMA, Tables.COLUMNS.TABLE_NAME, Tables.COLUMNS.CHECK_CONSTRAINT, Tables.COLUMNS.CHECK_CONSTRAINT).from((TableLike<?>)Tables.COLUMNS).where(Tables.COLUMNS.CHECK_CONSTRAINT.nvl("").ne("")).and(Tables.COLUMNS.TABLE_SCHEMA.in((Collection<?>)this.getInputSchemata()));
        for (Record record : this.create().select(Tables.CONSTRAINTS.TABLE_SCHEMA, Tables.CONSTRAINTS.TABLE_NAME, Tables.CONSTRAINTS.CONSTRAINT_NAME, Tables.CONSTRAINTS.CHECK_EXPRESSION).from((TableLike<?>)Tables.CONSTRAINTS).where(Tables.CONSTRAINTS.CONSTRAINT_TYPE.eq("CHECK")).and(Tables.CONSTRAINTS.TABLE_SCHEMA.in((Collection<?>)this.getInputSchemata())).union((Select)inlineChecks)) {
            TableDefinition table;
            SchemaDefinition schema = this.getSchema((String)record.get(Tables.CONSTRAINTS.TABLE_SCHEMA));
            if (schema == null || (table = this.getTable(schema, (String)record.get(Tables.CONSTRAINTS.TABLE_NAME))) == null) continue;
            relations2.addCheckConstraint(table, new DefaultCheckConstraintDefinition(schema, table, (String)record.get(Tables.CONSTRAINTS.CONSTRAINT_NAME), (String)record.get(Tables.CONSTRAINTS.CHECK_EXPRESSION)));
        }
    }

    @Override
    protected List<CatalogDefinition> getCatalogs0() throws SQLException {
        ArrayList<CatalogDefinition> result = new ArrayList<CatalogDefinition>();
        result.add(new CatalogDefinition((Database)this, "", ""));
        return result;
    }

    @Override
    protected List<SchemaDefinition> getSchemata0() throws SQLException {
        return this.create().select(Tables.SCHEMATA.SCHEMA_NAME, Tables.SCHEMATA.REMARKS).from((TableLike<?>)Tables.SCHEMATA).fetch(Records.mapping((s2, r2) -> new SchemaDefinition((Database)this, (String)s2, (String)r2)));
    }

    @Override
    public ResultQuery<Record12<String, String, String, String, Integer, Integer, Long, Long, BigDecimal, BigDecimal, Boolean, Long>> sequences(List<String> schemas) {
        TableField<Record, Long> minValue = this.is2_0_202() ? DSL.field(Tables.SEQUENCES.getQualifiedName().append("MINIMUM_VALUE"), Tables.SEQUENCES.MIN_VALUE.getDataType()) : Tables.SEQUENCES.MIN_VALUE;
        TableField<Record, Long> maxValue = this.is2_0_202() ? DSL.field(Tables.SEQUENCES.getQualifiedName().append("MAXIMUM_VALUE"), Tables.SEQUENCES.MAX_VALUE.getDataType()) : Tables.SEQUENCES.MAX_VALUE;
        TableField<Record, Boolean> isCycle = this.is2_0_202() ? DSL.field(DSL.field(Tables.SEQUENCES.getQualifiedName().append("CYCLE_OPTION")).eq(DSL.inline("YES"))) : Tables.SEQUENCES.IS_CYCLE;
        return this.create().select(DSL.inline(null, SQLDataType.VARCHAR).as("catalog"), Tables.SEQUENCES.SEQUENCE_SCHEMA, Tables.SEQUENCES.SEQUENCE_NAME, DSL.inline("BIGINT").as("type_name"), DSL.inline(null, SQLDataType.INTEGER).as("precision"), DSL.inline(null, SQLDataType.INTEGER).as("scale"), DSL.inline(null, SQLDataType.BIGINT).as("start_value"), DSL.nullif(Tables.SEQUENCES.INCREMENT, DSL.inline(1L)).as(Tables.SEQUENCES.INCREMENT), DSL.nullif(minValue, DSL.inline(1L)).coerce(SQLDataType.NUMERIC).as(Tables.SEQUENCES.MIN_VALUE), DSL.nullif(maxValue, DSL.inline(Long.MAX_VALUE)).coerce(SQLDataType.NUMERIC).as(Tables.SEQUENCES.MAX_VALUE), isCycle.as(Tables.SEQUENCES.IS_CYCLE), DSL.nullif(Tables.SEQUENCES.CACHE, DSL.inline(32L)).as(Tables.SEQUENCES.CACHE)).from((TableLike<?>)Tables.SEQUENCES).where(Tables.SEQUENCES.SEQUENCE_SCHEMA.in((Collection<?>)schemas)).and(!this.getIncludeSystemSequences() ? DSL.upper(Tables.SEQUENCES.SEQUENCE_NAME).notLike(DSL.inline("SYSTEM!_SEQUENCE!_%"), '!') : DSL.noCondition()).orderBy(Tables.SEQUENCES.SEQUENCE_SCHEMA, Tables.SEQUENCES.SEQUENCE_NAME);
    }

    @Override
    protected List<SequenceDefinition> getSequences0() throws SQLException {
        ArrayList<SequenceDefinition> result = new ArrayList<SequenceDefinition>();
        for (Record record : this.sequences(this.getInputSchemata())) {
            SchemaDefinition schema = this.getSchema((String)record.get(Tables.SEQUENCES.SEQUENCE_SCHEMA));
            if (schema == null) continue;
            String name = (String)record.get(Tables.SEQUENCES.SEQUENCE_NAME);
            DefaultDataTypeDefinition type = new DefaultDataTypeDefinition(this, schema, H2DataType.BIGINT.getTypeName());
            result.add(new DefaultSequenceDefinition(schema, name, type, null, null, (Number)record.get(Tables.SEQUENCES.INCREMENT), (Number)record.get(Tables.SEQUENCES.MIN_VALUE), (Number)record.get(Tables.SEQUENCES.MAX_VALUE), (Boolean)record.get(Tables.SEQUENCES.IS_CYCLE), (Number)record.get(Tables.SEQUENCES.CACHE)));
        }
        return result;
    }

    @Override
    protected List<TableDefinition> getTables0() throws SQLException {
        ArrayList<TableDefinition> result = new ArrayList<TableDefinition>();
        for (TableRecord r2 : this.create().select(Tables.TABLES.TABLE_SCHEMA, Tables.TABLES.TABLE_NAME, DSL.when(Tables.TABLES.TABLE_TYPE.eq(DSL.inline("VIEW")), DSL.inline(TableOptions.TableType.VIEW.name())).when((Condition)Tables.TABLES.STORAGE_TYPE.like(DSL.inline("%TEMPORARY%")), DSL.inline(TableOptions.TableType.TEMPORARY.name())).else_(DSL.inline(TableOptions.TableType.TABLE.name())).convertFrom(TableOptions.TableType::valueOf).as("table_type"), Tables.TABLES.REMARKS, Tables.VIEWS.VIEW_DEFINITION).from((TableLike<?>)Tables.TABLES).leftJoin(Tables.VIEWS).on(Tables.TABLES.TABLE_SCHEMA.eq(Tables.VIEWS.TABLE_SCHEMA)).and(Tables.TABLES.TABLE_NAME.eq(Tables.VIEWS.TABLE_NAME)).where(Tables.TABLES.TABLE_SCHEMA.in((Collection<?>)this.getInputSchemata())).orderBy(Tables.TABLES.TABLE_SCHEMA, Tables.TABLES.TABLE_NAME).fetch(Records.mapping(TableRecord::new))) {
            SchemaDefinition schema = this.getSchema(r2.schema);
            Object source = r2.source;
            if (source != null && !((String)source).toLowerCase().startsWith("create")) {
                source = "create view \"" + r2.table + "\" as " + (String)source;
            }
            if (schema == null) continue;
            result.add(new H2TableDefinition(schema, r2.table, r2.comment, r2.type, (String)source));
        }
        return result;
    }

    @Override
    protected List<RoutineDefinition> getRoutines0() throws SQLException {
        if (this.is2_0_202()) {
            return this.getRoutines2_0();
        }
        return this.getRoutines1_4();
    }

    private List<RoutineDefinition> getRoutines2_0() {
        ArrayList<RoutineDefinition> result = new ArrayList<RoutineDefinition>();
        for (Record record : this.create().select(org.jooq.meta.hsqldb.information_schema.Tables.ROUTINES.ROUTINE_SCHEMA, org.jooq.meta.hsqldb.information_schema.Tables.ROUTINES.ROUTINE_NAME, org.jooq.meta.hsqldb.information_schema.Tables.ROUTINES.SPECIFIC_NAME, DSL.coalesce(DSL.concat(org.jooq.meta.hsqldb.information_schema.Tables.ELEMENT_TYPES.DATA_TYPE, DSL.inline(" ARRAY")), new Field[]{org.jooq.meta.hsqldb.information_schema.Tables.ROUTINES.DATA_TYPE, DSL.when(org.jooq.meta.hsqldb.information_schema.Tables.ROUTINES.ROUTINE_TYPE.eq(DSL.inline("FUNCTION")), DSL.inline("RESULT_SET"))}).as(org.jooq.meta.hsqldb.information_schema.Tables.ROUTINES.DATA_TYPE), org.jooq.meta.hsqldb.information_schema.Tables.ROUTINES.NUMERIC_PRECISION, org.jooq.meta.hsqldb.information_schema.Tables.ROUTINES.NUMERIC_SCALE).from((TableLike<?>)org.jooq.meta.hsqldb.information_schema.Tables.ROUTINES).leftOuterJoin(org.jooq.meta.hsqldb.information_schema.Tables.ELEMENT_TYPES).on(org.jooq.meta.hsqldb.information_schema.Tables.ROUTINES.ROUTINE_SCHEMA.equal(org.jooq.meta.hsqldb.information_schema.Tables.ELEMENT_TYPES.OBJECT_SCHEMA)).and(org.jooq.meta.hsqldb.information_schema.Tables.ROUTINES.ROUTINE_NAME.equal(org.jooq.meta.hsqldb.information_schema.Tables.ELEMENT_TYPES.OBJECT_NAME)).and(org.jooq.meta.hsqldb.information_schema.Tables.ROUTINES.DTD_IDENTIFIER.equal(org.jooq.meta.hsqldb.information_schema.Tables.ELEMENT_TYPES.COLLECTION_TYPE_IDENTIFIER)).where(org.jooq.meta.hsqldb.information_schema.Tables.ROUTINES.ROUTINE_SCHEMA.in((Collection<?>)this.getInputSchemata())).and(this.tableValuedFunctions() ? org.jooq.meta.hsqldb.information_schema.Tables.ROUTINES.DATA_TYPE.isNull().or(org.jooq.meta.hsqldb.information_schema.Tables.ROUTINES.DATA_TYPE.notLike(DSL.inline("ROW(%"))) : DSL.noCondition()).orderBy(org.jooq.meta.hsqldb.information_schema.Tables.ROUTINES.ROUTINE_SCHEMA, org.jooq.meta.hsqldb.information_schema.Tables.ROUTINES.ROUTINE_NAME)) {
            result.add(new H2RoutineDefinition(this.getSchema((String)record.get(org.jooq.meta.hsqldb.information_schema.Tables.ROUTINES.ROUTINE_SCHEMA)), (String)record.get(org.jooq.meta.hsqldb.information_schema.Tables.ROUTINES.ROUTINE_NAME), (String)record.get(org.jooq.meta.hsqldb.information_schema.Tables.ROUTINES.SPECIFIC_NAME), (String)record.get(org.jooq.meta.hsqldb.information_schema.Tables.ROUTINES.DATA_TYPE), (Number)record.get(org.jooq.meta.hsqldb.information_schema.Tables.ROUTINES.NUMERIC_PRECISION), (Number)record.get(org.jooq.meta.hsqldb.information_schema.Tables.ROUTINES.NUMERIC_SCALE), null, null));
        }
        return result;
    }

    private List<RoutineDefinition> getRoutines1_4() {
        ArrayList<RoutineDefinition> result = new ArrayList<RoutineDefinition>();
        Field overloaded = DSL.field(DSL.select(DSL.field(DSL.exists(DSL.select(DSL.one()).from((TableLike<?>)Tables.FUNCTION_ALIASES.as("a")).where(DSL.field(DSL.name("a", Tables.FUNCTION_ALIASES.ALIAS_SCHEMA.getName())).eq(Tables.FUNCTION_ALIASES.ALIAS_SCHEMA)).and(DSL.field(DSL.name("a", Tables.FUNCTION_ALIASES.ALIAS_NAME.getName())).eq(Tables.FUNCTION_ALIASES.ALIAS_NAME)).and(DSL.field(DSL.name("a", Tables.FUNCTION_ALIASES.COLUMN_COUNT.getName())).ne(Tables.FUNCTION_ALIASES.COLUMN_COUNT)))))).as("overloaded");
        for (Record record : this.create().select(Tables.FUNCTION_ALIASES.ALIAS_SCHEMA, Tables.FUNCTION_ALIASES.ALIAS_NAME, Tables.FUNCTION_ALIASES.REMARKS, Tables.FUNCTION_ALIASES.DATA_TYPE, Tables.FUNCTION_ALIASES.RETURNS_RESULT, Tables.FUNCTION_ALIASES.COLUMN_COUNT, overloaded, Tables.TYPE_INFO.TYPE_NAME, Tables.TYPE_INFO.PRECISION, Tables.TYPE_INFO.MAXIMUM_SCALE).from((TableLike<?>)Tables.FUNCTION_ALIASES).leftOuterJoin(Tables.TYPE_INFO).on(Tables.FUNCTION_ALIASES.DATA_TYPE.equal(Tables.TYPE_INFO.DATA_TYPE)).and(Tables.TYPE_INFO.POS.equal(0)).where(Tables.FUNCTION_ALIASES.ALIAS_SCHEMA.in((Collection<?>)this.getInputSchemata())).and(Tables.FUNCTION_ALIASES.RETURNS_RESULT.in((short)1, (short)2)).orderBy(Tables.FUNCTION_ALIASES.ALIAS_NAME).fetch()) {
            SchemaDefinition schema = this.getSchema((String)record.get(Tables.FUNCTION_ALIASES.ALIAS_SCHEMA));
            if (schema == null) continue;
            String name = (String)record.get(Tables.FUNCTION_ALIASES.ALIAS_NAME);
            String comment = (String)record.get(Tables.FUNCTION_ALIASES.REMARKS);
            String typeName = (String)record.get(Tables.TYPE_INFO.TYPE_NAME);
            Integer precision = (Integer)record.get(Tables.TYPE_INFO.PRECISION);
            Short scale = (Short)record.get(Tables.TYPE_INFO.MAXIMUM_SCALE);
            String overload = (Boolean)record.get(overloaded) != false ? record.get(Tables.FUNCTION_ALIASES.COLUMN_COUNT, String.class) : null;
            result.add(new H2RoutineDefinition(schema, name, null, typeName, precision, scale, comment, overload));
        }
        return result;
    }

    @Override
    protected List<PackageDefinition> getPackages0() throws SQLException {
        ArrayList<PackageDefinition> result = new ArrayList<PackageDefinition>();
        return result;
    }

    @Override
    protected List<EnumDefinition> getEnums0() throws SQLException {
        ArrayList<EnumDefinition> result = new ArrayList<EnumDefinition>();
        if (!this.is1_4_197() && !this.is2_0_202()) {
            return result;
        }
        if (this.is2_0_202()) {
            this.getInlineEnums2_0(result);
            this.getDomainEnums2_0(result);
        } else {
            this.getInlineEnums1_4(result);
            this.getDomainEnums1_4(result);
        }
        return result;
    }

    private void getInlineEnums2_0(List<EnumDefinition> result) {
        this.create().resultQuery("select c.TABLE_SCHEMA , c.TABLE_NAME , c.COLUMN_NAME , array_agg(ev.value_name order by ev.VALUE_ORDINAL)\nfrom INFORMATION_SCHEMA.ENUM_VALUES ev\njoin INFORMATION_SCHEMA.COLUMNS c\non ev.OBJECT_SCHEMA = c.TABLE_SCHEMA\nand ev.OBJECT_NAME = c.TABLE_NAME\nand ev.ENUM_IDENTIFIER = c.DTD_IDENTIFIER\nwhere ev.OBJECT_TYPE = 'TABLE'\nand c.DOMAIN_NAME IS NULL\ngroup by c.TABLE_SCHEMA , c.TABLE_NAME , c.COLUMN_NAME\norder by 1, 2, 3\n").coerce(Tables.COLUMNS.TABLE_SCHEMA, Tables.COLUMNS.TABLE_NAME, Tables.COLUMNS.COLUMN_NAME, DSL.arrayAgg(Tables.COLUMNS.COLUMN_NAME)).forEach(r2 -> {
            ColumnDefinition columnDefinition;
            SchemaDefinition schema = this.getSchema((String)r2.value1());
            if (schema == null) {
                return;
            }
            TableDefinition tableDefinition = this.getTable(schema, (String)r2.value2());
            if (tableDefinition != null && (columnDefinition = tableDefinition.getColumn((String)r2.value3())) != null && this.getConfiguredForcedType(columnDefinition, columnDefinition.getType()) == null) {
                String name = (String)r2.value2() + "_" + (String)r2.value3();
                DefaultEnumDefinition definition = new DefaultEnumDefinition(schema, name, "");
                for (String string : (String[])r2.value4()) {
                    definition.addLiteral(string);
                }
                result.add(definition);
            }
        });
    }

    private void getInlineEnums1_4(List<EnumDefinition> result) {
        for (EnumRecord r2 : this.create().select(Tables.COLUMNS.TABLE_SCHEMA, Tables.COLUMNS.TABLE_NAME, Tables.COLUMNS.COLUMN_NAME, Tables.COLUMNS.COLUMN_TYPE).from((TableLike<?>)Tables.COLUMNS).where(Tables.COLUMNS.COLUMN_TYPE.like("ENUM(%)%").and(Tables.COLUMNS.TABLE_SCHEMA.in((Collection<?>)this.getInputSchemata()))).orderBy(Tables.COLUMNS.TABLE_SCHEMA.asc(), Tables.COLUMNS.TABLE_NAME.asc(), Tables.COLUMNS.COLUMN_NAME.asc()).fetch(Records.mapping(EnumRecord::new))) {
            ColumnDefinition columnDefinition;
            TableDefinition tableDefinition;
            SchemaDefinition schema = this.getSchema(r2.schema);
            if (schema == null || (tableDefinition = this.getTable(schema, r2.table)) == null || (columnDefinition = tableDefinition.getColumn(r2.column)) == null || this.getConfiguredForcedType(columnDefinition, columnDefinition.getType()) != null) continue;
            String name = r2.table + "_" + r2.column;
            DefaultEnumDefinition definition = new DefaultEnumDefinition(schema, name, "");
            CSVReader reader = new CSVReader((Reader)new StringReader(r2.type.replaceAll("(^enum\\()|(\\)[^)]*$)", "")), ',', '\'', true);
            for (String string : reader.next()) {
                definition.addLiteral(string);
            }
            result.add(definition);
        }
    }

    private void getDomainEnums2_0(List<EnumDefinition> result) {
        this.create().resultQuery("select object_schema, object_name, array_agg(ev.value_name order by ev.VALUE_ORDINAL)\nfrom INFORMATION_SCHEMA.ENUM_VALUES ev\nwhere ev.OBJECT_TYPE = 'DOMAIN'\ngroup by object_schema, object_name\norder by 1, 2\n").coerce(Tables.COLUMNS.TABLE_SCHEMA, Tables.COLUMNS.TABLE_NAME, DSL.arrayAgg(Tables.COLUMNS.COLUMN_NAME)).forEach(r2 -> {
            SchemaDefinition schema = this.getSchema((String)r2.value1());
            if (schema == null) {
                return;
            }
            DefaultEnumDefinition definition = new DefaultEnumDefinition(schema, (String)r2.value2(), "");
            for (String string : (String[])r2.value3()) {
                definition.addLiteral(string);
            }
            result.add(definition);
        });
    }

    private void getDomainEnums1_4(List<EnumDefinition> result) {
        for (DomainRecord r2 : this.create().select(Tables.DOMAINS.DOMAIN_SCHEMA, Tables.DOMAINS.DOMAIN_NAME, Tables.DOMAINS.SQL).from((TableLike<?>)Tables.DOMAINS).where(Tables.DOMAINS.TYPE_NAME.eq(DSL.inline("ENUM"))).and(Tables.DOMAINS.DOMAIN_SCHEMA.in((Collection<?>)this.getInputSchemata())).orderBy(Tables.DOMAINS.DOMAIN_SCHEMA, Tables.DOMAINS.DOMAIN_NAME).fetch(Records.mapping(DomainRecord::new))) {
            SchemaDefinition schema = this.getSchema(r2.schema);
            if (schema == null) continue;
            DefaultEnumDefinition definition = new DefaultEnumDefinition(schema, r2.name, "");
            CSVReader reader = new CSVReader((Reader)new StringReader(r2.sql.replaceAll("(?i:(^.*as enum\\()|(\\)[^)]*$))", "")), ',', '\'', true);
            for (String string : reader.next()) {
                definition.addLiteral(string);
            }
            result.add(definition);
        }
    }

    @Override
    protected List<DomainDefinition> getDomains0() throws SQLException {
        if (this.is2_0_202()) {
            return this.getDomains2_0();
        }
        return this.getDomains1_4();
    }

    private List<DomainDefinition> getDomains2_0() {
        ArrayList<DomainDefinition> result = new ArrayList<DomainDefinition>();
        Domains d2 = org.jooq.meta.hsqldb.information_schema.Tables.DOMAINS.as("d");
        DomainConstraints dc2 = org.jooq.meta.hsqldb.information_schema.Tables.DOMAIN_CONSTRAINTS.as("dc");
        for (Record record : this.create().select(d2.DOMAIN_SCHEMA, d2.DOMAIN_NAME, d2.DATA_TYPE, d2.CHARACTER_MAXIMUM_LENGTH, DSL.coalesce(d2.DATETIME_PRECISION, new Field[]{d2.NUMERIC_PRECISION}).as(d2.NUMERIC_PRECISION), d2.NUMERIC_SCALE, d2.DOMAIN_DEFAULT, dc2.checkConstraints().CHECK_CLAUSE).from((TableLike<?>)d2).leftJoin(dc2).on(d2.DOMAIN_CATALOG.eq(dc2.DOMAIN_CATALOG)).and(d2.DOMAIN_SCHEMA.eq(dc2.DOMAIN_SCHEMA)).and(d2.DOMAIN_NAME.eq(dc2.DOMAIN_NAME)).where(d2.DOMAIN_SCHEMA.in((Collection<?>)this.getInputSchemata())).and(d2.DATA_TYPE.ne(DSL.inline("ENUM"))).orderBy(d2.DOMAIN_SCHEMA, d2.DOMAIN_NAME)) {
            SchemaDefinition schema = this.getSchema((String)record.get(d2.DOMAIN_SCHEMA));
            DefaultDataTypeDefinition baseType = new DefaultDataTypeDefinition((Database)this, schema, (String)record.get(d2.DATA_TYPE), (Number)record.get(d2.CHARACTER_MAXIMUM_LENGTH), (Number)record.get(d2.NUMERIC_PRECISION), (Number)record.get(d2.NUMERIC_SCALE), (Boolean)true, (String)record.get(d2.DOMAIN_DEFAULT));
            DefaultDomainDefinition domain = new DefaultDomainDefinition(schema, (String)record.get(d2.DOMAIN_NAME), baseType);
            if (!StringUtils.isBlank((String)record.get(dc2.checkConstraints().CHECK_CLAUSE))) {
                domain.addCheckClause((String)record.get(dc2.checkConstraints().CHECK_CLAUSE));
            }
            result.add(domain);
        }
        return result;
    }

    private List<DomainDefinition> getDomains1_4() {
        ArrayList<DomainDefinition> result = new ArrayList<DomainDefinition>();
        for (Record record : this.create().select(Tables.DOMAINS.DOMAIN_SCHEMA, Tables.DOMAINS.DOMAIN_NAME, Tables.DOMAINS.TYPE_NAME, Tables.DOMAINS.PRECISION, Tables.DOMAINS.SCALE, Tables.DOMAINS.IS_NULLABLE, Tables.DOMAINS.COLUMN_DEFAULT, Tables.DOMAINS.CHECK_CONSTRAINT).from((TableLike<?>)Tables.DOMAINS).where(Tables.DOMAINS.DOMAIN_SCHEMA.in((Collection<?>)this.getInputSchemata())).and(Tables.DOMAINS.TYPE_NAME.ne(DSL.inline("ENUM"))).orderBy(Tables.DOMAINS.DOMAIN_SCHEMA, Tables.DOMAINS.DOMAIN_NAME)) {
            boolean isTimestamp = ((String)record.get(Tables.DOMAINS.TYPE_NAME)).trim().toLowerCase().startsWith("timestamp");
            SchemaDefinition schema = this.getSchema((String)record.get(Tables.DOMAINS.DOMAIN_SCHEMA));
            DefaultDataTypeDefinition baseType = new DefaultDataTypeDefinition((Database)this, schema, (String)record.get(Tables.DOMAINS.TYPE_NAME), (Number)record.get(Tables.DOMAINS.PRECISION), isTimestamp ? (Number)((Number)record.get(Tables.DOMAINS.SCALE)) : (Number)((Number)record.get(Tables.DOMAINS.PRECISION)), isTimestamp ? (Number)0 : (Number)((Number)record.get(Tables.DOMAINS.SCALE)), (Boolean)(record.get(Tables.DOMAINS.IS_NULLABLE, Boolean.TYPE) == false ? 1 : 0), (String)record.get(Tables.DOMAINS.COLUMN_DEFAULT));
            DefaultDomainDefinition domain = new DefaultDomainDefinition(schema, (String)record.get(Tables.DOMAINS.DOMAIN_NAME), baseType);
            if (!StringUtils.isBlank((String)record.get(Tables.DOMAINS.CHECK_CONSTRAINT))) {
                domain.addCheckClause((String)record.get(Tables.DOMAINS.CHECK_CONSTRAINT));
            }
            result.add(domain);
        }
        return result;
    }

    @Override
    protected List<UDTDefinition> getUDTs0() throws SQLException {
        ArrayList<UDTDefinition> result = new ArrayList<UDTDefinition>();
        return result;
    }

    @Override
    protected List<ArrayDefinition> getArrays0() throws SQLException {
        ArrayList<ArrayDefinition> result = new ArrayList<ArrayDefinition>();
        return result;
    }

    boolean is1_4_197() {
        if (this.is1_4_197 == null) {
            this.is1_4_197 = this.configuredDialectIsNotFamilyAndSupports(Arrays.asList(SQLDialect.H2), () -> this.exists(Tables.COLUMNS.COLUMN_TYPE));
        }
        return this.is1_4_197;
    }

    boolean is1_4_198() {
        if (this.is1_4_198 == null) {
            this.is1_4_198 = this.configuredDialectIsNotFamilyAndSupports(Arrays.asList(SQLDialect.H2), () -> this.exists(Tables.COLUMNS.IS_VISIBLE));
        }
        return this.is1_4_198;
    }

    boolean is2_0_202() {
        if (this.is2_0_202 == null) {
            this.is2_0_202 = this.configuredDialectIsNotFamilyAndSupports(Arrays.asList(SQLDialect.H2), () -> !this.exists(Tables.CONSTRAINTS));
        }
        return this.is2_0_202;
    }

    static final class DomainRecord {
        private final String schema;
        private final String name;
        private final String sql;

        public DomainRecord(String schema, String name, String sql) {
            this.schema = schema;
            this.name = name;
            this.sql = sql;
        }

        public String schema() {
            return this.schema;
        }

        public String name() {
            return this.name;
        }

        public String sql() {
            return this.sql;
        }

        public boolean equals(Object o2) {
            if (!(o2 instanceof DomainRecord)) {
                return false;
            }
            DomainRecord other = (DomainRecord)o2;
            if (!Objects.equals(this.schema, other.schema)) {
                return false;
            }
            if (!Objects.equals(this.name, other.name)) {
                return false;
            }
            return Objects.equals(this.sql, other.sql);
        }

        public int hashCode() {
            return Objects.hash(this.schema, this.name, this.sql);
        }

        public String toString() {
            return "DomainRecord[" + "schema=" + this.schema + ", name=" + this.name + ", sql=" + this.sql + "]";
        }
    }

    static final class EnumRecord {
        private final String schema;
        private final String table;
        private final String column;
        private final String type;

        public EnumRecord(String schema, String table, String column, String type) {
            this.schema = schema;
            this.table = table;
            this.column = column;
            this.type = type;
        }

        public String schema() {
            return this.schema;
        }

        public String table() {
            return this.table;
        }

        public String column() {
            return this.column;
        }

        public String type() {
            return this.type;
        }

        public boolean equals(Object o2) {
            if (!(o2 instanceof EnumRecord)) {
                return false;
            }
            EnumRecord other = (EnumRecord)o2;
            if (!Objects.equals(this.schema, other.schema)) {
                return false;
            }
            if (!Objects.equals(this.table, other.table)) {
                return false;
            }
            if (!Objects.equals(this.column, other.column)) {
                return false;
            }
            return Objects.equals(this.type, other.type);
        }

        public int hashCode() {
            return Objects.hash(this.schema, this.table, this.column, this.type);
        }

        public String toString() {
            return "EnumRecord[" + "schema=" + this.schema + ", table=" + this.table + ", column=" + this.column + ", type=" + this.type + "]";
        }
    }

    static final class TableRecord {
        private final String schema;
        private final String table;
        private final TableOptions.TableType type;
        private final String comment;
        private final String source;

        public TableRecord(String schema, String table, TableOptions.TableType type, String comment, String source) {
            this.schema = schema;
            this.table = table;
            this.type = type;
            this.comment = comment;
            this.source = source;
        }

        public String schema() {
            return this.schema;
        }

        public String table() {
            return this.table;
        }

        public TableOptions.TableType type() {
            return this.type;
        }

        public String comment() {
            return this.comment;
        }

        public String source() {
            return this.source;
        }

        public boolean equals(Object o2) {
            if (!(o2 instanceof TableRecord)) {
                return false;
            }
            TableRecord other = (TableRecord)o2;
            if (!Objects.equals(this.schema, other.schema)) {
                return false;
            }
            if (!Objects.equals(this.table, other.table)) {
                return false;
            }
            if (!Objects.equals((Object)this.type, (Object)other.type)) {
                return false;
            }
            if (!Objects.equals(this.comment, other.comment)) {
                return false;
            }
            return Objects.equals(this.source, other.source);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.schema, this.table, this.type, this.comment, this.source});
        }

        public String toString() {
            return "TableRecord[" + "schema=" + this.schema + ", table=" + this.table + ", type=" + (Object)((Object)this.type) + ", comment=" + this.comment + ", source=" + this.source + "]";
        }
    }
}

