/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.meta;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jooq.meta.AbstractDatabase;
import org.jooq.meta.AbstractDefinition;
import org.jooq.meta.ColumnDefinition;
import org.jooq.meta.PackageDefinition;
import org.jooq.meta.SchemaDefinition;
import org.jooq.meta.TableDefinition;
import org.jooq.meta.TypedElementDefinition;
import org.jooq.tools.JooqLogger;
import org.jooq.tools.StringUtils;

public abstract class AbstractElementContainerDefinition<E extends TypedElementDefinition<?>>
extends AbstractDefinition {
    protected static final Pattern PRECISION_SCALE = Pattern.compile("\\((\\d+)\\s*(?:,\\s*(\\d+))?\\)");
    private static final JooqLogger log = JooqLogger.getLogger(AbstractElementContainerDefinition.class);
    private List<E> elements;

    public AbstractElementContainerDefinition(SchemaDefinition schema, String name, String comment) {
        this(schema, null, name, comment);
    }

    public AbstractElementContainerDefinition(SchemaDefinition schema, PackageDefinition pkg, String name, String comment) {
        super(schema.getDatabase(), schema, pkg, name, comment, null, null);
    }

    public AbstractElementContainerDefinition(SchemaDefinition schema, PackageDefinition pkg, String name, String comment, String source) {
        super(schema.getDatabase(), schema, pkg, name, comment, null, source);
    }

    protected final List<E> getElements() {
        if (this.elements == null) {
            this.elements = new ArrayList();
            try {
                AbstractDatabase db2 = (AbstractDatabase)this.getDatabase();
                List<E> e2 = this.getElements0();
                if (this instanceof TableDefinition) {
                    TableDefinition t2 = (TableDefinition)((Object)this);
                    if (e2.stream().map(c2 -> (ColumnDefinition)c2).filter(ColumnDefinition::isIdentity).count() > 1L) {
                        log.warn((Object)"Multiple identities", "Table " + this.getOutputName() + " has multiple identity columns. Only the first one is considered.");
                    }
                }
                if (this instanceof TableDefinition && db2.getIncludeExcludeColumns()) {
                    this.elements = db2.filterExcludeInclude(e2);
                    log.info((Object)"Columns fetched", AbstractDatabase.fetchedSize(e2, this.elements));
                } else {
                    this.elements = e2;
                }
                db2.sort(this.elements);
            }
            catch (Exception e3) {
                log.error((Object)"Error while initialising type", e3);
            }
        }
        return this.elements;
    }

    protected final E getElement(String name) {
        return this.getElement(name, false);
    }

    protected final E getElement(String name, boolean ignoreCase) {
        return (E)((TypedElementDefinition)AbstractDatabase.getDefinition(this.getElements(), name, ignoreCase));
    }

    protected final E getElement(int index) {
        return (E)((TypedElementDefinition)this.getElements().get(index));
    }

    protected abstract List<E> getElements0() throws SQLException;

    protected Number parsePrecision(String typeName) {
        Matcher m3;
        if (typeName.contains("(") && (m3 = PRECISION_SCALE.matcher(typeName)).find() && !StringUtils.isBlank(m3.group(1))) {
            return Integer.valueOf(m3.group(1));
        }
        return 0;
    }

    protected Number parseScale(String typeName) {
        Matcher m3;
        if (typeName.contains("(") && (m3 = PRECISION_SCALE.matcher(typeName)).find() && !StringUtils.isBlank(m3.group(2))) {
            return Integer.valueOf(m3.group(2));
        }
        return 0;
    }

    protected String parseTypeName(String typeName) {
        return typeName.replace(" NOT NULL", "");
    }

    protected boolean parseNotNull(String typeName) {
        return typeName.toUpperCase().contains("NOT NULL");
    }
}

