/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import org.jooq.Context;
import org.jooq.Field;
import org.jooq.Function4;
import org.jooq.impl.AbstractField;
import org.jooq.impl.DSL;
import org.jooq.impl.Internal;
import org.jooq.impl.Names;
import org.jooq.impl.QOM;
import org.jooq.impl.SQLDataType;
import org.jooq.impl.Tools;
import org.jooq.tools.StringUtils;

final class WidthBucket<T extends Number>
extends AbstractField<T>
implements QOM.WidthBucket<T> {
    final Field<T> field;
    final Field<T> low;
    final Field<T> high;
    final Field<Integer> buckets;

    WidthBucket(Field<T> field, Field<T> low, Field<T> high, Field<Integer> buckets) {
        super(Names.N_WIDTH_BUCKET, Tools.allNotNull(Tools.dataType(SQLDataType.INTEGER, field, false), field, low, high, buckets));
        this.field = Tools.nullSafeNotNull(field, SQLDataType.INTEGER);
        this.low = Tools.nullSafeNotNull(low, SQLDataType.INTEGER);
        this.high = Tools.nullSafeNotNull(high, SQLDataType.INTEGER);
        this.buckets = Tools.nullSafeNotNull(buckets, SQLDataType.INTEGER);
    }

    @Override
    public void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case POSTGRES: 
            case YUGABYTEDB: {
                ctx.visit(Names.N_WIDTH_BUCKET).sql('(').visit(this.field).sql(", ").visit(this.low).sql(", ").visit(this.high).sql(", ").visit(this.buckets).sql(')');
                break;
            }
            default: {
                ctx.visit(DSL.when(this.field.lt(this.low), DSL.zero()).when(this.field.ge(this.high), Internal.iadd(this.buckets, DSL.one())).otherwise(Internal.iadd(DSL.floor(Internal.idiv(Internal.imul(Internal.isub(this.field, this.low), this.buckets), Internal.isub(this.high, this.low))), DSL.one())));
            }
        }
    }

    @Override
    public final Field<T> $field() {
        return this.field;
    }

    @Override
    public final Field<T> $low() {
        return this.low;
    }

    @Override
    public final Field<T> $high() {
        return this.high;
    }

    @Override
    public final Field<Integer> $buckets() {
        return this.buckets;
    }

    @Override
    public final QOM.WidthBucket<T> $field(Field<T> newValue) {
        return this.constructor().apply(newValue, this.$low(), this.$high(), this.$buckets());
    }

    @Override
    public final QOM.WidthBucket<T> $low(Field<T> newValue) {
        return this.constructor().apply(this.$field(), newValue, this.$high(), this.$buckets());
    }

    @Override
    public final QOM.WidthBucket<T> $high(Field<T> newValue) {
        return this.constructor().apply(this.$field(), this.$low(), newValue, this.$buckets());
    }

    @Override
    public final QOM.WidthBucket<T> $buckets(Field<Integer> newValue) {
        return this.constructor().apply(this.$field(), this.$low(), this.$high(), newValue);
    }

    public final Function4<? super Field<T>, ? super Field<T>, ? super Field<T>, ? super Field<Integer>, ? extends QOM.WidthBucket<T>> constructor() {
        return (a1, a2, a3, a4) -> new WidthBucket(a1, a2, a3, (Field<Integer>)a4);
    }

    @Override
    public boolean equals(Object that) {
        if (that instanceof QOM.WidthBucket) {
            QOM.WidthBucket o2 = (QOM.WidthBucket)that;
            return StringUtils.equals(this.$field(), o2.$field()) && StringUtils.equals(this.$low(), o2.$low()) && StringUtils.equals(this.$high(), o2.$high()) && StringUtils.equals(this.$buckets(), o2.$buckets());
        }
        return super.equals(that);
    }
}

