/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.Set;
import org.jooq.Clause;
import org.jooq.Context;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.Function1;
import org.jooq.Name;
import org.jooq.QueryPart;
import org.jooq.Record;
import org.jooq.Row;
import org.jooq.SQLDialect;
import org.jooq.Select;
import org.jooq.SelectSelectStep;
import org.jooq.Table;
import org.jooq.TableOptions;
import org.jooq.impl.AbstractTable;
import org.jooq.impl.DSL;
import org.jooq.impl.FieldsImpl;
import org.jooq.impl.Keywords;
import org.jooq.impl.Names;
import org.jooq.impl.QOM;
import org.jooq.impl.QueryPartListView;
import org.jooq.impl.RecordImplN;
import org.jooq.impl.TableAlias;
import org.jooq.impl.Tools;

final class Values<R extends Record>
extends AbstractTable<R>
implements QOM.Values<R> {
    static final Set<SQLDialect> NO_SUPPORT_VALUES = SQLDialect.supportedUntil(SQLDialect.FIREBIRD, SQLDialect.MARIADB);
    static final Set<SQLDialect> REQUIRE_ROWTYPE_CAST = SQLDialect.supportedBy(SQLDialect.FIREBIRD);
    static final Set<SQLDialect> NO_SUPPORT_PARENTHESES = SQLDialect.supportedBy(new SQLDialect[0]);
    private final QueryPartListView<Row> rows;
    private transient DataType<?>[] types;

    Values(Row[] rows) {
        super(TableOptions.expression(), Names.N_VALUES);
        this.rows = Values.assertNotEmpty(rows);
    }

    static final QueryPartListView<Row> assertNotEmpty(Row[] rows) {
        if (rows == null || rows.length == 0) {
            throw new IllegalArgumentException("Cannot create a VALUES() constructor with an empty set of rows");
        }
        return QueryPartListView.wrap((QueryPart[])rows);
    }

    private final DataType<?>[] rowType() {
        if (this.types == null) {
            this.types = new DataType[((Row)this.rows.get(0)).size()];
            block0: for (int i2 = 0; i2 < this.types.length; ++i2) {
                this.types[i2] = ((Row)this.rows.get(0)).dataType(i2);
                if (this.types[i2].getType() != Object.class) continue;
                for (int j2 = 1; j2 < this.rows.size(); ++j2) {
                    DataType<?> type = ((Row)this.rows.get(j2)).dataType(i2);
                    if (type.getType() == Object.class) continue;
                    this.types[i2] = type;
                    continue block0;
                }
            }
        }
        return this.types;
    }

    private final Field<?>[] castToRowType(Field<?>[] fields2) {
        Field[] result = new Field[fields2.length];
        for (int i2 = 0; i2 < result.length; ++i2) {
            DataType<?> type = this.rowType()[i2];
            result[i2] = fields2[i2].getDataType().equals(type) ? fields2[i2] : fields2[i2].cast(type);
        }
        return result;
    }

    @Override
    public final Class<? extends R> getRecordType() {
        return RecordImplN.class;
    }

    @Override
    public final Table<R> as(Name alias) {
        return new TableAlias(this, alias, c2 -> !NO_SUPPORT_PARENTHESES.contains((Object)c2.dialect()));
    }

    @Override
    public final Table<R> as(Name alias, Name ... fieldAliases) {
        return new TableAlias(this, alias, fieldAliases, c2 -> !NO_SUPPORT_PARENTHESES.contains((Object)c2.dialect()));
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (NO_SUPPORT_VALUES.contains((Object)ctx.dialect())) {
            Select<Record> selects = null;
            boolean cast = REQUIRE_ROWTYPE_CAST.contains((Object)ctx.dialect());
            for (Row row : this.rows) {
                SelectSelectStep<Record> select = DSL.select(cast ? this.castToRowType(row.fields()) : row.fields());
                if (selects == null) {
                    selects = select;
                    continue;
                }
                selects = selects.unionAll(select);
            }
            Tools.visitSubquery(ctx, selects, false);
        } else {
            ctx.start(Clause.TABLE_VALUES);
            ctx.visit(Keywords.K_VALUES);
            if (this.rows.size() > 1) {
                ctx.formatIndentStart().formatSeparator();
            } else {
                ctx.sql(' ');
            }
            for (int i2 = 0; i2 < this.rows.size(); ++i2) {
                if (i2 > 0) {
                    ctx.sql(',').formatSeparator();
                }
                if (ctx.family() == SQLDialect.MYSQL) {
                    ctx.visit(Keywords.K_ROW).sql(" ");
                }
                ctx.visit((QueryPart)this.rows.get(i2));
            }
            if (this.rows.size() > 1) {
                ctx.formatIndentEnd().formatNewLine();
            }
            ctx.end(Clause.TABLE_VALUES);
        }
    }

    @Override
    final FieldsImpl<R> fields0() {
        return new FieldsImpl(((Row)this.rows.get(0)).fields());
    }

    @Override
    public final Function1<? super QOM.UnmodifiableList<? extends Row>, ? extends Table<R>> constructor() {
        return r2 -> new Values(r2.toArray(Tools.EMPTY_ROW));
    }

    @Override
    public final QOM.UnmodifiableList<? extends Row> $arg1() {
        return QOM.unmodifiable(this.rows);
    }
}

