/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.Set;
import org.jooq.Clause;
import org.jooq.Comparator;
import org.jooq.Condition;
import org.jooq.Context;
import org.jooq.Field;
import org.jooq.LikeEscapeStep;
import org.jooq.Operator;
import org.jooq.Param;
import org.jooq.QuantifiedSelect;
import org.jooq.SQLDialect;
import org.jooq.SelectJoinStep;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.impl.AbstractCondition;
import org.jooq.impl.AliasedSelect;
import org.jooq.impl.ArrayTable;
import org.jooq.impl.DSL;
import org.jooq.impl.QOM;
import org.jooq.impl.QuantifiedSelectImpl;
import org.jooq.impl.Quantifier;
import org.jooq.impl.SQLDataType;
import org.jooq.impl.SelectQueryImpl;
import org.jooq.impl.Tools;
import org.jooq.impl.Transformations;
import org.jooq.tools.Convert;

final class QuantifiedComparisonCondition
extends AbstractCondition
implements LikeEscapeStep,
QOM.UNotYetImplemented {
    private static final Clause[] CLAUSES = new Clause[]{Clause.CONDITION, Clause.CONDITION_BETWEEN};
    private static final Set<SQLDialect> NO_SUPPORT_QUANTIFIED_LIKE = SQLDialect.supportedBy(SQLDialect.CUBRID, SQLDialect.DERBY, SQLDialect.FIREBIRD, SQLDialect.H2, SQLDialect.HSQLDB, SQLDialect.IGNITE, SQLDialect.MARIADB, SQLDialect.MYSQL, SQLDialect.SQLITE);
    private static final Set<SQLDialect> NO_SUPPORT_QUANTIFIED_SIMILAR_TO = SQLDialect.supportedBy(SQLDialect.CUBRID, SQLDialect.DERBY, SQLDialect.FIREBIRD, SQLDialect.H2, SQLDialect.HSQLDB, SQLDialect.IGNITE, SQLDialect.MARIADB, SQLDialect.MYSQL, SQLDialect.POSTGRES, SQLDialect.SQLITE, SQLDialect.YUGABYTEDB);
    private static final Set<SQLDialect> SUPPORTS_QUANTIFIED_ARRAYS = SQLDialect.supportedBy(SQLDialect.POSTGRES);
    private final QuantifiedSelectImpl<?> query;
    private final Field<?> field;
    private final Comparator comparator;
    private Character escape;

    QuantifiedComparisonCondition(QuantifiedSelect<?> query, Field<?> field, Comparator comparator) {
        this.query = (QuantifiedSelectImpl)query;
        this.field = field;
        this.comparator = comparator;
    }

    @Override
    public Condition escape(char c2) {
        this.escape = Character.valueOf(c2);
        return this;
    }

    @Override
    public final void accept(Context<?> ctx) {
        SelectQueryImpl<?> s2;
        if (this.field.getDataType().isEmbeddable()) {
            ctx.visit(DSL.row(Tools.embeddedFields(this.field)).compare(this.comparator, this.query));
        } else if (this.comparator != Comparator.EQUALS && this.comparator != Comparator.NOT_EQUALS || (s2 = Transformations.subqueryWithLimit(this.query.query)) == null || !Transformations.transformInConditionSubqueryWithLimitToDerivedTable(ctx.configuration())) {
            this.accept0(ctx);
        }
    }

    private final void accept0(Context<?> ctx) {
        boolean emulateOperator;
        boolean quantifiedArray = this.query.array instanceof Param;
        switch (this.comparator) {
            case LIKE: 
            case NOT_LIKE: 
            case LIKE_IGNORE_CASE: 
            case NOT_LIKE_IGNORE_CASE: {
                emulateOperator = this.escape != null || NO_SUPPORT_QUANTIFIED_LIKE.contains((Object)ctx.dialect());
                break;
            }
            case SIMILAR_TO: 
            case NOT_SIMILAR_TO: {
                emulateOperator = this.escape != null || NO_SUPPORT_QUANTIFIED_SIMILAR_TO.contains((Object)ctx.dialect());
                break;
            }
            default: {
                emulateOperator = false;
            }
        }
        if (quantifiedArray && SUPPORTS_QUANTIFIED_ARRAYS.contains((Object)ctx.dialect()) && !emulateOperator) {
            this.accept1(ctx);
        } else if (this.query.values != null || quantifiedArray) {
            ctx.visit(DSL.condition(this.query.quantifier == Quantifier.ALL ? Operator.AND : Operator.OR, this.query.values != null ? Tools.map(this.query.values, v2 -> this.comparisonCondition(this.comparator, (Field<String>)v2)) : Tools.map((Object[])((Param)this.query.array).getValue(), v2 -> v2 instanceof Field ? this.comparisonCondition(this.comparator, (Field)v2) : this.comparisonCondition(this.comparator, v2))));
        } else if ((this.query.array != null || this.query.query != null) && emulateOperator) {
            Param<Boolean> lhs;
            Condition cond;
            Field<String> pattern = DSL.field(DSL.name("pattern"), SQLDataType.VARCHAR);
            switch (this.comparator) {
                case NOT_LIKE: 
                case NOT_LIKE_IGNORE_CASE: 
                case NOT_SIMILAR_TO: {
                    cond = this.comparisonCondition(this.inverse(this.comparator), pattern);
                    lhs = DSL.inline(false);
                    break;
                }
                case LIKE: 
                case LIKE_IGNORE_CASE: 
                case SIMILAR_TO: {
                    cond = this.comparisonCondition(this.comparator, pattern);
                    lhs = DSL.inline(true);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            Table t2 = this.query.array != null ? new ArrayTable(this.query.array).asTable("t", "pattern") : new AliasedSelect(this.query.query, true, true, false, DSL.name("pattern")).as("t");
            SelectJoinStep select = DSL.select(DSL.field(cond)).from((TableLike<?>)t2);
            ctx.visit(lhs.eq(this.query.quantifier.apply(select)));
        } else {
            this.accept1(ctx);
        }
    }

    private final void accept1(Context<?> ctx) {
        switch (ctx.family()) {
            default: 
        }
        ctx.visit(this.field).sql(' ').visit(this.comparator.toKeyword()).sql(' ').visit(this.query);
    }

    private Comparator inverse(Comparator operator) {
        switch (operator) {
            case IN: {
                return Comparator.NOT_IN;
            }
            case NOT_IN: {
                return Comparator.IN;
            }
            case EQUALS: {
                return Comparator.NOT_EQUALS;
            }
            case NOT_EQUALS: {
                return Comparator.EQUALS;
            }
            case LESS: {
                return Comparator.GREATER_OR_EQUAL;
            }
            case LESS_OR_EQUAL: {
                return Comparator.GREATER;
            }
            case GREATER: {
                return Comparator.LESS_OR_EQUAL;
            }
            case GREATER_OR_EQUAL: {
                return Comparator.LESS;
            }
            case IS_DISTINCT_FROM: {
                return Comparator.IS_NOT_DISTINCT_FROM;
            }
            case IS_NOT_DISTINCT_FROM: {
                return Comparator.IS_DISTINCT_FROM;
            }
            case LIKE: {
                return Comparator.NOT_LIKE;
            }
            case NOT_LIKE: {
                return Comparator.LIKE;
            }
            case SIMILAR_TO: {
                return Comparator.NOT_SIMILAR_TO;
            }
            case NOT_SIMILAR_TO: {
                return Comparator.SIMILAR_TO;
            }
            case LIKE_IGNORE_CASE: {
                return Comparator.NOT_LIKE_IGNORE_CASE;
            }
            case NOT_LIKE_IGNORE_CASE: {
                return Comparator.LIKE_IGNORE_CASE;
            }
        }
        throw new IllegalStateException();
    }

    private Condition comparisonCondition(Comparator operator, Field<String> value) {
        switch (operator) {
            case LIKE: {
                return this.escape != null ? this.field.like(value, this.escape.charValue()) : this.field.like(value);
            }
            case NOT_LIKE: {
                return this.escape != null ? this.field.notLike(value, this.escape.charValue()) : this.field.notLike(value);
            }
            case SIMILAR_TO: {
                return this.escape != null ? this.field.similarTo(value, this.escape.charValue()) : this.field.similarTo(value);
            }
            case NOT_SIMILAR_TO: {
                return this.escape != null ? this.field.notSimilarTo(value, this.escape.charValue()) : this.field.notSimilarTo(value);
            }
            case LIKE_IGNORE_CASE: {
                return this.escape != null ? this.field.likeIgnoreCase(value, this.escape.charValue()) : this.field.likeIgnoreCase(value);
            }
            case NOT_LIKE_IGNORE_CASE: {
                return this.escape != null ? this.field.notLikeIgnoreCase(value, this.escape.charValue()) : this.field.notLikeIgnoreCase(value);
            }
        }
        return this.field.compare(operator, value);
    }

    private Condition comparisonCondition(Comparator operator, Object value) {
        switch (operator) {
            case LIKE: {
                return this.escape != null ? this.field.like(Convert.convert(value, String.class), this.escape.charValue()) : this.field.like(Convert.convert(value, String.class));
            }
            case NOT_LIKE: {
                return this.escape != null ? this.field.notLike(Convert.convert(value, String.class), this.escape.charValue()) : this.field.notLike(Convert.convert(value, String.class));
            }
            case SIMILAR_TO: {
                return this.escape != null ? this.field.similarTo(Convert.convert(value, String.class), this.escape.charValue()) : this.field.similarTo(Convert.convert(value, String.class));
            }
            case NOT_SIMILAR_TO: {
                return this.escape != null ? this.field.notSimilarTo(Convert.convert(value, String.class), this.escape.charValue()) : this.field.notSimilarTo(Convert.convert(value, String.class));
            }
            case LIKE_IGNORE_CASE: {
                return this.escape != null ? this.field.likeIgnoreCase(Convert.convert(value, String.class), this.escape.charValue()) : this.field.likeIgnoreCase(Convert.convert(value, String.class));
            }
            case NOT_LIKE_IGNORE_CASE: {
                return this.escape != null ? this.field.notLikeIgnoreCase(Convert.convert(value, String.class), this.escape.charValue()) : this.field.notLikeIgnoreCase(Convert.convert(value, String.class));
            }
        }
        return this.field.compare(operator, value);
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return CLAUSES;
    }
}

