/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import org.jooq.Context;
import org.jooq.Field;
import org.jooq.Function3;
import org.jooq.impl.AbstractField;
import org.jooq.impl.DSL;
import org.jooq.impl.Internal;
import org.jooq.impl.Keywords;
import org.jooq.impl.Names;
import org.jooq.impl.QOM;
import org.jooq.impl.SQLDataType;
import org.jooq.impl.Tools;
import org.jooq.tools.StringUtils;

final class Position
extends AbstractField<Integer>
implements QOM.Position {
    final Field<String> in;
    final Field<String> search;
    final Field<? extends Number> startIndex;

    Position(Field<String> in2, Field<String> search) {
        super(Names.N_POSITION, Tools.allNotNull(SQLDataType.INTEGER, in2, search));
        this.in = Tools.nullSafeNotNull(in2, SQLDataType.VARCHAR);
        this.search = Tools.nullSafeNotNull(search, SQLDataType.VARCHAR);
        this.startIndex = null;
    }

    Position(Field<String> in2, Field<String> search, Field<? extends Number> startIndex) {
        super(Names.N_POSITION, Tools.allNotNull(SQLDataType.INTEGER, in2, search, startIndex));
        this.in = Tools.nullSafeNotNull(in2, SQLDataType.VARCHAR);
        this.search = Tools.nullSafeNotNull(search, SQLDataType.VARCHAR);
        this.startIndex = Tools.nullSafeNotNull(startIndex, SQLDataType.INTEGER);
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (this.startIndex != null) {
            switch (ctx.family()) {
                case DERBY: 
                case H2: {
                    ctx.visit(Names.N_LOCATE).sql('(').visit(this.search).sql(", ").visit(this.in).sql(", ").visit(this.startIndex).sql(')');
                    break;
                }
                default: {
                    ctx.visit(DSL.case_(DSL.position(DSL.substring(this.in, this.startIndex), this.search)).when((Field<Integer>)DSL.inline(0), DSL.inline(0)).else_(Internal.iadd(DSL.position(DSL.substring(this.in, this.startIndex), this.search), Internal.isub(this.startIndex, DSL.one()))));
                    break;
                }
            }
        } else {
            switch (ctx.family()) {
                case DERBY: {
                    ctx.visit(Names.N_LOCATE).sql('(').visit(this.search).sql(", ").visit(this.in).sql(')');
                    break;
                }
                case SQLITE: {
                    ctx.visit(Names.N_INSTR).sql('(').visit(this.in).sql(", ").visit(this.search).sql(')');
                    break;
                }
                default: {
                    ctx.visit(Names.N_POSITION).sql('(').visit(this.search).sql(' ').visit(Keywords.K_IN).sql(' ').visit(this.in).sql(')');
                }
            }
        }
    }

    @Override
    public final Field<String> $in() {
        return this.in;
    }

    @Override
    public final Field<String> $search() {
        return this.search;
    }

    @Override
    public final Field<? extends Number> $startIndex() {
        return this.startIndex;
    }

    @Override
    public final QOM.Position $in(Field<String> newValue) {
        return this.constructor().apply(newValue, this.$search(), this.$startIndex());
    }

    @Override
    public final QOM.Position $search(Field<String> newValue) {
        return this.constructor().apply(this.$in(), newValue, this.$startIndex());
    }

    @Override
    public final QOM.Position $startIndex(Field<? extends Number> newValue) {
        return this.constructor().apply(this.$in(), this.$search(), newValue);
    }

    public final Function3<? super Field<String>, ? super Field<String>, ? super Field<? extends Number>, ? extends QOM.Position> constructor() {
        return (a1, a2, a3) -> new Position((Field<String>)a1, (Field<String>)a2, (Field<? extends Number>)a3);
    }

    @Override
    public boolean equals(Object that) {
        if (that instanceof QOM.Position) {
            QOM.Position o2 = (QOM.Position)that;
            return StringUtils.equals(this.$in(), o2.$in()) && StringUtils.equals(this.$search(), o2.$search()) && StringUtils.equals(this.$startIndex(), o2.$startIndex());
        }
        return super.equals(that);
    }
}

