/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.jooq.Catalog;
import org.jooq.Condition;
import org.jooq.Configuration;
import org.jooq.ConstraintEnforcementStep;
import org.jooq.DSLContext;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.ForeignKey;
import org.jooq.Index;
import org.jooq.Name;
import org.jooq.OrderField;
import org.jooq.Record;
import org.jooq.Result;
import org.jooq.SQLDialect;
import org.jooq.Schema;
import org.jooq.Sequence;
import org.jooq.SortField;
import org.jooq.Source;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.TableOptions;
import org.jooq.UniqueKey;
import org.jooq.conf.ParseUnknownFunctions;
import org.jooq.exception.DataAccessException;
import org.jooq.exception.DataDefinitionException;
import org.jooq.exception.DataTypeException;
import org.jooq.exception.SQLDialectNotSupportedException;
import org.jooq.impl.AbstractKey;
import org.jooq.impl.AbstractMeta;
import org.jooq.impl.AbstractNamed;
import org.jooq.impl.CatalogImpl;
import org.jooq.impl.DSL;
import org.jooq.impl.DefaultDataType;
import org.jooq.impl.IndexImpl;
import org.jooq.impl.Internal;
import org.jooq.impl.MetaSQL;
import org.jooq.impl.ParserException;
import org.jooq.impl.ReferenceImpl;
import org.jooq.impl.SQLDataType;
import org.jooq.impl.SchemaImpl;
import org.jooq.impl.TableImpl;
import org.jooq.impl.ThrowingBiFunction;
import org.jooq.impl.ThrowingFunction;
import org.jooq.impl.Tools;
import org.jooq.tools.JooqLogger;
import org.jooq.tools.StringUtils;

final class MetaImpl
extends AbstractMeta {
    private static final JooqLogger log = JooqLogger.getLogger(MetaImpl.class);
    private static final Set<SQLDialect> INVERSE_SCHEMA_CATALOG = SQLDialect.supportedBy(SQLDialect.MARIADB, SQLDialect.MYSQL);
    private static final Set<SQLDialect> CURRENT_TIMESTAMP_COLUMN_DEFAULT = SQLDialect.supportedBy(SQLDialect.MARIADB, SQLDialect.MYSQL);
    private static final Set<SQLDialect> EXPRESSION_COLUMN_DEFAULT = SQLDialect.supportedBy(SQLDialect.DERBY, SQLDialect.FIREBIRD, SQLDialect.H2, SQLDialect.HSQLDB, SQLDialect.IGNITE, SQLDialect.MARIADB, SQLDialect.POSTGRES, SQLDialect.SQLITE, SQLDialect.YUGABYTEDB);
    private static final Set<SQLDialect> NO_SUPPORT_SCHEMAS = SQLDialect.supportedBy(SQLDialect.FIREBIRD, SQLDialect.SQLITE);
    private static final Pattern P_SYSINDEX_DERBY = Pattern.compile("^(?i:SQL\\d{14,}).*$");
    private static final Pattern P_SYSINDEX_H2 = Pattern.compile("^(?i:PRIMARY_KEY_|UK_INDEX_|FK_INDEX_).*$");
    private static final Pattern P_SYSINDEX_HSQLDB = Pattern.compile("^(?i:SYS_IDX_(?:PK|UK|FK)_).*$");
    private static final Pattern P_SYSINDEX_SQLITE = Pattern.compile("^(?i:sqlite_autoindex_).*$");
    private final DatabaseMetaData databaseMetaData;
    private final boolean inverseSchemaCatalog;
    private static final Class<?>[] GET_COLUMNS_SHORT = new Class[]{String.class, String.class, String.class, String.class, Integer.TYPE, String.class, Integer.TYPE, String.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, String.class, String.class};
    private static final Class<?>[] GET_COLUMNS_EXTENDED = new Class[]{String.class, String.class, String.class, String.class, Integer.TYPE, String.class, Integer.TYPE, String.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, String.class, String.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, String.class, String.class, String.class, String.class, String.class, String.class};

    MetaImpl(Configuration configuration, DatabaseMetaData databaseMetaData) {
        super(configuration);
        this.databaseMetaData = databaseMetaData;
        this.inverseSchemaCatalog = INVERSE_SCHEMA_CATALOG.contains((Object)this.dialect());
    }

    final boolean hasCatalog(Catalog catalog) {
        return catalog != null && !StringUtils.isEmpty(catalog.getName());
    }

    final <R> R catalogSchema(Catalog catalog, Schema schema, ThrowingBiFunction<String, String, R, SQLException> function) throws SQLException {
        return this.catalogSchema(catalog != null ? catalog.getName() : null, schema != null ? schema.getName() : null, function);
    }

    final <R> R catalogSchema(String catalog, String schema, ThrowingBiFunction<String, String, R, SQLException> function) throws SQLException {
        String c2 = StringUtils.defaultIfEmpty(catalog, null);
        String s2 = StringUtils.defaultIfEmpty(schema, null);
        if (this.inverseSchemaCatalog) {
            return function.apply(s2, c2);
        }
        return function.apply(c2, s2);
    }

    private final Result<Record> meta(ThrowingFunction<DatabaseMetaData, Result<Record>, SQLException> function) {
        if (this.databaseMetaData == null) {
            return this.dsl().connectionResult(connection -> (Result)function.apply(connection.getMetaData()));
        }
        try {
            return function.apply(this.databaseMetaData);
        }
        catch (SQLException e2) {
            throw new DataAccessException("Error while running MetaFunction", e2);
        }
    }

    @Override
    final List<Catalog> getCatalogs0() {
        ArrayList<Catalog> result = new ArrayList<Catalog>();
        if (result.isEmpty()) {
            result.add(new MetaCatalog(""));
        }
        return result;
    }

    final Table<?> lookupTable(Schema schema, String tableName) {
        switch (this.family()) {
            case SQLITE: {
                return AbstractNamed.findIgnoreCase(tableName, schema.getTables());
            }
        }
        return schema.getTable(tableName);
    }

    @Override
    final List<Schema> getSchemas0() {
        return Tools.flatMap(this.getCatalogs(), c2 -> c2.getSchemas());
    }

    @Override
    final List<Table<?>> getTables0() {
        return Tools.flatMap(this.getSchemas(), s2 -> s2.getTables());
    }

    @Override
    final List<UniqueKey<?>> getPrimaryKeys0() {
        ArrayList result = new ArrayList();
        for (Table<?> table : this.getTables()) {
            UniqueKey<?> pk2 = table.getPrimaryKey();
            if (pk2 == null) continue;
            result.add(pk2);
        }
        return result;
    }

    @Override
    public String toString() {
        return "MetaImpl";
    }

    private final class MetaUniqueKey
    extends AbstractKey<Record>
    implements UniqueKey<Record> {
        private final boolean isPrimary;

        MetaUniqueKey(Table<Record> table, String name, TableField<Record, ?>[] fields2, boolean isPrimary) {
            super(table, name == null ? null : DSL.name(name), fields2, true);
            this.isPrimary = isPrimary;
        }

        @Override
        public final boolean isPrimary() {
            return this.isPrimary;
        }

        @Override
        public final List<ForeignKey<?, Record>> getReferences() {
            Result<Record> result = MetaImpl.this.meta(meta -> {
                try (ResultSet rs = MetaImpl.this.catalogSchema(this.getTable().getCatalog(), this.getTable().getSchema(), (c2, s2) -> meta.getExportedKeys((String)c2, (String)s2, this.getTable().getName()));){
                    Result<Record> result = MetaImpl.this.dsl().fetch(rs, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, Short.class, Short.class, Short.class, String.class, String.class);
                    return result;
                }
            });
            Map<Record, Result<Record>> groups = result.intoGroups(new Field[]{result.field(MetaImpl.this.inverseSchemaCatalog ? 5 : 4), result.field(MetaImpl.this.inverseSchemaCatalog ? 4 : 5), result.field(6), result.field(11), result.field(12)});
            HashMap<String, Schema> schemas = new HashMap<String, Schema>();
            for (Schema schema : MetaImpl.this.getSchemas()) {
                schemas.put(schema.getName(), schema);
            }
            ArrayList references = new ArrayList(groups.size());
            groups.forEach((k2, v2) -> {
                Schema schema = (Schema)schemas.get(StringUtils.defaultString(k2.get(1, String.class)));
                Table<?> fkTable = MetaImpl.this.lookupTable(schema, k2.get(2, String.class));
                references.add(new ReferenceImpl(fkTable, DSL.name(k2.get(3, String.class)), Tools.map(v2, f2 -> (TableField)fkTable.field(f2.get(7, String.class)), TableField[]::new), this, Tools.map(v2, f2 -> (TableField)this.getTable().field(f2.get(3, String.class)), TableField[]::new), true));
            });
            return references;
        }

        @Override
        final ConstraintEnforcementStep constraint0() {
            if (this.isPrimary()) {
                return DSL.constraint(this.getName()).primaryKey(this.getFieldsArray());
            }
            return DSL.constraint(this.getName()).unique(this.getFieldsArray());
        }
    }

    private final class MetaTable
    extends TableImpl<Record> {
        private final Result<Record> uks;

        MetaTable(String name, Schema schema, Result<Record> columns, Result<Record> uks, String remarks, TableOptions.TableType tableType) {
            super(DSL.name(name), schema, null, null, null, null, DSL.comment(remarks), TableOptions.of(tableType));
            if (columns != null) {
                this.initColumns(columns);
            }
            this.uks = uks;
        }

        @Override
        public final List<Index> getIndexes() {
            return Tools.ignoreNPE(() -> {
                Result<Record> result = this.removeSystemIndexes(MetaImpl.this.meta(meta -> {
                    try (ResultSet rs = MetaImpl.this.catalogSchema(this.getCatalog(), this.getSchema(), (c2, s2) -> meta.getIndexInfo((String)c2, (String)s2, this.getName(), false, true));){
                        Result<Record> result = MetaImpl.this.dsl().fetch(rs, String.class, String.class, String.class, Boolean.TYPE, String.class, String.class, Integer.TYPE, Integer.TYPE, String.class, String.class, Long.TYPE, Long.TYPE, String.class);
                        return result;
                    }
                }));
                result.sortAsc(7).sortAsc(5);
                return this.createIndexes(result);
            }, () -> Collections.emptyList());
        }

        private final Result<Record> removeSystemIndexes(Result<Record> result) {
            if (Boolean.TRUE.equals(MetaImpl.this.settings().isMetaIncludeSystemIndexes())) {
                return result;
            }
            HashSet<String> constraints = new HashSet<String>();
            for (UniqueKey uniqueKey : this.getKeys()) {
                constraints.add(uniqueKey.getName());
            }
            for (ForeignKey foreignKey : this.getReferences()) {
                constraints.add(foreignKey.getName());
            }
            Iterator it2 = result.iterator();
            while (it2.hasNext()) {
                String string = ((Record)it2.next()).get(5, String.class);
                if (constraints.contains(string)) {
                    it2.remove();
                    continue;
                }
                switch (MetaImpl.this.family()) {
                    case DERBY: {
                        if (!P_SYSINDEX_DERBY.matcher(string).matches()) break;
                        it2.remove();
                        break;
                    }
                    case H2: {
                        if (!P_SYSINDEX_H2.matcher(string).matches()) break;
                        it2.remove();
                        break;
                    }
                    case HSQLDB: {
                        if (!P_SYSINDEX_HSQLDB.matcher(string).matches()) break;
                        it2.remove();
                        break;
                    }
                    case SQLITE: {
                        if (!P_SYSINDEX_SQLITE.matcher(string).matches()) break;
                        it2.remove();
                    }
                }
            }
            return result;
        }

        @Override
        public final List<UniqueKey<Record>> getUniqueKeys() {
            ArrayList<UniqueKey<Record>> result = new ArrayList<UniqueKey<Record>>();
            if (this.uks != null) {
                Map<?, Result<Record>> groups = this.uks.intoGroups(this.uks.field(3));
                groups.forEach((k2, v2) -> {
                    v2.sortAsc(5);
                    result.add(this.createUniqueKey((Result<Record>)v2, 4, 3, false));
                });
            }
            return result;
        }

        @Override
        public final UniqueKey<Record> getPrimaryKey() {
            Result<Record> result = MetaImpl.this.meta(meta -> {
                try (ResultSet rs = MetaImpl.this.catalogSchema(this.getCatalog(), this.getSchema(), (c2, s2) -> meta.getPrimaryKeys((String)c2, (String)s2, this.getName()));){
                    Result<Record> result = MetaImpl.this.dsl().fetch(rs, String.class, String.class, String.class, String.class, Integer.TYPE, String.class);
                    return result;
                }
            });
            result.sortAsc(4);
            return this.createUniqueKey(result, 3, 5, true);
        }

        @Override
        public final List<ForeignKey<Record, ?>> getReferences() {
            Result<Record> result = MetaImpl.this.meta(meta -> {
                try (ResultSet rs = MetaImpl.this.catalogSchema(this.getCatalog(), this.getSchema(), (c2, s2) -> meta.getImportedKeys((String)c2, (String)s2, this.getName()));){
                    Result<Record> result = MetaImpl.this.dsl().fetch(rs, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, Short.class, Short.class, Short.class, String.class, String.class);
                    return result;
                }
            });
            Map<Record, Result<Record>> groups = result.intoGroups(new Field[]{result.field(MetaImpl.this.inverseSchemaCatalog ? 1 : 0), result.field(MetaImpl.this.inverseSchemaCatalog ? 0 : 1), result.field(2), result.field(11), result.field(12)});
            HashMap<Name, Schema> schemas = new HashMap<Name, Schema>();
            for (Schema schema : MetaImpl.this.getSchemas()) {
                schemas.put(schema.getQualifiedName(), schema);
            }
            ArrayList references = new ArrayList(groups.size());
            groups.forEach((k2, v2) -> {
                Schema schema = (Schema)schemas.get(MetaImpl.this.hasCatalog(this.getCatalog()) ? DSL.name(StringUtils.defaultString(k2.get(0, String.class)), StringUtils.defaultString(k2.get(1, String.class))) : DSL.name(StringUtils.defaultString(k2.get(1, String.class))));
                String fkName = k2.get(3, String.class);
                String pkName = k2.get(4, String.class);
                Table<Record> pkTable = MetaImpl.this.lookupTable(schema, k2.get(2, String.class));
                TableField[] pkFields = new TableField[v2.size()];
                TableField[] fkFields = new TableField[v2.size()];
                for (int i2 = 0; i2 < v2.size(); ++i2) {
                    Record record = (Record)v2.get(i2);
                    String pkFieldName = record.get(3, String.class);
                    String fkFieldName = record.get(7, String.class);
                    pkFields[i2] = (TableField)pkTable.field(pkFieldName);
                    fkFields[i2] = (TableField)this.field(fkFieldName);
                    if (pkFields[i2] == null && (pkFields[i2] = this.lookup(pkTable, pkFieldName)) == null) {
                        return;
                    }
                    if (fkFields[i2] != null || (fkFields[i2] = this.lookup(this, fkFieldName)) != null) continue;
                    return;
                }
                references.add(new ReferenceImpl<Record, Record>(this, DSL.name(fkName), fkFields, new MetaUniqueKey(pkTable, pkName, pkFields, true), pkFields, true));
            });
            return references;
        }

        private final TableField<Record, ?> lookup(Table<?> table, String fieldName) {
            for (Field<?> field : table.fields()) {
                if (!field.getName().equalsIgnoreCase(fieldName)) continue;
                return (TableField)field;
            }
            log.info("Could not look up key field : " + fieldName + " in table : " + table);
            return null;
        }

        private final UniqueKey<Record> createUniqueKey(Result<Record> result, int columnName, int keyName, boolean isPrimary) {
            if (result.size() > 0) {
                TableField[] f2 = new TableField[result.size()];
                for (int i2 = 0; i2 < f2.length; ++i2) {
                    String name = ((Record)result.get(i2)).get(columnName, String.class);
                    f2[i2] = (TableField)this.field(name);
                    if (f2[i2] != null || MetaImpl.this.family() != SQLDialect.SQLITE) continue;
                    for (Field<?> field : this.fields()) {
                        if (!field.getName().equalsIgnoreCase(name)) continue;
                        f2[i2] = (TableField)field;
                    }
                }
                String indexName = ((Record)result.get(0)).get(keyName, String.class);
                return new MetaUniqueKey(this, indexName, f2, isPrimary);
            }
            return null;
        }

        private final List<Index> createIndexes(Result<Record> result) {
            ArrayList<Index> indexes = new ArrayList<Index>();
            ArrayList<SortField<Object>> sortFields = new ArrayList<SortField<Object>>();
            String previousIndexName = null;
            Name name = null;
            Condition where = null;
            boolean unique = false;
            for (int i2 = 0; i2 < result.size(); ++i2) {
                boolean desc;
                String columnName;
                Field<Object> field;
                Record record = (Record)result.get(i2);
                String indexName = record.get(5, String.class);
                if (indexName == null) continue;
                if (!indexName.equals(previousIndexName)) {
                    previousIndexName = indexName;
                    sortFields.clear();
                    name = DSL.name(record.get(0, String.class), record.get(1, String.class), indexName);
                    String filter = record.get(12, String.class);
                    where = !StringUtils.isBlank(filter) ? DSL.condition(filter) : null;
                    boolean bl2 = unique = record.get(3, Boolean.TYPE) == false;
                }
                if ((field = this.field(columnName = record.get(8, String.class))) == null) {
                    field = DSL.field(columnName);
                }
                sortFields.add((desc = "D".equalsIgnoreCase(record.get(9, String.class))) ? field.desc() : field.asc());
                if (i2 + 1 != result.size() && ((Record)result.get(i2 + 1)).get(5, String.class).equals(previousIndexName)) continue;
                indexes.add(new IndexImpl(name, this, (OrderField[])sortFields.toArray(Tools.EMPTY_SORTFIELD), where, unique));
            }
            return indexes;
        }

        private final void initColumns(Result<Record> columns) {
            boolean hasAutoIncrement = false;
            for (Record column : columns) {
                DataType<Object> type;
                String columnName = column.get(3, String.class);
                String typeName = column.get(5, String.class);
                int precision = column.get(6, Integer.TYPE);
                int scale = column.get(8, Integer.TYPE);
                int nullable = column.get(10, Integer.TYPE);
                String remarks = column.get(11, String.class);
                String defaultValue = column.get(12, String.class);
                if ("null".equalsIgnoreCase(defaultValue)) {
                    defaultValue = null;
                }
                boolean isAutoIncrement = column.size() >= 23 ? column.get(22, Boolean.TYPE) : false;
                try {
                    type = DefaultDataType.getDataType(MetaImpl.this.family(), typeName, precision, scale, !Boolean.FALSE.equals(MetaImpl.this.settings().isForceIntegerTypesOnZeroScaleDecimals()));
                }
                catch (SQLDialectNotSupportedException e2) {
                    type = SQLDataType.OTHER;
                }
                if (isAutoIncrement) {
                    if (!hasAutoIncrement) {
                        hasAutoIncrement = isAutoIncrement;
                        type = type.identity(hasAutoIncrement);
                    } else {
                        log.info((Object)"Multiple identities", "jOOQ does not support tables with multiple identities. Identity is ignored on column: " + columnName);
                    }
                }
                if (nullable == 0) {
                    type = type.nullable(false);
                }
                if (!isAutoIncrement && !StringUtils.isEmpty(defaultValue)) {
                    try {
                        if (EXPRESSION_COLUMN_DEFAULT.contains((Object)MetaImpl.this.dialect())) {
                            if (Boolean.FALSE.equals(MetaImpl.this.settings().isParseMetaDefaultExpressions())) {
                                type = type.defaultValue(DSL.field(defaultValue, type));
                            } else {
                                try {
                                    type = type.defaultValue(MetaImpl.this.dsl().configuration().deriveSettings(s2 -> s2.withParseUnknownFunctions(ParseUnknownFunctions.IGNORE)).dsl().parser().parseField(defaultValue));
                                }
                                catch (ParserException e3) {
                                    log.info((Object)("Cannot parse default expression: " + defaultValue), e3);
                                    type = type.defaultValue(DSL.field(defaultValue, type));
                                }
                            }
                        } else {
                            type = CURRENT_TIMESTAMP_COLUMN_DEFAULT.contains((Object)MetaImpl.this.dialect()) && "CURRENT_TIMESTAMP".equalsIgnoreCase(defaultValue) ? type.defaultValue(DSL.field(defaultValue, type)) : type.defaultValue(DSL.inline((Object)defaultValue, type));
                        }
                    }
                    catch (DataTypeException e4) {
                        log.warn("Default value", "Could not load default value: " + defaultValue + " for type: " + type, e4);
                    }
                }
                MetaTable.createField(DSL.name(columnName), type, this, remarks);
            }
        }
    }

    private final class MetaSchema
    extends SchemaImpl {
        private volatile transient Map<Name, Result<Record>> columnCache;
        private volatile transient Map<Name, Result<Record>> ukCache;
        private volatile transient Map<Name, Result<Record>> sequenceCache;

        MetaSchema(String name, Catalog catalog) {
            super(name, catalog);
        }

        @Override
        public final synchronized List<Table<?>> getTables() {
            Result<Record> tables = MetaImpl.this.meta(meta -> {
                String[] types;
                switch (MetaImpl.this.family()) {
                    case POSTGRES: 
                    case YUGABYTEDB: {
                        types = new String[]{"FOREIGN TABLE", "MATERIALIZED VIEW", "PARTITIONED TABLE", "SYSTEM_TABLE", "SYSTEM TABLE", "SYSTEM_VIEW", "SYSTEM VIEW", "TABLE", "TEMPORARY TABLE", "TEMPORARY VIEW", "VIEW"};
                        break;
                    }
                    case SQLITE: {
                        types = new String[]{"TABLE", "VIEW"};
                        break;
                    }
                    default: {
                        types = null;
                    }
                }
                try (ResultSet rs = MetaImpl.this.catalogSchema(this.getCatalog(), this, (c2, s2) -> meta.getTables((String)c2, (String)s2, "%", types));){
                    Result<Record> result = MetaImpl.this.dsl().fetch(rs, SQLDataType.VARCHAR, SQLDataType.VARCHAR, SQLDataType.VARCHAR, SQLDataType.VARCHAR, SQLDataType.VARCHAR);
                    return result;
                }
            });
            return Tools.map(tables, table -> {
                String catalog = table.get(0, String.class);
                String schema = table.get(1, String.class);
                String name = table.get(2, String.class);
                String type = table.get(3, String.class);
                String remarks = table.get(4, String.class);
                TableOptions.TableType tableType = "VIEW".equals(type) ? TableOptions.TableType.VIEW : ("TEMPORARY VIEW".equals(type) ? TableOptions.TableType.VIEW : ("SYSTEM_VIEW".equals(type) || "SYSTEM VIEW".equals(type) ? TableOptions.TableType.VIEW : ("GLOBAL TEMPORARY".equals(type) ? TableOptions.TableType.TEMPORARY : ("LOCAL TEMPORARY".equals(type) ? TableOptions.TableType.TEMPORARY : ("TEMPORARY".equals(type) ? TableOptions.TableType.TEMPORARY : ("MATERIALIZED VIEW".equals(type) ? TableOptions.TableType.MATERIALIZED_VIEW : TableOptions.TableType.TABLE))))));
                return new MetaTable(name, this, this.getColumns(catalog, schema, name), this.getUks(catalog, schema, name), remarks, tableType);
            });
        }

        private final Result<Record> getUks(String catalog, String schema, String table) {
            if (this.ukCache == null) {
                if (MetaImpl.this.family() == SQLDialect.SQLITE) {
                    this.initUksSQLite(catalog, schema);
                } else {
                    this.initUks(catalog, schema);
                }
            }
            if (this.ukCache != null) {
                return this.ukCache.get(DSL.name(catalog, schema, table));
            }
            return null;
        }

        private final void initUks(String catalog, String schema) {
            String sql = MetaSQL.M_UNIQUE_KEYS(MetaImpl.this.family());
            if (sql != null) {
                Result<Record> result = MetaImpl.this.meta(meta -> {
                    Object[] objectArray;
                    DSLContext dSLContext = DSL.using(meta.getConnection(), MetaImpl.this.family());
                    if (NO_SUPPORT_SCHEMAS.contains((Object)MetaImpl.this.dialect())) {
                        objectArray = Tools.EMPTY_OBJECT;
                    } else if (MetaImpl.this.inverseSchemaCatalog) {
                        Object[] objectArray2 = new Object[1];
                        objectArray = objectArray2;
                        objectArray2[0] = catalog;
                    } else {
                        Object[] objectArray3 = new Object[1];
                        objectArray = objectArray3;
                        objectArray3[0] = schema;
                    }
                    return dSLContext.resultQuery(sql, objectArray).fetch();
                });
                Map<Record, Result<Record>> groups = result.intoGroups(new Field[]{result.field(0), result.field(1), result.field(2)});
                this.ukCache = new LinkedHashMap<Name, Result<Record>>();
                groups.forEach((k2, v2) -> this.ukCache.put(DSL.name(catalog == null ? null : k2.get(0, String.class), k2.get(1, String.class), k2.get(2, String.class)), (Result<Record>)v2));
            }
        }

        private void initUksSQLite(String catalog, String schema) {
            this.ukCache = new LinkedHashMap<Name, Result<Record>>();
            MetaImpl.this.dsl().resultQuery("select m.tbl_name, m.sql\nfrom sqlite_master as m\nwhere m.type = 'table'\nand exists (\n  select 1\n  from pragma_index_list(m.name) as il\n  where il.origin = 'u'\n)\norder by m.tbl_name\n").fetchMap(DSL.field("tbl_name", SQLDataType.VARCHAR), DSL.field("sql", SQLDataType.VARCHAR)).forEach((table, sql) -> {
                try {
                    Field<String> fCatalogName = DSL.field("catalog_name", SQLDataType.VARCHAR);
                    Field<String> fSchemaName = DSL.field("schema_name", SQLDataType.VARCHAR);
                    Field<String> fTableName = DSL.field("table_name", SQLDataType.VARCHAR);
                    Field<String> fConstraintName = DSL.field("constraint_name", SQLDataType.VARCHAR);
                    Field<String> fColumnName = DSL.field("column_name", SQLDataType.VARCHAR);
                    Field<Integer> fSequenceNo = DSL.field("sequence_no", SQLDataType.INTEGER);
                    Field[] fields2 = new Field[]{fCatalogName, fSchemaName, fTableName, fConstraintName, fColumnName, fSequenceNo};
                    for (Table<?> t2 : MetaImpl.this.dsl().meta(Source.of(sql)).getTables((String)table)) {
                        Result<Record> result = MetaImpl.this.dsl().newResult(fields2);
                        int i2 = 0;
                        for (UniqueKey<?> uk : t2.getUniqueKeys()) {
                            for (Field field : uk.getFields()) {
                                result.add(MetaImpl.this.dsl().newRecord(fCatalogName, fSchemaName, fTableName, fConstraintName, fColumnName, fSequenceNo).values(catalog, schema, (String)table, uk.getName(), field.getName(), i2++));
                            }
                        }
                        this.ukCache.put(DSL.name(catalog, schema, table), result);
                    }
                }
                catch (DataDefinitionException | ParserException e2) {
                    log.info((Object)("Cannot parse or interpret sql for table " + table + ": " + sql), e2);
                }
            });
        }

        private final Result<Record> getColumns(String catalog, String schema, String table) {
            if (this.columnCache == null && MetaImpl.this.family() != SQLDialect.SQLITE) {
                Result<Record> columns = this.getColumns0(catalog, schema, "%");
                Field<?> tableCat = columns.field(0);
                Field<?> tableSchem = columns.field(1);
                Field<?> tableName = columns.field(2);
                Map<Record, Result<Record>> groups = columns.intoGroups(new Field[]{tableCat, tableSchem, tableName});
                this.columnCache = new LinkedHashMap<Name, Result<Record>>();
                groups.forEach((k2, v2) -> this.columnCache.put(DSL.name((String)k2.get(tableCat), (String)k2.get(tableSchem), (String)k2.get(tableName)), (Result<Record>)v2));
            }
            if (this.columnCache != null) {
                return this.columnCache.get(DSL.name(catalog, schema, table));
            }
            return this.getColumns0(catalog, schema, table);
        }

        private final Result<Record> getColumns0(String catalog, String schema, String table) {
            return MetaImpl.this.meta(meta -> {
                try (ResultSet rs = MetaImpl.this.catalogSchema(catalog, schema, (c2, s2) -> meta.getColumns((String)c2, (String)s2, table, "%"));){
                    Result<Record> result = rs.getMetaData().getColumnCount() < GET_COLUMNS_EXTENDED.length ? MetaImpl.this.dsl().fetch(rs, GET_COLUMNS_SHORT) : MetaImpl.this.dsl().fetch(rs, GET_COLUMNS_EXTENDED);
                    return result;
                }
            });
        }

        @Override
        public List<Sequence<?>> getSequences() {
            Result<Record> result = this.getSequences0();
            return result != null ? Tools.map(result, r2 -> Internal.createSequence(r2.get(2, String.class), this, DefaultDataType.getDataType(MetaImpl.this.family(), r2.get(3, String.class), r2.get(4, Integer.TYPE), r2.get(5, Integer.TYPE), !Boolean.FALSE.equals(MetaImpl.this.settings().isForceIntegerTypesOnZeroScaleDecimals())), r2.get(6, Long.class), r2.get(7, Long.class), r2.get(8, Long.class), r2.get(9, Long.class), r2.get(10, Boolean.TYPE), r2.get(11, Long.class))) : new ArrayList();
        }

        private final Result<Record> getSequences0() {
            if (this.sequenceCache == null) {
                String sql;
                String string = sql = Boolean.TRUE.equals(MetaImpl.this.settings().isMetaIncludeSystemSequences()) ? MetaSQL.M_SEQUENCES_INCLUDING_SYSTEM_SEQUENCES(MetaImpl.this.family()) : MetaSQL.M_SEQUENCES(MetaImpl.this.family());
                if (sql != null) {
                    Result<Record> result = MetaImpl.this.meta(meta -> DSL.using(meta.getConnection(), MetaImpl.this.family()).resultQuery(sql, this.getName()).fetch());
                    Map<Record, Result<Record>> groups = result.intoGroups(new Field[]{result.field(0), result.field(1)});
                    this.sequenceCache = new LinkedHashMap<Name, Result<Record>>();
                    groups.forEach((k2, v2) -> this.sequenceCache.put(DSL.name(k2.get(0, String.class), k2.get(1, String.class)), (Result<Record>)v2));
                }
            }
            if (this.sequenceCache != null) {
                return this.sequenceCache.get(DSL.name(this.getCatalog().getName(), this.getName()));
            }
            return null;
        }
    }

    private final class MetaCatalog
    extends CatalogImpl {
        MetaCatalog(String name) {
            super(name);
        }

        @Override
        public final List<Schema> getSchemas() {
            ArrayList<Schema> result = new ArrayList<Schema>();
            if (!MetaImpl.this.inverseSchemaCatalog) {
                Result<Record> schemas = MetaImpl.this.meta(meta -> MetaImpl.this.dsl().fetch(meta.getSchemas(), SQLDataType.VARCHAR));
                for (String name : schemas.getValues(0, String.class)) {
                    result.add(new MetaSchema(name, this));
                }
            } else {
                Result<Record> schemas = MetaImpl.this.meta(meta -> MetaImpl.this.dsl().fetch(meta.getCatalogs(), SQLDataType.VARCHAR));
                for (String name : schemas.getValues(0, String.class)) {
                    result.add(new MetaSchema(name, this));
                }
            }
            if (result.isEmpty()) {
                result.add(new MetaSchema("", this));
            }
            return result;
        }
    }
}

