/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Fields;
import org.jooq.Record;
import org.jooq.Result;
import org.jooq.impl.AbstractRow;
import org.jooq.impl.DSL;
import org.jooq.impl.DefaultDataType;
import org.jooq.impl.ResultImpl;
import org.jooq.impl.SQLDataType;
import org.jooq.impl.Tools;
import org.jooq.tools.StringUtils;
import org.jooq.tools.json.ContainerFactory;
import org.jooq.tools.json.JSONParser;

final class JSONReader<R extends Record> {
    private final DSLContext ctx;
    private final AbstractRow<R> row;
    private final Class<? extends R> recordType;

    JSONReader(DSLContext ctx, AbstractRow<R> row, Class<? extends R> recordType) {
        this.ctx = ctx;
        this.row = row;
        this.recordType = recordType != null ? recordType : Record.class;
    }

    final Result<R> read(String string) {
        return this.read(new StringReader(string));
    }

    final Result<R> read(Reader reader) {
        return this.read(reader, false);
    }

    final Result<R> read(Reader reader, boolean multiset) {
        try {
            Object root = new JSONParser().parse(reader, new ContainerFactory(){

                @Override
                public Map createObjectContainer() {
                    return new LinkedHashMap();
                }

                @Override
                public List createArrayContainer() {
                    return new ArrayList();
                }
            });
            return JSONReader.read(this.ctx, this.row, this.recordType, multiset, root);
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
    }

    private static final <R extends Record> Result<R> read(DSLContext ctx, AbstractRow<R> actualRow, Class<? extends R> recordType, boolean multiset, Object root) {
        List records;
        ArrayList header = new ArrayList();
        ResultImpl result = null;
        if (root instanceof Map) {
            Map o1 = (Map)root;
            List fields2 = (List)o1.get("fields");
            if (fields2 != null) {
                for (Object field : fields2) {
                    String catalog = (String)field.get("catalog");
                    String schema = (String)field.get("schema");
                    String table = (String)field.get("table");
                    String name = (String)field.get("name");
                    String type = (String)field.get("type");
                    header.add(DSL.field(DSL.name(catalog, schema, table, name), DefaultDataType.getDataType(ctx.dialect(), StringUtils.defaultIfBlank(type, "VARCHAR"))));
                }
            }
            records = (List)o1.get("records");
        } else {
            records = (List)root;
        }
        if (actualRow == null && !header.isEmpty()) {
            actualRow = Tools.row0(header);
        }
        if (actualRow != null) {
            result = new ResultImpl(ctx.configuration(), (AbstractRow)actualRow);
        }
        if (records != null) {
            for (Object o3 : records) {
                Object record;
                if (o3 instanceof Map) {
                    record = (Map)o3;
                    if (result == null) {
                        if (header.isEmpty()) {
                            for (String name : record.keySet()) {
                                header.add(DSL.field(DSL.name(name), SQLDataType.VARCHAR));
                            }
                        }
                        actualRow = Tools.row0(header);
                        result = new ResultImpl(ctx.configuration(), (AbstractRow)actualRow);
                    }
                    List<Object> list = multiset ? JSONReader.patchRecord(ctx, multiset, actualRow, record.entrySet().stream().sorted(Comparator.comparing(Map.Entry::getKey)).map(Map.Entry::getValue).collect(Collectors.toList())) : null;
                    result.add(Tools.newRecord(true, recordType, actualRow, ctx.configuration()).operate(arg_0 -> JSONReader.lambda$read$0(multiset, list, (Map)record, arg_0)));
                    continue;
                }
                record = (List)o3;
                if (result == null) {
                    if (header.isEmpty()) {
                        header.addAll(Arrays.asList(Tools.fields(record.size())));
                    }
                    actualRow = Tools.row0(header);
                    result = new ResultImpl(ctx.configuration(), (AbstractRow)actualRow);
                }
                JSONReader.patchRecord(ctx, multiset, actualRow, (List<Object>)record);
                result.add(Tools.newRecord(true, recordType, actualRow, ctx.configuration()).operate(arg_0 -> JSONReader.lambda$read$1((List)record, arg_0)));
            }
        }
        return result;
    }

    private static final List<Object> patchRecord(DSLContext ctx, boolean multiset, Fields result, List<Object> record) {
        for (int i2 = 0; i2 < result.fields().length; ++i2) {
            Field<?> field = result.field(i2);
            if (field.getType() == byte[].class && record.get(i2) instanceof String) {
                record.set(i2, Base64.getDecoder().decode((String)record.get(i2)));
                continue;
            }
            if (!multiset || !field.getDataType().isMultiset()) continue;
            record.set(i2, JSONReader.read(ctx, (AbstractRow)field.getDataType().getRow(), field.getDataType().getRecordType(), multiset, record.get(i2)));
        }
        return record;
    }

    private static /* synthetic */ Record lambda$read$1(List record, Record r2) throws RuntimeException {
        r2.from(record);
        r2.changed(false);
        return r2;
    }

    private static /* synthetic */ Record lambda$read$0(boolean multiset, List list, Map record, Record r2) throws RuntimeException {
        if (multiset) {
            r2.from(list);
        } else {
            r2.fromMap(record);
        }
        r2.changed(false);
        return r2;
    }
}

