/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.Collection;
import org.jooq.Context;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.Function4;
import org.jooq.JSONArrayNullStep;
import org.jooq.JSONArrayReturningStep;
import org.jooq.QueryPart;
import org.jooq.Row1;
import org.jooq.SQLDialect;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.impl.AbstractField;
import org.jooq.impl.AbstractQueryPart;
import org.jooq.impl.CustomField;
import org.jooq.impl.DSL;
import org.jooq.impl.JSONEntryImpl;
import org.jooq.impl.JSONNull;
import org.jooq.impl.JSONReturning;
import org.jooq.impl.Names;
import org.jooq.impl.QOM;
import org.jooq.impl.QueryPartCollectionView;
import org.jooq.impl.QueryPartList;
import org.jooq.impl.QueryPartListView;
import org.jooq.impl.SQLDataType;
import org.jooq.impl.Tools;
import org.jooq.tools.StringUtils;

final class JSONArray<T>
extends AbstractField<T>
implements QOM.JSONArray<T>,
JSONArrayNullStep<T>,
JSONArrayReturningStep<T> {
    final DataType<T> type;
    final QueryPartListView<? extends Field<?>> fields;
    QOM.JSONOnNull onNull;
    DataType<?> returning;

    JSONArray(DataType<T> type, Collection<? extends Field<?>> fields2) {
        this(type, fields2, null, null);
    }

    JSONArray(DataType<T> type, Collection<? extends Field<?>> fields2, QOM.JSONOnNull onNull, DataType<?> returning) {
        super(Names.N_JSON_ARRAY, type);
        this.type = type;
        this.fields = new QueryPartList((Iterable<Field<?>>)fields2);
        this.onNull = onNull;
        this.returning = returning;
    }

    @Override
    public final JSONArray<T> nullOnNull() {
        this.onNull = QOM.JSONOnNull.NULL_ON_NULL;
        return this;
    }

    @Override
    public final JSONArray<T> absentOnNull() {
        this.onNull = QOM.JSONOnNull.ABSENT_ON_NULL;
        return this;
    }

    @Override
    public final JSONArray<T> returning(DataType<?> returning) {
        this.returning = returning;
        return this;
    }

    @Override
    public void accept(Context<?> ctx) {
        QueryPartCollectionView<Field<?>> mapped = QueryPartCollectionView.wrap(this.fields).map(JSONEntryImpl.jsonCastMapper(ctx));
        switch (ctx.family()) {
            case POSTGRES: 
            case YUGABYTEDB: {
                if (this.onNull == QOM.JSONOnNull.ABSENT_ON_NULL && !mapped.isEmpty()) {
                    Row1[] rows = Tools.map(this.fields, f2 -> DSL.row(f2), Row1[]::new);
                    Table t2 = DSL.values(rows).as("t", "a");
                    Field<?> a2 = t2.field("a");
                    ctx.visit(DSL.field(DSL.select(this.getDataType() == SQLDataType.JSON ? DSL.jsonArrayAgg(a2) : DSL.jsonbArrayAgg(a2)).from((TableLike<?>)t2).where(a2.isNotNull())));
                    break;
                }
                ctx.visit(this.getDataType() == SQLDataType.JSON ? Names.N_JSON_BUILD_ARRAY : Names.N_JSONB_BUILD_ARRAY).sql('(').visit(mapped).sql(')');
                break;
            }
            default: {
                JSONNull jsonNull = ctx.family() == SQLDialect.H2 && this.fields.isEmpty() ? new JSONNull(QOM.JSONOnNull.NULL_ON_NULL) : new JSONNull(this.onNull);
                JSONReturning jsonReturning = new JSONReturning(this.returning);
                CustomField jsonArray = CustomField.of(Names.N_JSON_ARRAY, this.getDataType(), c2 -> c2.visit(Names.N_JSON_ARRAY).sql('(').visit(QueryPartListView.wrap((QueryPart[])new AbstractQueryPart[]{mapped, jsonNull, jsonReturning}).separator("")).sql(')'));
                switch (ctx.family()) {
                    default: 
                }
                ctx.visit(jsonArray);
                break;
            }
        }
    }

    @Override
    public final DataType<T> $type() {
        return this.type;
    }

    @Override
    public final QOM.UnmodifiableList<? extends Field<?>> $fields() {
        return QOM.unmodifiable(this.fields);
    }

    @Override
    public final QOM.JSONOnNull $onNull() {
        return this.onNull;
    }

    @Override
    public final DataType<?> $returning() {
        return this.returning;
    }

    @Override
    public final QOM.JSONArray<T> $type(DataType<T> newValue) {
        return this.constructor().apply(newValue, this.$fields(), this.$onNull(), this.$returning());
    }

    @Override
    public final QOM.JSONArray<T> $fields(QOM.UnmodifiableList<? extends Field<?>> newValue) {
        return this.constructor().apply(this.$type(), newValue, this.$onNull(), this.$returning());
    }

    @Override
    public final QOM.JSONArray<T> $onNull(QOM.JSONOnNull newValue) {
        return this.constructor().apply(this.$type(), this.$fields(), newValue, this.$returning());
    }

    @Override
    public final QOM.JSONArray<T> $returning(DataType<?> newValue) {
        return this.constructor().apply(this.$type(), this.$fields(), this.$onNull(), newValue);
    }

    public final Function4<? super DataType<T>, ? super QOM.UnmodifiableList<? extends Field<?>>, ? super QOM.JSONOnNull, ? super DataType<?>, ? extends QOM.JSONArray<T>> constructor() {
        return (a1, a2, a3, a4) -> new JSONArray(a1, (Collection<? extends Field<?>>)((Collection<Field<?>>)a2), (QOM.JSONOnNull)((Object)a3), (DataType<?>)a4);
    }

    @Override
    public boolean equals(Object that) {
        if (that instanceof QOM.JSONArray) {
            QOM.JSONArray o2 = (QOM.JSONArray)that;
            return StringUtils.equals(this.$type(), o2.$type()) && StringUtils.equals(this.$fields(), o2.$fields()) && StringUtils.equals((Object)this.$onNull(), (Object)o2.$onNull()) && StringUtils.equals(this.$returning(), o2.$returning());
        }
        return super.equals(that);
    }
}

