/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.Set;
import org.jooq.Clause;
import org.jooq.Configuration;
import org.jooq.Context;
import org.jooq.DropSchemaFinalStep;
import org.jooq.DropSchemaStep;
import org.jooq.Function3;
import org.jooq.SQLDialect;
import org.jooq.Schema;
import org.jooq.impl.AbstractDDLQuery;
import org.jooq.impl.DDLStatementType;
import org.jooq.impl.Keywords;
import org.jooq.impl.QOM;
import org.jooq.impl.Tools;

final class DropSchemaImpl
extends AbstractDDLQuery
implements QOM.DropSchema,
DropSchemaStep,
DropSchemaFinalStep {
    final Schema schema;
    final boolean ifExists;
    QOM.Cascade cascade;
    private static final Clause[] CLAUSES = new Clause[]{Clause.DROP_SCHEMA};
    private static final Set<SQLDialect> NO_SUPPORT_IF_EXISTS = SQLDialect.supportedBy(SQLDialect.DERBY, SQLDialect.FIREBIRD);
    private static final Set<SQLDialect> REQUIRES_RESTRICT = SQLDialect.supportedBy(SQLDialect.DERBY);

    DropSchemaImpl(Configuration configuration, Schema schema, boolean ifExists) {
        this(configuration, schema, ifExists, null);
    }

    DropSchemaImpl(Configuration configuration, Schema schema, boolean ifExists, QOM.Cascade cascade) {
        super(configuration);
        this.schema = schema;
        this.ifExists = ifExists;
        this.cascade = cascade;
    }

    @Override
    public final DropSchemaImpl cascade() {
        this.cascade = QOM.Cascade.CASCADE;
        return this;
    }

    @Override
    public final DropSchemaImpl restrict() {
        this.cascade = QOM.Cascade.RESTRICT;
        return this;
    }

    private final boolean supportsIfExists(Context<?> ctx) {
        return !NO_SUPPORT_IF_EXISTS.contains((Object)ctx.dialect());
    }

    @Override
    public final void accept(Context<?> ctx) {
        this.accept0(ctx);
    }

    private void accept0(Context<?> ctx) {
        if (this.ifExists && !this.supportsIfExists(ctx)) {
            Tools.tryCatch(ctx, DDLStatementType.DROP_SCHEMA, c2 -> this.accept1((Context<?>)c2));
        } else {
            this.accept1(ctx);
        }
    }

    private void accept1(Context<?> ctx) {
        ctx.start(Clause.DROP_SCHEMA_SCHEMA).visit(Keywords.K_DROP);
        ctx.sql(' ').visit(Keywords.K_SCHEMA);
        if (this.ifExists && this.supportsIfExists(ctx)) {
            ctx.sql(' ').visit(Keywords.K_IF_EXISTS);
        }
        ctx.sql(' ').visit(this.schema);
        if (this.cascade == QOM.Cascade.CASCADE) {
            ctx.sql(' ').visit(Keywords.K_CASCADE);
        } else if (this.cascade == QOM.Cascade.RESTRICT || REQUIRES_RESTRICT.contains((Object)ctx.dialect())) {
            ctx.sql(' ').visit(Keywords.K_RESTRICT);
        }
        ctx.end(Clause.DROP_SCHEMA_SCHEMA);
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return CLAUSES;
    }

    @Override
    public final Schema $schema() {
        return this.schema;
    }

    @Override
    public final boolean $ifExists() {
        return this.ifExists;
    }

    @Override
    public final QOM.Cascade $cascade() {
        return this.cascade;
    }

    @Override
    public final QOM.DropSchema $schema(Schema newValue) {
        return this.constructor().apply(newValue, (Boolean)this.$ifExists(), this.$cascade());
    }

    @Override
    public final QOM.DropSchema $ifExists(boolean newValue) {
        return this.constructor().apply(this.$schema(), (Boolean)newValue, this.$cascade());
    }

    @Override
    public final QOM.DropSchema $cascade(QOM.Cascade newValue) {
        return this.constructor().apply(this.$schema(), (Boolean)this.$ifExists(), newValue);
    }

    public final Function3<? super Schema, ? super Boolean, ? super QOM.Cascade, ? extends QOM.DropSchema> constructor() {
        return (a1, a2, a3) -> new DropSchemaImpl(this.configuration(), (Schema)a1, (boolean)a2, (QOM.Cascade)((Object)a3));
    }
}

