/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.math.BigDecimal;
import org.jooq.Context;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.Keyword;
import org.jooq.QueryPart;
import org.jooq.RenderContext;
import org.jooq.impl.AbstractField;
import org.jooq.impl.AbstractQueryPart;
import org.jooq.impl.DSL;
import org.jooq.impl.Keywords;
import org.jooq.impl.Names;
import org.jooq.impl.QOM;
import org.jooq.impl.SQLDataType;

final class Cast<T>
extends AbstractField<T>
implements QOM.Cast<T> {
    private final Field<?> field;

    public Cast(Field<?> field, DataType<T> type) {
        super(Names.N_CAST, type.nullable(field.getDataType().nullable()));
        this.field = field;
    }

    private final DataType<T> getSQLDataType() {
        return this.getDataType().getSQLDataType();
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case DERBY: {
                ctx.visit(new CastDerby());
                break;
            }
            default: {
                ctx.visit(new CastNative(this.field, this.getDataType()));
            }
        }
    }

    @Override
    public final Field<?> $field() {
        return this.field;
    }

    static class CastNative<T>
    extends AbstractQueryPart
    implements QOM.UTransient {
        private final QueryPart expression;
        private final DataType<T> type;
        private final Keyword typeAsKeyword;

        CastNative(QueryPart expression, DataType<T> type) {
            this.expression = expression;
            this.type = type;
            this.typeAsKeyword = null;
        }

        CastNative(QueryPart expression, Keyword typeAsKeyword) {
            this.expression = expression;
            this.type = null;
            this.typeAsKeyword = typeAsKeyword;
        }

        @Override
        public void accept(Context<?> ctx) {
            RenderContext.CastMode castMode = ctx.castMode();
            ctx.visit(Keywords.K_CAST).sql('(').castMode(RenderContext.CastMode.NEVER).visit(this.expression).castMode(castMode).sql(' ').visit(Keywords.K_AS).sql(' ');
            if (this.typeAsKeyword != null) {
                ctx.visit(this.typeAsKeyword);
            } else {
                ctx.sql(this.type.getCastTypeName(ctx.configuration()));
            }
            ctx.sql(')');
        }
    }

    private final class CastDerby
    extends CastNative<T> {
        CastDerby() {
            super(Cast.this.field, Cast.this.getDataType());
        }

        private final Field<Boolean> asDecodeNumberToBoolean() {
            return DSL.choose(Cast.this.field).when((Field<?>)DSL.inline(0), DSL.inline(false)).when(DSL.inline((Integer)null), DSL.inline((Boolean)null)).otherwise(DSL.inline(true));
        }

        private final Field<Boolean> asDecodeVarcharToBoolean() {
            Field<String> s2 = Cast.this.field;
            return DSL.when(s2.equal(DSL.inline("0")), DSL.inline(false)).when(DSL.lower(s2).equal(DSL.inline("false")), DSL.inline(false)).when(DSL.lower(s2).equal(DSL.inline("f")), DSL.inline(false)).when(s2.isNull(), DSL.inline((Boolean)null)).otherwise(DSL.inline(true));
        }

        @Override
        public final void accept(Context<?> ctx) {
            DataType type = Cast.this.getSQLDataType();
            if (Cast.this.field.getDataType().isNumeric() && type.isString() && !SQLDataType.CHAR.equals(type)) {
                ctx.visit(Keywords.K_TRIM).sql('(').visit(new CastNative(new CastNative<String>(Cast.this.field, SQLDataType.CHAR(38)), Cast.this.getDataType())).sql(')');
            } else if (Cast.this.field.getDataType().isString() && (SQLDataType.FLOAT.equals(type) || SQLDataType.DOUBLE.equals(type) || SQLDataType.REAL.equals(type))) {
                ctx.visit(new CastNative(new CastNative<BigDecimal>(Cast.this.field, SQLDataType.DECIMAL), Cast.this.getDataType()));
            } else if (Cast.this.field.getDataType().isNumeric() && SQLDataType.BOOLEAN.equals(type)) {
                ctx.visit(this.asDecodeNumberToBoolean());
            } else if (Cast.this.field.getDataType().isString() && SQLDataType.BOOLEAN.equals(type)) {
                ctx.visit(this.asDecodeVarcharToBoolean());
            } else {
                super.accept(ctx);
            }
        }
    }
}

