/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import org.jooq.Configuration;
import org.jooq.ExecuteContext;
import org.jooq.ExecuteListener;
import org.jooq.ExecuteType;
import org.jooq.Param;
import org.jooq.Query;
import org.jooq.Record;
import org.jooq.RenderContext;
import org.jooq.conf.ParamType;
import org.jooq.conf.QueryPoolable;
import org.jooq.conf.SettingsTools;
import org.jooq.conf.ThrowExceptions;
import org.jooq.exception.ControlFlowSignal;
import org.jooq.exception.DetachedException;
import org.jooq.impl.AbstractAttachableQueryPart;
import org.jooq.impl.AbstractParamX;
import org.jooq.impl.DSL;
import org.jooq.impl.DefaultExecuteContext;
import org.jooq.impl.DefaultRenderContext;
import org.jooq.impl.ExecuteListeners;
import org.jooq.impl.ExecutorProviderCompletionStage;
import org.jooq.impl.NoConnectionFactory;
import org.jooq.impl.ParamCollector;
import org.jooq.impl.Tools;
import org.jooq.tools.Ints;
import org.jooq.tools.JooqLogger;

abstract class AbstractQuery<R extends Record>
extends AbstractAttachableQueryPart
implements Query {
    private static final JooqLogger log = JooqLogger.getLogger(AbstractQuery.class);
    private int timeout;
    private QueryPoolable poolable = QueryPoolable.DEFAULT;
    private boolean keepStatement;
    transient PreparedStatement statement;
    transient int statementExecutionCount;
    transient DefaultRenderContext.Rendered rendered;

    AbstractQuery(Configuration configuration) {
        super(configuration);
    }

    final void toSQLSemiColon(RenderContext ctx) {
    }

    @Override
    public Query bind(String param, Object value) {
        Integer index = Ints.tryParse(param);
        if (index != null) {
            return this.bind(index, value);
        }
        ParamCollector collector = new ParamCollector(this.configuration(), true);
        collector.visit(this);
        List<Param<?>> params = collector.result.get(param);
        if (params == null || params.size() == 0) {
            throw new IllegalArgumentException("No such parameter : " + param);
        }
        for (Param<?> p2 : params) {
            ((AbstractParamX)p2).setConverted0(value);
            this.closeIfNecessary(p2);
        }
        return this;
    }

    @Override
    public Query bind(int index, Object value) {
        Param<?>[] params = this.getParams().values().toArray(Tools.EMPTY_PARAM);
        if (index < 1 || index > params.length) {
            throw new IllegalArgumentException("Index out of range for Query parameters : " + index);
        }
        AbstractParamX param = (AbstractParamX)params[index - 1];
        param.setConverted0(value);
        this.closeIfNecessary(param);
        return this;
    }

    private final void closeIfNecessary(Param<?> param) {
        if (this.keepStatement() && this.statement != null) {
            if (param.isInline()) {
                this.close();
            } else if (SettingsTools.getParamType(this.configuration().settings()) == ParamType.INLINED) {
                this.close();
            }
        }
    }

    @Override
    public Query poolable(boolean p2) {
        this.poolable = p2 ? QueryPoolable.TRUE : QueryPoolable.FALSE;
        return this;
    }

    @Override
    public Query queryTimeout(int t2) {
        this.timeout = t2;
        return this;
    }

    @Override
    public Query keepStatement(boolean k2) {
        this.keepStatement = k2;
        return this;
    }

    protected final boolean keepStatement() {
        return this.keepStatement;
    }

    @Override
    public final void close() {
        if (this.statement != null) {
            try {
                this.statement.close();
                this.statement = null;
            }
            catch (SQLException e2) {
                throw Tools.translate(this.rendered.sql, e2);
            }
        }
    }

    @Override
    public final void cancel() {
        if (this.statement != null) {
            try {
                this.statement.cancel();
            }
            catch (SQLException e2) {
                throw Tools.translate(this.rendered.sql, e2);
            }
        }
    }

    @Override
    public final int execute() {
        if (this.isExecutable()) {
            Configuration c2 = this.configurationOrDefault();
            DefaultExecuteContext ctx = new DefaultExecuteContext(c2, this);
            ExecuteListener listener = ExecuteListeners.get(ctx);
            int result = 0;
            try {
                QueryPoolable p2;
                listener.start(ctx);
                if (this.keepStatement() && this.statement != null) {
                    ctx.sql(this.rendered.sql);
                    ctx.statement(this.statement);
                    ctx.connection(c2.connectionProvider(), this.statement.getConnection());
                    ctx.withStatementExecutionCount(++this.statementExecutionCount);
                } else {
                    listener.renderStart(ctx);
                    this.rendered = this.getSQL0(ctx);
                    ctx.sql(this.rendered.sql);
                    listener.renderEnd(ctx);
                    this.rendered.sql = ctx.sql();
                    if (ctx.connection() == null) {
                        if (ctx.configuration().connectionFactory() instanceof NoConnectionFactory) {
                            throw new DetachedException("Cannot execute query. No JDBC Connection configured");
                        }
                        throw new DetachedException("Attempt to execute a blocking method (e.g. Query.execute() or ResultQuery.fetch()) when only an R2BDC ConnectionFactory was configured. jOOQ's RowCountQuery and ResultQuery extend Publisher, which allows for reactive streams implementations to subscribe to the results of a jOOQ query. Simply embed your query in the stream, e.g. using Flux.from(query). See also: https://www.jooq.org/doc/latest/manual/sql-execution/fetching/reactive-fetching/");
                    }
                    listener.prepareStart(ctx);
                    this.prepare(ctx);
                    listener.prepareEnd(ctx);
                    this.statement = ctx.statement();
                }
                int t2 = SettingsTools.getQueryTimeout(this.timeout, ctx.settings());
                if (t2 != 0) {
                    ctx.statement().setQueryTimeout(t2);
                }
                if ((p2 = SettingsTools.getQueryPoolable(this.poolable, ctx.settings())) == QueryPoolable.TRUE) {
                    ctx.statement().setPoolable(true);
                } else if (p2 == QueryPoolable.FALSE) {
                    ctx.statement().setPoolable(false);
                }
                if (SettingsTools.executePreparedStatements(c2.settings()) && !Boolean.TRUE.equals(ctx.data((Object)Tools.BooleanDataKey.DATA_FORCE_STATIC_STATEMENT))) {
                    listener.bindStart(ctx);
                    if (this.rendered.bindValues != null) {
                        DSL.using(c2).bindContext(ctx.statement()).visit(this.rendered.bindValues);
                    }
                    listener.bindEnd(ctx);
                }
                int n2 = result = this.execute(ctx, listener);
                return n2;
            }
            catch (ControlFlowSignal e2) {
                throw e2;
            }
            catch (RuntimeException e3) {
                ctx.exception(e3);
                listener.exception(ctx);
                throw ctx.exception();
            }
            catch (SQLException e4) {
                ctx.sqlException(e4);
                listener.exception(ctx);
                throw ctx.exception();
            }
            finally {
                if (!this.keepResultSet() || ctx.exception() != null) {
                    Tools.safeClose(listener, ctx, this.keepStatement());
                }
                if (!this.keepStatement()) {
                    this.statement = null;
                    this.rendered = null;
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Query is not executable", this);
        }
        return 0;
    }

    @Override
    public final CompletionStage<Integer> executeAsync() {
        return this.executeAsync(Tools.configuration(this).executorProvider().provide());
    }

    @Override
    public final CompletionStage<Integer> executeAsync(Executor executor) {
        return ExecutorProviderCompletionStage.of(CompletableFuture.supplyAsync(Tools.blocking(this::execute), executor), () -> executor);
    }

    protected boolean keepResultSet() {
        return false;
    }

    protected void prepare(ExecuteContext ctx) throws SQLException {
        if (ctx.statement() == null) {
            ctx.statement(ctx.connection().prepareStatement(ctx.sql()));
        }
    }

    protected int execute(ExecuteContext ctx, ExecuteListener listener) throws SQLException {
        int result = 0;
        PreparedStatement stmt = ctx.statement();
        try {
            listener.executeStart(ctx);
            if (!stmt.execute()) {
                result = stmt.getUpdateCount();
                ctx.rows(result);
            }
            listener.executeEnd(ctx);
            return result;
        }
        catch (SQLException e2) {
            Tools.consumeExceptions(ctx.configuration(), stmt, e2);
            if (ctx.settings().getThrowExceptions() != ThrowExceptions.THROW_NONE) {
                throw e2;
            }
            return stmt.getUpdateCount();
        }
    }

    @Override
    public boolean isExecutable() {
        return true;
    }

    private final DefaultRenderContext.Rendered getSQL0(ExecuteContext ctx) {
        DefaultRenderContext.Rendered result;
        Configuration c2 = this.configurationOrThrow();
        if (ctx.type() == ExecuteType.DDL) {
            ctx.data((Object)Tools.BooleanDataKey.DATA_FORCE_STATIC_STATEMENT, true);
            DefaultRenderContext render = new DefaultRenderContext(c2, ctx);
            result = new DefaultRenderContext.Rendered(((RenderContext)((RenderContext)render.paramType(ParamType.INLINED)).visit(this)).render(), null, render.skipUpdateCounts());
        } else if (SettingsTools.executePreparedStatements(this.configuration().settings())) {
            try {
                DefaultRenderContext render = new DefaultRenderContext(c2, ctx);
                render.data((Object)Tools.BooleanDataKey.DATA_COUNT_BIND_VALUES, true);
                result = new DefaultRenderContext.Rendered(((RenderContext)render.visit(this)).render(), render.bindValues(), render.skipUpdateCounts());
            }
            catch (DefaultRenderContext.ForceInlineSignal e2) {
                ctx.data((Object)Tools.BooleanDataKey.DATA_FORCE_STATIC_STATEMENT, true);
                DefaultRenderContext render = new DefaultRenderContext(c2, ctx);
                result = new DefaultRenderContext.Rendered(((RenderContext)((RenderContext)render.paramType(ParamType.INLINED)).visit(this)).render(), null, render.skipUpdateCounts());
            }
        } else {
            DefaultRenderContext render = new DefaultRenderContext(c2, ctx);
            result = new DefaultRenderContext.Rendered(((RenderContext)((RenderContext)render.paramType(ParamType.INLINED)).visit(this)).render(), null, render.skipUpdateCounts());
        }
        return result;
    }
}

