/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.codegen;

import java.io.StringWriter;
import java.math.BigInteger;
import java.util.List;
import org.jooq.SortOrder;
import org.jooq.codegen.AbstractGenerator;
import org.jooq.codegen.Language;
import org.jooq.codegen.TextWriter;
import org.jooq.impl.QOM;
import org.jooq.meta.CatalogDefinition;
import org.jooq.meta.CheckConstraintDefinition;
import org.jooq.meta.ColumnDefinition;
import org.jooq.meta.DataTypeDefinition;
import org.jooq.meta.Database;
import org.jooq.meta.ForeignKeyDefinition;
import org.jooq.meta.IndexColumnDefinition;
import org.jooq.meta.IndexDefinition;
import org.jooq.meta.PackageDefinition;
import org.jooq.meta.ParameterDefinition;
import org.jooq.meta.PositionedDefinition;
import org.jooq.meta.RoutineDefinition;
import org.jooq.meta.SchemaDefinition;
import org.jooq.meta.SequenceDefinition;
import org.jooq.meta.TableDefinition;
import org.jooq.meta.UniqueKeyDefinition;
import org.jooq.tools.Convert;
import org.jooq.tools.JooqLogger;
import org.jooq.tools.StringUtils;
import org.jooq.util.jaxb.tools.MiniJAXB;
import org.jooq.util.jaxb.tools.XMLAppendable;
import org.jooq.util.xml.jaxb.Catalog;
import org.jooq.util.xml.jaxb.CheckConstraint;
import org.jooq.util.xml.jaxb.Column;
import org.jooq.util.xml.jaxb.Index;
import org.jooq.util.xml.jaxb.IndexColumnUsage;
import org.jooq.util.xml.jaxb.InformationSchema;
import org.jooq.util.xml.jaxb.KeyColumnUsage;
import org.jooq.util.xml.jaxb.Parameter;
import org.jooq.util.xml.jaxb.ParameterMode;
import org.jooq.util.xml.jaxb.ReferentialConstraint;
import org.jooq.util.xml.jaxb.Routine;
import org.jooq.util.xml.jaxb.RoutineType;
import org.jooq.util.xml.jaxb.Schema;
import org.jooq.util.xml.jaxb.Sequence;
import org.jooq.util.xml.jaxb.Table;
import org.jooq.util.xml.jaxb.TableConstraint;
import org.jooq.util.xml.jaxb.TableConstraintType;
import org.jooq.util.xml.jaxb.TableType;
import org.jooq.util.xml.jaxb.View;

public class XMLGenerator
extends AbstractGenerator {
    private static final JooqLogger log = JooqLogger.getLogger(XMLGenerator.class);

    public XMLGenerator() {
        super(Language.XML);
    }

    @Override
    public void generate0(Database db2) {
        this.logDatabaseParameters(db2);
        log.info("");
        this.logGenerationRemarks(db2);
        log.info("");
        log.info("----------------------------------------------------------");
        TextWriter out = new TextWriter(this.getStrategy().getFile("information_schema.xml"), this.targetEncoding);
        log.info("");
        log.info((Object)"Generating XML", out.file().getName());
        log.info("==========================================================");
        InformationSchema is2 = new InformationSchema();
        boolean hasNonDefaultCatalogs = false;
        for (CatalogDefinition c2 : db2.getCatalogs()) {
            if (StringUtils.isBlank(c2.getName())) continue;
            hasNonDefaultCatalogs = true;
            break;
        }
        for (CatalogDefinition c2 : db2.getCatalogs()) {
            String catalogName = c2.getOutputName();
            if (hasNonDefaultCatalogs) {
                is2.getCatalogs().add(new Catalog().withCatalogName(catalogName).withComment(this.generateCommentsOnCatalogs() ? c2.getComment() : null));
            }
            for (SchemaDefinition s2 : c2.getSchemata()) {
                String constraintName;
                List<PositionedDefinition> columns;
                Object column;
                Object table;
                String schemaName = s2.getOutputName();
                Schema schema = new Schema();
                schema.setCatalogName(catalogName);
                schema.setSchemaName(schemaName);
                if (this.generateCommentsOnSchemas()) {
                    schema.setComment(s2.getComment());
                }
                is2.getSchemata().add(schema);
                for (TableDefinition t2 : s2.getTables()) {
                    String tableName = t2.getOutputName();
                    table = new Table();
                    ((Table)table).setTableCatalog(catalogName);
                    ((Table)table).setTableSchema(schemaName);
                    ((Table)table).setTableName(tableName);
                    ((Table)table).setTableType(t2.isView() ? TableType.VIEW : (t2.isTemporary() ? TableType.GLOBAL_TEMPORARY : TableType.BASE_TABLE));
                    if (this.generateCommentsOnTables()) {
                        ((Table)table).setComment(t2.getComment());
                    }
                    is2.getTables().add((Table)table);
                    if (t2.isView()) {
                        View view = new View();
                        view.setTableCatalog(catalogName);
                        view.setTableSchema(schemaName);
                        view.setTableName(tableName);
                        if (this.generateSourcesOnViews()) {
                            view.setViewDefinition(t2.getSource());
                        }
                        is2.getViews().add(view);
                    }
                    for (ColumnDefinition co2 : t2.getColumns()) {
                        String columnName = co2.getOutputName();
                        DataTypeDefinition type = co2.getType();
                        column = new Column();
                        ((Column)column).setTableCatalog(catalogName);
                        ((Column)column).setTableSchema(schemaName);
                        ((Column)column).setTableName(tableName);
                        ((Column)column).setColumnName(columnName);
                        if (this.generateCommentsOnColumns()) {
                            ((Column)column).setComment(co2.getComment());
                        }
                        ((Column)column).setCharacterMaximumLength(type.getLength());
                        ((Column)column).setColumnDefault(type.getDefaultValue());
                        ((Column)column).setDataType(type.getType());
                        if (co2.isIdentity()) {
                            ((Column)column).setIdentityGeneration("YES");
                        }
                        ((Column)column).setIsNullable(type.isNullable());
                        ((Column)column).setNumericPrecision(type.getPrecision());
                        ((Column)column).setNumericScale(type.getScale());
                        ((Column)column).setOrdinalPosition(co2.getPosition());
                        ((Column)column).setReadonly(co2.isReadonly());
                        if (type.isComputed()) {
                            ((Column)column).setIsGenerated(type.isComputed());
                            ((Column)column).setGenerationExpression(type.getGeneratedAlwaysAs());
                            ((Column)column).setGenerationOption(type.getGenerationOption() == QOM.GenerationOption.VIRTUAL ? "VIRTUAL" : (type.getGenerationOption() == QOM.GenerationOption.STORED ? "STORED" : null));
                        }
                        is2.getColumns().add((Column)column);
                    }
                }
                for (IndexDefinition i2 : db2.getIndexes(s2)) {
                    String indexName = i2.getOutputName();
                    table = i2.getTable();
                    columns = i2.getIndexColumns();
                    Index index = new Index();
                    index.setIndexCatalog(catalogName);
                    index.setIndexSchema(schemaName);
                    index.setIndexName(indexName);
                    if (this.generateCommentsOnKeys()) {
                        index.setComment(i2.getComment());
                    }
                    index.setTableCatalog(table.getCatalog().getOutputName());
                    index.setTableSchema(table.getSchema().getOutputName());
                    index.setTableName(table.getOutputName());
                    index.setIsUnique(i2.isUnique());
                    is2.getIndexes().add(index);
                    for (int j2 = 0; j2 < columns.size(); ++j2) {
                        IndexColumnDefinition indexColumn = (IndexColumnDefinition)columns.get(j2);
                        column = indexColumn.getColumn();
                        IndexColumnUsage ic2 = new IndexColumnUsage();
                        ic2.setIndexCatalog(catalogName);
                        ic2.setIndexSchema(schemaName);
                        ic2.setIndexName(indexName);
                        ic2.setColumnName(column.getOutputName());
                        ic2.setOrdinalPosition(j2 + 1);
                        ic2.setIsDescending(indexColumn.getSortOrder() == SortOrder.DESC);
                        ic2.setTableCatalog(table.getCatalog().getOutputName());
                        ic2.setTableSchema(table.getSchema().getOutputName());
                        ic2.setTableName(table.getOutputName());
                        is2.getIndexColumnUsages().add(ic2);
                    }
                }
                for (UniqueKeyDefinition u2 : db2.getKeys(s2)) {
                    constraintName = u2.getOutputName();
                    table = u2.getTable();
                    columns = u2.getKeyColumns();
                    TableConstraint tc = new TableConstraint();
                    tc.setConstraintCatalog(catalogName);
                    tc.setConstraintSchema(schemaName);
                    tc.setConstraintName(constraintName);
                    tc.setConstraintType(u2.isPrimaryKey() ? TableConstraintType.PRIMARY_KEY : TableConstraintType.UNIQUE);
                    if (this.generateCommentsOnKeys()) {
                        tc.setComment(u2.getComment());
                    }
                    tc.setTableCatalog(table.getCatalog().getOutputName());
                    tc.setTableSchema(table.getSchema().getOutputName());
                    tc.setTableName(table.getOutputName());
                    tc.setEnforced(u2.enforced());
                    is2.getTableConstraints().add(tc);
                    for (int i3 = 0; i3 < columns.size(); ++i3) {
                        ColumnDefinition column2 = (ColumnDefinition)columns.get(i3);
                        KeyColumnUsage kc2 = new KeyColumnUsage();
                        kc2.setConstraintCatalog(catalogName);
                        kc2.setConstraintSchema(schemaName);
                        kc2.setConstraintName(constraintName);
                        kc2.setColumnName(column2.getOutputName());
                        kc2.setOrdinalPosition(i3 + 1);
                        kc2.setTableCatalog(table.getCatalog().getOutputName());
                        kc2.setTableSchema(table.getSchema().getOutputName());
                        kc2.setTableName(table.getOutputName());
                        is2.getKeyColumnUsages().add(kc2);
                    }
                }
                for (ForeignKeyDefinition f2 : db2.getForeignKeys(s2)) {
                    constraintName = f2.getOutputName();
                    UniqueKeyDefinition referenced = f2.getReferencedKey();
                    TableDefinition table2 = f2.getKeyTable();
                    List<ColumnDefinition> columns2 = f2.getKeyColumns();
                    TableConstraint tc = new TableConstraint();
                    tc.setConstraintCatalog(catalogName);
                    tc.setConstraintSchema(schemaName);
                    tc.setConstraintName(constraintName);
                    tc.setConstraintType(TableConstraintType.FOREIGN_KEY);
                    if (this.generateCommentsOnKeys()) {
                        tc.setComment(f2.getComment());
                    }
                    tc.setTableCatalog(table2.getCatalog().getOutputName());
                    tc.setTableSchema(table2.getSchema().getOutputName());
                    tc.setTableName(table2.getOutputName());
                    tc.setEnforced(f2.enforced());
                    ReferentialConstraint rc = new ReferentialConstraint();
                    rc.setConstraintCatalog(catalogName);
                    rc.setConstraintSchema(schemaName);
                    rc.setConstraintName(constraintName);
                    rc.setUniqueConstraintCatalog(referenced.getCatalog().getOutputName());
                    rc.setUniqueConstraintSchema(referenced.getSchema().getOutputName());
                    rc.setUniqueConstraintName(referenced.getOutputName());
                    is2.getTableConstraints().add(tc);
                    is2.getReferentialConstraints().add(rc);
                    for (int i4 = 0; i4 < columns2.size(); ++i4) {
                        ColumnDefinition column3 = columns2.get(i4);
                        KeyColumnUsage kc3 = new KeyColumnUsage();
                        kc3.setConstraintCatalog(catalogName);
                        kc3.setConstraintSchema(schemaName);
                        kc3.setConstraintName(constraintName);
                        kc3.setColumnName(column3.getOutputName());
                        kc3.setOrdinalPosition(i4 + 1);
                        kc3.setTableCatalog(table2.getCatalog().getOutputName());
                        kc3.setTableSchema(table2.getSchema().getOutputName());
                        kc3.setTableName(table2.getOutputName());
                        is2.getKeyColumnUsages().add(kc3);
                    }
                }
                for (CheckConstraintDefinition ch2 : db2.getCheckConstraints(s2)) {
                    constraintName = ch2.getOutputName();
                    table = ch2.getTable();
                    TableConstraint tc = new TableConstraint();
                    tc.setConstraintCatalog(catalogName);
                    tc.setConstraintSchema(schemaName);
                    tc.setConstraintName(constraintName);
                    tc.setConstraintType(TableConstraintType.CHECK);
                    if (this.generateCommentsOnKeys()) {
                        tc.setComment(ch2.getComment());
                    }
                    tc.setTableCatalog(table.getCatalog().getOutputName());
                    tc.setTableSchema(table.getSchema().getOutputName());
                    tc.setTableName(table.getOutputName());
                    tc.setEnforced(ch2.enforced());
                    is2.getTableConstraints().add(tc);
                    CheckConstraint cc2 = new CheckConstraint();
                    cc2.setConstraintCatalog(catalogName);
                    cc2.setConstraintSchema(schemaName);
                    cc2.setConstraintName(constraintName);
                    cc2.setCheckClause(ch2.getCheckClause());
                    is2.getCheckConstraints().add(cc2);
                }
                for (SequenceDefinition se : db2.getSequences(s2)) {
                    String sequenceName = se.getOutputName();
                    DataTypeDefinition type = se.getType();
                    Sequence sequence = new Sequence();
                    sequence.setSequenceCatalog(catalogName);
                    sequence.setSequenceSchema(schemaName);
                    sequence.setSequenceName(sequenceName);
                    if (this.generateCommentsOnSequences()) {
                        sequence.setComment(se.getComment());
                    }
                    sequence.setCharacterMaximumLength(type.getLength());
                    sequence.setDataType(type.getType());
                    sequence.setNumericPrecision(type.getPrecision());
                    sequence.setNumericScale(type.getScale());
                    sequence.setStartValue(Convert.convert((Object)se.getStartWith(), BigInteger.class));
                    sequence.setIncrement(Convert.convert((Object)se.getIncrementBy(), BigInteger.class));
                    sequence.setMinimumValue(Convert.convert((Object)se.getMinvalue(), BigInteger.class));
                    sequence.setMaximumValue(Convert.convert((Object)se.getMaxvalue(), BigInteger.class));
                    sequence.setCycleOption(se.getCycle());
                    sequence.setCache(Convert.convert((Object)se.getCache(), BigInteger.class));
                    is2.getSequences().add(sequence);
                }
                for (PackageDefinition pkg : db2.getPackages(s2)) {
                    for (RoutineDefinition r2 : pkg.getRoutines()) {
                        this.exportRoutine(is2, r2, catalogName, schemaName);
                    }
                }
                for (RoutineDefinition r3 : db2.getRoutines(s2)) {
                    this.exportRoutine(is2, r3, catalogName, schemaName);
                }
            }
        }
        StringWriter writer = new StringWriter();
        MiniJAXB.marshal((XMLAppendable)is2, writer);
        out.print(writer.toString());
        out.close();
    }

    private void exportRoutine(InformationSchema is2, RoutineDefinition r2, String catalogName, String schemaName) {
        String specificName = r2.getName() + (String)(StringUtils.isBlank(r2.getOverload()) ? "" : "_" + r2.getOverload());
        Routine routine = new Routine();
        routine.setRoutineCatalog(catalogName);
        routine.setSpecificCatalog(catalogName);
        routine.setRoutineSchema(schemaName);
        routine.setSpecificSchema(schemaName);
        if (r2.getPackage() != null) {
            routine.setRoutinePackage(r2.getPackage().getName());
            routine.setSpecificPackage(r2.getPackage().getName());
        }
        routine.setRoutineName(r2.getName());
        routine.setSpecificName(specificName);
        if (this.generateCommentsOnRoutines()) {
            routine.setComment(r2.getComment());
        }
        if (r2.getReturnValue() == null) {
            routine.setRoutineType(RoutineType.PROCEDURE);
        } else {
            routine.setRoutineType(RoutineType.FUNCTION);
            routine.setDataType(r2.getReturnType().getType());
            routine.setCharacterMaximumLength(r2.getReturnType().getLength());
            routine.setNumericPrecision(r2.getReturnType().getPrecision());
            routine.setNumericScale(r2.getReturnType().getScale());
        }
        is2.getRoutines().add(routine);
        int i2 = 1;
        for (ParameterDefinition p2 : r2.getAllParameters()) {
            if (p2 == r2.getReturnValue()) continue;
            Parameter parameter = new Parameter();
            parameter.setSpecificCatalog(catalogName);
            parameter.setSpecificSchema(schemaName);
            if (r2.getPackage() != null) {
                parameter.setSpecificPackage(r2.getPackage().getName());
            }
            parameter.setSpecificName(specificName);
            parameter.setOrdinalPosition(i2++);
            parameter.setParameterName(p2.getName());
            if (this.generateCommentsOnParameters()) {
                parameter.setComment(p2.getComment());
            }
            boolean in2 = r2.getInParameters().contains(p2);
            boolean out = r2.getOutParameters().contains(p2);
            if (in2 && out) {
                parameter.setParameterMode(ParameterMode.INOUT);
            } else if (in2) {
                parameter.setParameterMode(ParameterMode.IN);
            } else if (out) {
                parameter.setParameterMode(ParameterMode.OUT);
            }
            parameter.setDataType(p2.getType().getType());
            parameter.setCharacterMaximumLength(p2.getType().getLength());
            parameter.setNumericPrecision(p2.getType().getPrecision());
            parameter.setNumericScale(p2.getType().getScale());
            parameter.setParameterDefault(p2.getType().getDefaultValue());
            is2.getParameters().add(parameter);
        }
    }
}

