/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.jts;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.GeometryFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import org.geolatte.geom.DimensionalFlag;
import org.geolatte.geom.EmptyPointSequence;
import org.geolatte.geom.Envelope;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.GeometryCollection;
import org.geolatte.geom.LineString;
import org.geolatte.geom.LinearRing;
import org.geolatte.geom.MultiLineString;
import org.geolatte.geom.MultiPoint;
import org.geolatte.geom.MultiPolygon;
import org.geolatte.geom.Point;
import org.geolatte.geom.PointSequence;
import org.geolatte.geom.PointSequenceBuilder;
import org.geolatte.geom.PointSequenceBuilders;
import org.geolatte.geom.Polygon;
import org.geolatte.geom.crs.CrsId;
import org.geolatte.geom.jts.JTSConversionException;
import org.geolatte.geom.jts.PointSequenceCoordinateSequenceFactory;

public class JTS {
    private static final GeometryFactory jtsGeometryFactory;
    private static final Map<Class<? extends com.vividsolutions.jts.geom.Geometry>, Class<? extends Geometry>> JTS2GLClassMap;

    public static GeometryFactory geometryFactory() {
        return jtsGeometryFactory;
    }

    public static Class<? extends com.vividsolutions.jts.geom.Geometry> getCorrespondingJTSClass(Class<? extends Geometry> geometryClass) {
        if (geometryClass == null) {
            throw new IllegalArgumentException("Null argument not allowed.");
        }
        for (Map.Entry<Class<? extends com.vividsolutions.jts.geom.Geometry>, Class<? extends Geometry>> entry : JTS2GLClassMap.entrySet()) {
            if (entry.getValue() != geometryClass) continue;
            return entry.getKey();
        }
        throw new NoSuchElementException(String.format("No mapping for class %s exists in JTS geom.", geometryClass.getCanonicalName()));
    }

    public static Class<? extends Geometry> getCorrespondingGeolatteClass(Class<? extends com.vividsolutions.jts.geom.Geometry> jtsGeometryClass) {
        if (jtsGeometryClass == null) {
            throw new IllegalArgumentException("Null argument not allowed.");
        }
        Class<? extends Geometry> corresponding = JTS2GLClassMap.get(jtsGeometryClass);
        if (corresponding == null) {
            throw new NoSuchElementException(String.format("No mapping for class %s exists in JTS geom.", jtsGeometryClass.getCanonicalName()));
        }
        return corresponding;
    }

    public static Geometry from(com.vividsolutions.jts.geom.Geometry jtsGeometry) {
        if (jtsGeometry == null) {
            throw new IllegalArgumentException("Null object passed.");
        }
        return JTS.from(jtsGeometry, CrsId.valueOf(jtsGeometry.getSRID()));
    }

    public static Geometry from(com.vividsolutions.jts.geom.Geometry jtsGeometry, CrsId crsId) {
        if (jtsGeometry == null) {
            throw new IllegalArgumentException("Null object passed.");
        }
        if (jtsGeometry instanceof com.vividsolutions.jts.geom.Point) {
            return JTS.from((com.vividsolutions.jts.geom.Point)jtsGeometry, crsId);
        }
        if (jtsGeometry instanceof com.vividsolutions.jts.geom.LineString) {
            return JTS.from((com.vividsolutions.jts.geom.LineString)jtsGeometry, crsId);
        }
        if (jtsGeometry instanceof com.vividsolutions.jts.geom.Polygon) {
            return JTS.from((com.vividsolutions.jts.geom.Polygon)jtsGeometry, crsId);
        }
        if (jtsGeometry instanceof com.vividsolutions.jts.geom.MultiPoint) {
            return JTS.from((com.vividsolutions.jts.geom.MultiPoint)jtsGeometry, crsId);
        }
        if (jtsGeometry instanceof com.vividsolutions.jts.geom.MultiLineString) {
            return JTS.from((com.vividsolutions.jts.geom.MultiLineString)jtsGeometry, crsId);
        }
        if (jtsGeometry instanceof com.vividsolutions.jts.geom.MultiPolygon) {
            return JTS.from((com.vividsolutions.jts.geom.MultiPolygon)jtsGeometry, crsId);
        }
        if (jtsGeometry instanceof com.vividsolutions.jts.geom.GeometryCollection) {
            return JTS.from((com.vividsolutions.jts.geom.GeometryCollection)jtsGeometry, crsId);
        }
        throw new JTSConversionException();
    }

    public static com.vividsolutions.jts.geom.Geometry to(Geometry geometry) {
        if (geometry == null) {
            throw new IllegalArgumentException("Null object passed.");
        }
        if (geometry instanceof Point) {
            return JTS.to((Point)geometry);
        }
        if (geometry instanceof LineString) {
            return JTS.to((LineString)geometry);
        }
        if (geometry instanceof MultiPoint) {
            return JTS.to((MultiPoint)geometry);
        }
        if (geometry instanceof Polygon) {
            return JTS.to((Polygon)geometry);
        }
        if (geometry instanceof MultiLineString) {
            return JTS.to((MultiLineString)geometry);
        }
        if (geometry instanceof MultiPolygon) {
            return JTS.to((MultiPolygon)geometry);
        }
        if (geometry instanceof GeometryCollection) {
            return JTS.to((GeometryCollection)geometry);
        }
        throw new JTSConversionException();
    }

    public static Envelope from(com.vividsolutions.jts.geom.Envelope jtsEnvelope) {
        if (jtsEnvelope == null) {
            throw new IllegalArgumentException("Null object passed.");
        }
        return new Envelope(jtsEnvelope.getMinX(), jtsEnvelope.getMinY(), jtsEnvelope.getMaxX(), jtsEnvelope.getMaxY());
    }

    public static Envelope from(com.vividsolutions.jts.geom.Envelope jtsEnvelope, CrsId crsId) {
        if (jtsEnvelope == null) {
            throw new IllegalArgumentException("Null object passed.");
        }
        return new Envelope(jtsEnvelope.getMinX(), jtsEnvelope.getMinY(), jtsEnvelope.getMaxX(), jtsEnvelope.getMaxY(), crsId);
    }

    public static com.vividsolutions.jts.geom.Envelope to(Envelope env) {
        if (env == null) {
            throw new IllegalArgumentException("Null object passed.");
        }
        return new com.vividsolutions.jts.geom.Envelope(env.getMinX(), env.getMaxX(), env.getMinY(), env.getMaxY());
    }

    private static MultiPolygon from(com.vividsolutions.jts.geom.MultiPolygon jtsGeometry, CrsId crsId) {
        Polygon[] polygons = new Polygon[jtsGeometry.getNumGeometries()];
        for (int i2 = 0; i2 < jtsGeometry.getNumGeometries(); ++i2) {
            polygons[i2] = JTS.from((com.vividsolutions.jts.geom.Polygon)jtsGeometry.getGeometryN(i2), crsId);
        }
        return new MultiPolygon(polygons);
    }

    private static Polygon from(com.vividsolutions.jts.geom.Polygon jtsGeometry, CrsId crsId) {
        if (jtsGeometry.isEmpty()) {
            return Polygon.createEmpty();
        }
        LinearRing[] rings = new LinearRing[jtsGeometry.getNumInteriorRing() + 1];
        LineString extRing = JTS.from(jtsGeometry.getExteriorRing(), crsId);
        rings[0] = new LinearRing(extRing.getPoints());
        for (int i2 = 1; i2 < rings.length; ++i2) {
            LineString intRing = JTS.from(jtsGeometry.getInteriorRingN(i2 - 1), crsId);
            rings[i2] = new LinearRing(intRing.getPoints());
        }
        return new Polygon(rings);
    }

    private static MultiLineString from(com.vividsolutions.jts.geom.MultiLineString jtsGeometry, CrsId crsId) {
        LineString[] linestrings = new LineString[jtsGeometry.getNumGeometries()];
        for (int i2 = 0; i2 < linestrings.length; ++i2) {
            linestrings[i2] = JTS.from((com.vividsolutions.jts.geom.LineString)jtsGeometry.getGeometryN(i2), crsId);
        }
        return new MultiLineString(linestrings);
    }

    private static GeometryCollection from(com.vividsolutions.jts.geom.GeometryCollection jtsGeometry, CrsId crsId) {
        Geometry[] geoms = new Geometry[jtsGeometry.getNumGeometries()];
        for (int i2 = 0; i2 < jtsGeometry.getNumGeometries(); ++i2) {
            geoms[i2] = JTS.from(jtsGeometry.getGeometryN(i2), crsId);
        }
        return new GeometryCollection(geoms);
    }

    private static LineString from(com.vividsolutions.jts.geom.LineString jtsLineString, CrsId crsId) {
        CoordinateSequence cs2 = jtsLineString.getCoordinateSequence();
        return new LineString(JTS.toPointSequence(cs2, crsId));
    }

    private static MultiPoint from(com.vividsolutions.jts.geom.MultiPoint jtsMultiPoint, CrsId crsId) {
        if (jtsMultiPoint == null || jtsMultiPoint.getNumGeometries() == 0) {
            return MultiPoint.createEmpty();
        }
        Point[] points = new Point[jtsMultiPoint.getNumGeometries()];
        for (int i2 = 0; i2 < points.length; ++i2) {
            points[i2] = JTS.from((com.vividsolutions.jts.geom.Point)jtsMultiPoint.getGeometryN(i2), crsId);
        }
        return new MultiPoint(points);
    }

    private static Point from(com.vividsolutions.jts.geom.Point jtsPoint, CrsId crsId) {
        CoordinateSequence cs2 = jtsPoint.getCoordinateSequence();
        return new Point(JTS.toPointSequence(cs2, crsId));
    }

    private static com.vividsolutions.jts.geom.Polygon to(Polygon polygon) {
        com.vividsolutions.jts.geom.LinearRing shell = JTS.to(polygon.getExteriorRing());
        com.vividsolutions.jts.geom.LinearRing[] holes = new com.vividsolutions.jts.geom.LinearRing[polygon.getNumInteriorRing()];
        for (int i2 = 0; i2 < holes.length; ++i2) {
            holes[i2] = JTS.to(polygon.getInteriorRingN(i2));
        }
        com.vividsolutions.jts.geom.Polygon pg2 = JTS.geometryFactory().createPolygon(shell, holes);
        JTS.copySRID(polygon, pg2);
        return pg2;
    }

    private static com.vividsolutions.jts.geom.Point to(Point point) {
        com.vividsolutions.jts.geom.Point pnt = JTS.geometryFactory().createPoint(JTS.sequenceOf(point));
        JTS.copySRID(point, pnt);
        return pnt;
    }

    private static com.vividsolutions.jts.geom.LineString to(LineString lineString) {
        com.vividsolutions.jts.geom.LineString ls2 = JTS.geometryFactory().createLineString(JTS.sequenceOf(lineString));
        JTS.copySRID(lineString, ls2);
        return ls2;
    }

    private static com.vividsolutions.jts.geom.LinearRing to(LinearRing linearRing) {
        com.vividsolutions.jts.geom.LinearRing lr2 = JTS.geometryFactory().createLinearRing(JTS.sequenceOf(linearRing));
        JTS.copySRID(linearRing, lr2);
        return lr2;
    }

    private static com.vividsolutions.jts.geom.MultiPoint to(MultiPoint multiPoint) {
        com.vividsolutions.jts.geom.Point[] points = new com.vividsolutions.jts.geom.Point[multiPoint.getNumGeometries()];
        for (int i2 = 0; i2 < multiPoint.getNumGeometries(); ++i2) {
            points[i2] = JTS.to(multiPoint.getGeometryN(i2));
        }
        com.vividsolutions.jts.geom.MultiPoint mp2 = JTS.geometryFactory().createMultiPoint(points);
        JTS.copySRID(multiPoint, mp2);
        return mp2;
    }

    private static com.vividsolutions.jts.geom.MultiLineString to(MultiLineString multiLineString) {
        com.vividsolutions.jts.geom.LineString[] lineStrings = new com.vividsolutions.jts.geom.LineString[multiLineString.getNumGeometries()];
        for (int i2 = 0; i2 < multiLineString.getNumGeometries(); ++i2) {
            lineStrings[i2] = JTS.to(multiLineString.getGeometryN(i2));
        }
        com.vividsolutions.jts.geom.MultiLineString mls = JTS.geometryFactory().createMultiLineString(lineStrings);
        JTS.copySRID(multiLineString, mls);
        return mls;
    }

    private static com.vividsolutions.jts.geom.MultiPolygon to(MultiPolygon multiPolygon) {
        com.vividsolutions.jts.geom.Polygon[] polygons = new com.vividsolutions.jts.geom.Polygon[multiPolygon.getNumGeometries()];
        for (int i2 = 0; i2 < multiPolygon.getNumGeometries(); ++i2) {
            polygons[i2] = JTS.to(multiPolygon.getGeometryN(i2));
        }
        com.vividsolutions.jts.geom.MultiPolygon mp2 = JTS.geometryFactory().createMultiPolygon(polygons);
        JTS.copySRID(multiPolygon, mp2);
        return mp2;
    }

    private static com.vividsolutions.jts.geom.GeometryCollection to(GeometryCollection collection) {
        com.vividsolutions.jts.geom.Geometry[] geoms = new com.vividsolutions.jts.geom.Geometry[collection.getNumGeometries()];
        for (int i2 = 0; i2 < collection.getNumGeometries(); ++i2) {
            geoms[i2] = JTS.to(collection.getGeometryN(i2));
        }
        com.vividsolutions.jts.geom.GeometryCollection gc2 = JTS.geometryFactory().createGeometryCollection(geoms);
        JTS.copySRID(collection, gc2);
        return gc2;
    }

    private static void copySRID(Geometry source, com.vividsolutions.jts.geom.Geometry target) {
        int srid = source.getCrsId() == CrsId.UNDEFINED ? 0 : source.getCrsId().getCode();
        target.setSRID(srid);
    }

    private static PointSequence toPointSequence(CoordinateSequence cs2, CrsId crsId) {
        if (cs2 instanceof PointSequence && ((PointSequence)((Object)cs2)).getCrsId().equals(crsId)) {
            return (PointSequence)((Object)cs2);
        }
        if (cs2.size() == 0) {
            return EmptyPointSequence.INSTANCE;
        }
        boolean hasM = JTS.hasM(cs2.getCoordinate(0));
        boolean hasZ = JTS.hasZ(cs2.getCoordinate(0));
        DimensionalFlag df2 = DimensionalFlag.valueOf(hasZ, hasM);
        double[] coord = new double[df2.getCoordinateDimension()];
        PointSequenceBuilder builder = PointSequenceBuilders.fixedSized(cs2.size(), df2, crsId);
        for (int i2 = 0; i2 < cs2.size(); ++i2) {
            Coordinate coordinate = cs2.getCoordinate(i2);
            coord[0] = cs2.getX(i2);
            coord[1] = cs2.getY(i2);
            if (hasZ && hasM) {
                coord[2] = coordinate.getOrdinate(2);
                coord[3] = coordinate.getOrdinate(3);
            } else if (hasZ) {
                coord[2] = coordinate.getOrdinate(2);
            } else if (hasM) {
                coord[2] = coordinate.getOrdinate(3);
            }
            builder.add(coord);
        }
        return builder.toPointSequence();
    }

    private static boolean hasM(Coordinate coordinate) {
        try {
            return !Double.isNaN(coordinate.getOrdinate(3));
        }
        catch (IllegalArgumentException e2) {
            return false;
        }
    }

    private static boolean hasZ(Coordinate coordinate) {
        return !Double.isNaN(coordinate.z);
    }

    private static CoordinateSequence sequenceOf(Geometry geometry) {
        if (geometry == null) {
            throw new JTSConversionException("Can't convert null geometries.");
        }
        return (CoordinateSequence)((Object)geometry.getPoints());
    }

    static {
        JTS2GLClassMap = new HashMap<Class<? extends com.vividsolutions.jts.geom.Geometry>, Class<? extends Geometry>>();
        jtsGeometryFactory = new GeometryFactory(new PointSequenceCoordinateSequenceFactory());
        JTS2GLClassMap.put(com.vividsolutions.jts.geom.Point.class, Point.class);
        JTS2GLClassMap.put(com.vividsolutions.jts.geom.LineString.class, LineString.class);
        JTS2GLClassMap.put(com.vividsolutions.jts.geom.LinearRing.class, LinearRing.class);
        JTS2GLClassMap.put(com.vividsolutions.jts.geom.Polygon.class, Polygon.class);
        JTS2GLClassMap.put(com.vividsolutions.jts.geom.GeometryCollection.class, GeometryCollection.class);
        JTS2GLClassMap.put(com.vividsolutions.jts.geom.MultiPoint.class, MultiPoint.class);
        JTS2GLClassMap.put(com.vividsolutions.jts.geom.MultiLineString.class, MultiLineString.class);
        JTS2GLClassMap.put(com.vividsolutions.jts.geom.MultiPolygon.class, MultiPolygon.class);
    }
}

