/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.crs;

import java.util.Arrays;
import org.geolatte.geom.crs.CoordinateSystemAxis;
import org.geolatte.geom.crs.Unit;

public class CoordinateSystem {
    private final CoordinateSystemAxis[] axes;

    public CoordinateSystem(CoordinateSystemAxis ... axes) {
        if (axes == null || axes.length < 2) {
            throw new IllegalArgumentException("Requires at least 2 axes");
        }
        this.axes = axes;
    }

    public CoordinateSystemAxis[] getAxes() {
        return Arrays.copyOf(this.axes, this.axes.length);
    }

    public int getCoordinateDimension() {
        return this.axes.length;
    }

    public int getAxisIndex(CoordinateSystemAxis axis) {
        int i2 = 0;
        for (CoordinateSystemAxis a2 : this.axes) {
            if (a2 == axis) {
                return i2;
            }
            ++i2;
        }
        return -1;
    }

    public CoordinateSystemAxis getAxis(int index) {
        return this.axes[index];
    }

    public Unit getAxisUnit(int index) {
        return this.axes[index].getUnit();
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        CoordinateSystem that = (CoordinateSystem)o2;
        return Arrays.equals(this.axes, that.axes);
    }

    public int hashCode() {
        return Arrays.hashCode(this.axes);
    }
}

