/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.codec.sqlserver;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.geolatte.geom.DimensionalFlag;
import org.geolatte.geom.PointCollection;
import org.geolatte.geom.PointSequence;
import org.geolatte.geom.PointSequenceBuilder;
import org.geolatte.geom.PointSequenceBuilders;
import org.geolatte.geom.codec.sqlserver.Figure;
import org.geolatte.geom.codec.sqlserver.FigureAttribute;
import org.geolatte.geom.codec.sqlserver.IndexRange;
import org.geolatte.geom.codec.sqlserver.OpenGisType;
import org.geolatte.geom.codec.sqlserver.Shape;
import org.geolatte.geom.crs.CrsId;

public class SqlServerGeometry {
    public static final byte SUPPORTED_VERSION = 1;
    private static final byte hasZValuesMask = 1;
    private static final byte hasMValuesMask = 2;
    private static final byte isValidMask = 4;
    private static final byte isSinglePointMask = 8;
    private static final byte isSingleLineSegment = 16;
    private ByteBuffer buffer;
    private Integer srid;
    private byte version;
    private byte serializationPropertiesByte;
    private int numberOfPoints;
    private double[] points;
    private double[] mValues;
    private double[] zValues;
    private int numberOfFigures;
    private Figure[] figures = null;
    private int numberOfShapes;
    private Shape[] shapes = null;

    private SqlServerGeometry(byte[] bytes) {
        this.buffer = ByteBuffer.wrap(bytes);
        this.buffer.order(ByteOrder.LITTLE_ENDIAN);
    }

    SqlServerGeometry() {
    }

    public static byte[] serialize(SqlServerGeometry sqlServerGeom) {
        int i2;
        int capacity = sqlServerGeom.calculateCapacity();
        ByteBuffer buffer = ByteBuffer.allocate(capacity);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        buffer.putInt(sqlServerGeom.srid);
        buffer.put((byte)1);
        buffer.put(sqlServerGeom.serializationPropertiesByte);
        if (!sqlServerGeom.isSinglePoint() && !sqlServerGeom.isSingleLineSegment()) {
            buffer.putInt(sqlServerGeom.numberOfPoints);
        }
        for (i2 = 0; i2 < sqlServerGeom.getNumPoints(); ++i2) {
            buffer.putDouble(sqlServerGeom.points[2 * i2]);
            buffer.putDouble(sqlServerGeom.points[2 * i2 + 1]);
        }
        if (sqlServerGeom.hasZValues()) {
            for (i2 = 0; i2 < sqlServerGeom.zValues.length; ++i2) {
                buffer.putDouble(sqlServerGeom.zValues[i2]);
            }
        }
        if (sqlServerGeom.hasMValues()) {
            for (i2 = 0; i2 < sqlServerGeom.mValues.length; ++i2) {
                buffer.putDouble(sqlServerGeom.mValues[i2]);
            }
        }
        if (sqlServerGeom.isSingleLineSegment() || sqlServerGeom.isSinglePoint()) {
            return buffer.array();
        }
        buffer.putInt(sqlServerGeom.getNumFigures());
        for (i2 = 0; i2 < sqlServerGeom.getNumFigures(); ++i2) {
            sqlServerGeom.getFigure(i2).store(buffer);
        }
        buffer.putInt(sqlServerGeom.getNumShapes());
        for (i2 = 0; i2 < sqlServerGeom.getNumShapes(); ++i2) {
            sqlServerGeom.getShape(i2).store(buffer);
        }
        return buffer.array();
    }

    public static SqlServerGeometry deserialize(byte[] bytes) {
        SqlServerGeometry result = new SqlServerGeometry(bytes);
        result.parse();
        return result;
    }

    void copyCoordinate(int index, double[] coords, DimensionalFlag df2) {
        coords[0] = this.points[2 * index];
        coords[1] = this.points[2 * index + 1];
        if (this.hasZValues()) {
            assert (df2.is3D());
            coords[df2.Z] = this.zValues[index];
        }
        if (this.hasMValues()) {
            assert (df2.isMeasured());
            coords[df2.M] = this.mValues[index];
        }
    }

    boolean isParentShapeOf(int parent, int child) {
        return this.getShape((int)child).parentOffset == parent;
    }

    boolean isEmptyShape(int shapeIndex) {
        return this.getShape((int)shapeIndex).figureOffset == -1;
    }

    IndexRange getFiguresForShape(int shapeIndex) {
        int startIdx = this.getShape((int)shapeIndex).figureOffset;
        if (startIdx == -1) {
            return new IndexRange(-1, -1);
        }
        int endIdx = -1;
        int nextShapeIdx = shapeIndex + 1;
        endIdx = nextShapeIdx == this.getNumShapes() ? this.getNumFigures() : this.getShape((int)nextShapeIdx).figureOffset;
        return new IndexRange(startIdx, endIdx);
    }

    IndexRange getPointsForFigure(int figureIndex) {
        int start = this.getFigure((int)figureIndex).pointOffset;
        int end = -1;
        int nextFigure = figureIndex + 1;
        end = nextFigure == this.getNumFigures() ? this.getNumPoints() : this.getFigure((int)nextFigure).pointOffset;
        return new IndexRange(start, end);
    }

    boolean isFigureInteriorRing(int figureIdx) {
        return this.getFigure(figureIdx).isInteriorRing();
    }

    OpenGisType getOpenGisTypeOfShape(int shpIdx) {
        return this.getShape((int)shpIdx).openGisType;
    }

    PointSequence coordinateRange(IndexRange range) {
        DimensionalFlag df2 = DimensionalFlag.valueOf(this.hasZValues(), this.hasMValues());
        PointSequenceBuilder psBuilder = PointSequenceBuilders.fixedSized(range.end - range.start, df2, CrsId.valueOf(this.getSrid()));
        double[] coordinates = new double[df2.getCoordinateDimension()];
        int idx = range.start;
        int i2 = 0;
        while (idx < range.end) {
            this.copyCoordinate(idx, coordinates, df2);
            psBuilder.add(coordinates);
            ++idx;
            ++i2;
        }
        return psBuilder.toPointSequence();
    }

    private Figure getFigure(int index) {
        return this.figures[index];
    }

    private Shape getShape(int index) {
        return this.shapes[index];
    }

    void setCoordinate(int index, PointCollection coordinate) {
        this.points[2 * index] = coordinate.getX(index);
        this.points[2 * index + 1] = coordinate.getY(index);
        if (this.hasZValues()) {
            this.zValues[index] = coordinate.getZ(index);
        }
        if (this.hasMValues()) {
            this.mValues[index] = coordinate.getM(index);
        }
    }

    boolean isEmpty() {
        return this.numberOfPoints == 0;
    }

    OpenGisType openGisType() {
        if (this.isValid() && this.isSinglePoint()) {
            return OpenGisType.POINT;
        }
        if (this.isValid() && this.isSingleLineSegment()) {
            return OpenGisType.LINESTRING;
        }
        return this.firstShapeOpenGisType();
    }

    void setHasZValues() {
        this.serializationPropertiesByte = (byte)(this.serializationPropertiesByte | 1);
    }

    void allocateZValueArray() {
        if (this.hasZValues()) {
            this.zValues = new double[this.numberOfPoints];
        }
    }

    void allocateMValueArray() {
        if (this.hasMValues()) {
            this.mValues = new double[this.numberOfPoints];
        }
    }

    void setHasMValues() {
        this.serializationPropertiesByte = (byte)(this.serializationPropertiesByte | 2);
    }

    void setIsValid() {
        this.serializationPropertiesByte = (byte)(this.serializationPropertiesByte | 4);
    }

    void setIsSinglePoint() {
        this.setNumberOfPoints(1);
        this.serializationPropertiesByte = (byte)(this.serializationPropertiesByte | 8);
    }

    void setIsSingleLineSegment() {
        this.serializationPropertiesByte = (byte)(this.serializationPropertiesByte | 0x10);
    }

    int getNumPoints() {
        return this.numberOfPoints;
    }

    void setNumberOfPoints(int num) {
        this.numberOfPoints = num;
        this.points = new double[2 * this.numberOfPoints];
    }

    private void parse() {
        this.srid = this.buffer.getInt();
        this.version = this.buffer.get();
        if (!this.isCompatible()) {
            throw new IllegalStateException("Version mismatch. Expected version 1, but received version " + this.version);
        }
        this.serializationPropertiesByte = this.buffer.get();
        this.determineNumberOfPoints();
        this.readPoints();
        if (this.hasZValues()) {
            this.readZValues();
        }
        if (this.hasMValues()) {
            this.readMValues();
        }
        if (this.isSingleLineSegment() || this.isSinglePoint()) {
            this.setNumberOfFigures(1);
            this.setFigure(0, new Figure(FigureAttribute.Stroke, 0));
            this.setNumberOfShapes(1);
            OpenGisType gisType = this.isSinglePoint() ? OpenGisType.POINT : OpenGisType.LINESTRING;
            this.setShape(0, new Shape(-1, 0, gisType));
            return;
        }
        this.readFigures();
        this.readShapes();
    }

    private void readShapes() {
        this.setNumberOfShapes(this.buffer.getInt());
        for (int sIdx = 0; sIdx < this.numberOfShapes; ++sIdx) {
            int parentOffset = this.buffer.getInt();
            int figureOffset = this.buffer.getInt();
            byte ogtByte = this.buffer.get();
            OpenGisType type = OpenGisType.valueOf(ogtByte);
            Shape shape = new Shape(parentOffset, figureOffset, type);
            this.setShape(sIdx, shape);
        }
    }

    private void readFigures() {
        this.setNumberOfFigures(this.buffer.getInt());
        for (int fIdx = 0; fIdx < this.numberOfFigures; ++fIdx) {
            byte faByte = this.buffer.get();
            int pointOffset = this.buffer.getInt();
            FigureAttribute fa2 = FigureAttribute.valueOf(faByte);
            Figure figure = new Figure(fa2, pointOffset);
            this.setFigure(fIdx, figure);
        }
    }

    private OpenGisType firstShapeOpenGisType() {
        if (this.shapes == null || this.shapes.length == 0) {
            return OpenGisType.INVALID_TYPE;
        }
        return this.shapes[0].openGisType;
    }

    private int calculateCapacity() {
        int numPoints = this.getNumPoints();
        int prefixSize = 6;
        if (this.isSinglePoint() || this.isSingleLineSegment()) {
            int capacity = prefixSize + 16 * numPoints;
            if (this.hasZValues()) {
                capacity += 8 * numPoints;
            }
            if (this.hasMValues()) {
                capacity += 8 * numPoints;
            }
            return capacity;
        }
        int pointSize = this.getPointByteSize();
        int size = prefixSize + 12;
        size += this.getNumPoints() * pointSize;
        size += this.getNumFigures() * Figure.getByteSize();
        return size += this.getNumShapes() * Shape.getByteSize();
    }

    int getNumShapes() {
        return this.numberOfShapes;
    }

    private int getPointByteSize() {
        int size = 16;
        if (this.hasMValues()) {
            size += 8;
        }
        if (this.hasZValues()) {
            size += 8;
        }
        return size;
    }

    private void readPoints() {
        this.points = new double[2 * this.numberOfPoints];
        for (int i2 = 0; i2 < this.numberOfPoints; ++i2) {
            this.points[2 * i2] = this.buffer.getDouble();
            this.points[2 * i2 + 1] = this.buffer.getDouble();
        }
    }

    private void readZValues() {
        this.zValues = new double[this.numberOfPoints];
        for (int i2 = 0; i2 < this.numberOfPoints; ++i2) {
            this.zValues[i2] = this.buffer.getDouble();
        }
    }

    private void readMValues() {
        this.mValues = new double[this.numberOfPoints];
        for (int i2 = 0; i2 < this.numberOfPoints; ++i2) {
            this.mValues[i2] = this.buffer.getDouble();
        }
    }

    private void determineNumberOfPoints() {
        if (this.isSinglePoint()) {
            this.numberOfPoints = 1;
            return;
        }
        if (this.isSingleLineSegment()) {
            this.numberOfPoints = 2;
            return;
        }
        this.numberOfPoints = this.buffer.getInt();
    }

    boolean isCompatible() {
        return this.version == 1;
    }

    void setSrid(Integer srid) {
        this.srid = srid == null ? -1 : srid;
    }

    Integer getSrid() {
        return this.srid != -1 ? this.srid : null;
    }

    boolean hasZValues() {
        return (this.serializationPropertiesByte & 1) != 0;
    }

    boolean hasMValues() {
        return (this.serializationPropertiesByte & 2) != 0;
    }

    boolean isValid() {
        return (this.serializationPropertiesByte & 4) != 0;
    }

    boolean isSinglePoint() {
        return (this.serializationPropertiesByte & 8) != 0;
    }

    boolean isSingleLineSegment() {
        return (this.serializationPropertiesByte & 0x10) != 0;
    }

    void setNumberOfFigures(int num) {
        this.numberOfFigures = num;
        this.figures = new Figure[this.numberOfFigures];
    }

    void setFigure(int i2, Figure figure) {
        this.figures[i2] = figure;
    }

    void setNumberOfShapes(int num) {
        this.numberOfShapes = num;
        this.shapes = new Shape[this.numberOfShapes];
    }

    void setShape(int i2, Shape shape) {
        this.shapes[i2] = shape;
    }

    int getNumFigures() {
        return this.numberOfFigures;
    }
}

