/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.codec;

import org.geolatte.geom.DimensionalFlag;
import org.geolatte.geom.PointSequenceBuilder;
import org.geolatte.geom.PointSequenceBuilders;
import org.geolatte.geom.codec.AbstractWktTokenizer;
import org.geolatte.geom.codec.WktDecodeException;
import org.geolatte.geom.codec.WktDimensionMarkerToken;
import org.geolatte.geom.codec.WktGeometryToken;
import org.geolatte.geom.codec.WktKeywordToken;
import org.geolatte.geom.codec.WktPointSequenceToken;
import org.geolatte.geom.codec.WktToken;
import org.geolatte.geom.codec.WktVariant;
import org.geolatte.geom.crs.CrsId;

class WktTokenizer
extends AbstractWktTokenizer {
    private boolean isMeasured = false;
    private final CrsId crsId;
    private static long S_MAX = 0x1FFFFFFFFFFFFFL;
    private static long P_MAX = 22L;

    protected WktTokenizer(CharSequence wkt, WktVariant variant, CrsId crsId) {
        super(wkt, variant);
        if (wkt == null || variant == null) {
            throw new IllegalArgumentException("Input WKT and variant must not be null");
        }
        this.crsId = crsId == null ? CrsId.UNDEFINED : crsId;
    }

    @Override
    WktToken numericToken() {
        DimensionalFlag dimensionalFlag = this.countDimension();
        int numPoints = this.countPoints();
        double[] coords = new double[dimensionalFlag.getCoordinateDimension()];
        PointSequenceBuilder psBuilder = PointSequenceBuilders.fixedSized(numPoints, dimensionalFlag, this.crsId);
        for (int i2 = 0; i2 < numPoints; ++i2) {
            this.readPoint(coords);
            psBuilder.add(coords);
            this.skipPointDelimiter();
        }
        return new WktPointSequenceToken(psBuilder.toPointSequence());
    }

    private void readPoint(double[] coords) {
        for (int i2 = 0; i2 < coords.length; ++i2) {
            coords[i2] = this.fastReadNumber();
        }
    }

    protected double fastReadNumber() {
        this.skipWhitespace();
        int startPos = this.currentPos;
        char c2 = this.wkt.charAt(this.currentPos);
        double sign = 1.0;
        if (c2 == '-') {
            sign = -1.0;
            c2 = this.wkt.charAt(++this.currentPos);
        }
        long s2 = 0L;
        boolean decPntSeen = false;
        long decPos = -1L;
        while (true) {
            if (Character.isDigit(c2)) {
                s2 = 10L * s2 + (long)(c2 - 48);
            } else {
                if (c2 != '.') break;
                if (decPntSeen) {
                    throw new WktDecodeException("Invalid number format at position " + this.currentPos);
                }
                decPntSeen = true;
            }
            if (decPntSeen) {
                ++decPos;
            }
            c2 = this.wkt.charAt(++this.currentPos);
        }
        long exp = 0L;
        long expSign = 1L;
        if (c2 == 'e' || c2 == 'E') {
            if ((c2 = this.wkt.charAt(++this.currentPos)) == '-') {
                expSign = -1L;
                c2 = this.wkt.charAt(++this.currentPos);
            }
            while (Character.isDigit(c2)) {
                exp = 10L * exp + (long)(c2 - 48);
                c2 = this.wkt.charAt(++this.currentPos);
            }
        }
        long p2 = decPos >= 0L ? expSign * exp - decPos : expSign * exp;
        int endPos = this.currentPos;
        return this.toDouble(sign, s2, p2, startPos, endPos);
    }

    private int countPoints() {
        int pos = this.currentPos + 1;
        char c2 = this.wkt.charAt(pos);
        int num = 1;
        while (c2 != ')') {
            if (c2 == ',') {
                ++num;
            }
            c2 = this.wkt.charAt(++pos);
        }
        return num;
    }

    private DimensionalFlag countDimension() {
        int pos = this.currentPos;
        int num = 1;
        boolean inNumber = true;
        char c2 = this.wkt.charAt(pos);
        while (c2 != ',' && c2 != this.variant.getCloseListChar()) {
            if (!Character.isDigit(c2) && c2 != '.' && c2 != '-' && c2 != 'e' && c2 != 'E') {
                inNumber = false;
            } else if (!inNumber) {
                ++num;
                inNumber = true;
            }
            if (pos == this.wkt.length() - 1) {
                throw new WktDecodeException("");
            }
            c2 = this.wkt.charAt(++pos);
        }
        if (num == 4) {
            return DimensionalFlag.d3DM;
        }
        if (num == 3 && this.isMeasured) {
            return DimensionalFlag.d2DM;
        }
        if (num == 3 && !this.isMeasured) {
            return DimensionalFlag.d3D;
        }
        if (num == 2) {
            return DimensionalFlag.d2D;
        }
        throw new WktDecodeException("Point with less than 2 coordinates at position " + this.currentPos);
    }

    private void skipPointDelimiter() {
        this.skipWhitespace();
        if (this.wkt.charAt(this.currentPos) == ',') {
            ++this.currentPos;
        }
    }

    @Override
    protected WktToken matchKeyword(int currentPos, int endPos) {
        WktKeywordToken token = this.variant.matchKeyword(this.wkt, currentPos, endPos);
        if (token instanceof WktGeometryToken) {
            boolean bl2 = this.isMeasured = this.isMeasured || ((WktGeometryToken)token).isMeasured();
        }
        if (token instanceof WktDimensionMarkerToken) {
            this.isMeasured = this.isMeasured || ((WktDimensionMarkerToken)token).isMeasured();
        }
        return token;
    }

    protected double toDouble(double sign, long s2, long p2, int startPos, int endPos) {
        if (s2 == 0L) {
            return 0.0;
        }
        if (s2 > 0L && s2 <= S_MAX && Math.abs(p2) <= P_MAX) {
            if (p2 == 0L) {
                return sign * (double)s2;
            }
            if (p2 < 0L) {
                return sign * ((double)s2 / Math.pow(10.0, -p2));
            }
            return sign * ((double)s2 * Math.pow(10.0, p2));
        }
        return Double.parseDouble(this.wkt.subSequence(startPos, endPos).toString());
    }
}

