/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.codec;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.GeometryType;
import org.geolatte.geom.codec.WktEmptyGeometryToken;
import org.geolatte.geom.codec.WktGeometryToken;
import org.geolatte.geom.codec.WktKeywordToken;
import org.geolatte.geom.codec.WktVariant;

class PostgisWktVariant
extends WktVariant {
    private static final WktEmptyGeometryToken EMPTY = new WktEmptyGeometryToken();
    private static final List<WktGeometryToken> GEOMETRIES = new ArrayList<WktGeometryToken>();
    private static final Set<WktKeywordToken> KEYWORDS;

    protected PostgisWktVariant() {
        super('(', ')', ',');
    }

    private static void add(GeometryType type, boolean isMeasured, String word) {
        GEOMETRIES.add(new WktGeometryToken(word, type, isMeasured));
    }

    public String wordFor(Geometry geometry, boolean ignoreMeasureMarker) {
        for (WktGeometryToken candidate : GEOMETRIES) {
            if (!this.sameGeometryType(candidate, geometry) || !this.hasSameMeasuredSuffixInWkt(candidate, geometry, ignoreMeasureMarker)) continue;
            return candidate.getPattern().toString();
        }
        throw new IllegalStateException(String.format("Geometry type %s not recognized.", geometry.getClass().getName()));
    }

    @Override
    protected Set<WktKeywordToken> getWktKeywords() {
        return KEYWORDS;
    }

    public WktKeywordToken getEmpty() {
        return EMPTY;
    }

    private boolean sameGeometryType(WktGeometryToken token, Geometry geometry) {
        return token.getType() == geometry.getGeometryType();
    }

    private boolean hasSameMeasuredSuffixInWkt(WktGeometryToken candidate, Geometry geometry, boolean ignoreMeasureMarker) {
        if (ignoreMeasureMarker) {
            return !candidate.isMeasured();
        }
        if (geometry.isMeasured() && !geometry.is3D()) {
            return candidate.isMeasured();
        }
        return !candidate.isMeasured();
    }

    static {
        PostgisWktVariant.add(GeometryType.POINT, false, "POINT");
        PostgisWktVariant.add(GeometryType.POINT, true, "POINTM");
        PostgisWktVariant.add(GeometryType.LINE_STRING, true, "LINESTRINGM");
        PostgisWktVariant.add(GeometryType.LINE_STRING, false, "LINESTRING");
        PostgisWktVariant.add(GeometryType.POLYGON, false, "POLYGON");
        PostgisWktVariant.add(GeometryType.POLYGON, true, "POLYGONM");
        PostgisWktVariant.add(GeometryType.MULTI_POINT, true, "MULTIPOINTM");
        PostgisWktVariant.add(GeometryType.MULTI_POINT, false, "MULTIPOINT");
        PostgisWktVariant.add(GeometryType.MULTI_LINE_STRING, false, "MULTILINESTRING");
        PostgisWktVariant.add(GeometryType.MULTI_LINE_STRING, true, "MULTILINESTRINGM");
        PostgisWktVariant.add(GeometryType.MULTI_POLYGON, false, "MULTIPOLYGON");
        PostgisWktVariant.add(GeometryType.MULTI_POLYGON, true, "MULTIPOLYGONM");
        PostgisWktVariant.add(GeometryType.GEOMETRY_COLLECTION, false, "GEOMETRYCOLLECTION");
        PostgisWktVariant.add(GeometryType.GEOMETRY_COLLECTION, true, "GEOMETRYCOLLECTIONM");
        HashSet<WktKeywordToken> allTokens = new HashSet<WktKeywordToken>();
        allTokens.addAll(GEOMETRIES);
        allTokens.add(EMPTY);
        KEYWORDS = Collections.unmodifiableSet(allTokens);
    }
}

