/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.codec;

import org.geolatte.geom.ByteBuffer;
import org.geolatte.geom.ByteOrder;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.GeometryCollection;
import org.geolatte.geom.codec.AbstractWkbEncoder;
import org.geolatte.geom.crs.CrsId;

class MySqlWkbEncoder
extends AbstractWkbEncoder {
    MySqlWkbEncoder() {
    }

    @Override
    public ByteBuffer encode(Geometry geometry, ByteOrder byteOrder) {
        if (geometry == null || this.hasEmpty(geometry)) {
            return null;
        }
        ByteBuffer output = ByteBuffer.allocate(this.calculateSize(geometry, false) + 4);
        if (byteOrder != null) {
            output.setByteOrder(byteOrder);
        }
        output.putInt(geometry.getCrsId() == CrsId.UNDEFINED ? 0 : geometry.getSRID());
        this.writeGeometry(geometry, output);
        output.rewind();
        return output;
    }

    @Override
    protected int sizeEmptyGeometry(Geometry geometry) {
        return 0;
    }

    private boolean hasEmpty(Geometry geometry) {
        if (geometry.isEmpty()) {
            return true;
        }
        if (geometry instanceof GeometryCollection) {
            for (Geometry part : (GeometryCollection)geometry) {
                if (!this.hasEmpty(part)) continue;
                return true;
            }
        }
        return false;
    }
}

