/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.builder;

import org.geolatte.geom.DimensionalFlag;
import org.geolatte.geom.LineString;
import org.geolatte.geom.PointSequenceBuilder;
import org.geolatte.geom.PointSequenceBuilders;
import org.geolatte.geom.builder.internal.GeometryBuilder2D;
import org.geolatte.geom.builder.internal.GeometryBuilder2DM;
import org.geolatte.geom.builder.internal.GeometryBuilder3D;
import org.geolatte.geom.builder.internal.GeometryBuilder3DM;
import org.geolatte.geom.builder.internal.SimpleGeometryBuilder;
import org.geolatte.geom.crs.CrsId;

public class LineStrings {
    public static GeometryBuilder2D<LineString> create2D(CrsId crsId) {
        return new LineStringBuilder2D(crsId);
    }

    public static GeometryBuilder2DM<LineString> create2DM(CrsId crsId) {
        return new LineStringBuilder2DM(crsId);
    }

    public static GeometryBuilder3D<LineString> create3D(CrsId crsId) {
        return new LineStringBuilder3D(crsId);
    }

    public static GeometryBuilder3DM<LineString> create3DM(CrsId crsId) {
        return new LineStringBuilder3DM(crsId);
    }

    private static class LineStringBuilder3DM
    extends Builder
    implements GeometryBuilder3DM<LineString> {
        LineStringBuilder3DM(CrsId crsId) {
            super(DimensionalFlag.d3DM, crsId);
        }

        public LineStringBuilder3DM add(double x2, double y2, double z2, double m3) {
            this.pointSequenceBuilder.add(x2, y2, z2, m3);
            return this;
        }
    }

    private static class LineStringBuilder3D
    extends Builder
    implements GeometryBuilder3D<LineString> {
        LineStringBuilder3D(CrsId crsId) {
            super(DimensionalFlag.d3D, crsId);
        }

        public LineStringBuilder3D add(double x2, double y2, double z2) {
            this.pointSequenceBuilder.add(x2, y2, z2);
            return this;
        }
    }

    private static class LineStringBuilder2DM
    extends Builder
    implements GeometryBuilder2DM<LineString> {
        LineStringBuilder2DM(CrsId crsId) {
            super(DimensionalFlag.d2DM, crsId);
        }

        public LineStringBuilder2DM add(double x2, double y2, double m3) {
            this.pointSequenceBuilder.add(x2, y2, m3);
            return this;
        }
    }

    private static class LineStringBuilder2D
    extends Builder
    implements GeometryBuilder2D<LineString> {
        LineStringBuilder2D(CrsId crsId) {
            super(DimensionalFlag.d2D, crsId);
        }

        public LineStringBuilder2D add(double x2, double y2) {
            this.pointSequenceBuilder.add(x2, y2);
            return this;
        }
    }

    private static abstract class Builder
    implements SimpleGeometryBuilder<LineString> {
        protected PointSequenceBuilder pointSequenceBuilder;

        Builder(DimensionalFlag dimFlag, CrsId crsId) {
            this.pointSequenceBuilder = PointSequenceBuilders.variableSized(dimFlag, crsId);
        }

        @Override
        public LineString build() {
            return new LineString(this.pointSequenceBuilder.toPointSequence());
        }
    }
}

