/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom;

import java.util.ArrayList;
import java.util.List;
import org.geolatte.geom.DimensionalFlag;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.GeometryCollection;
import org.geolatte.geom.GeometryOperations;
import org.geolatte.geom.GeometryVisitor;
import org.geolatte.geom.LineSegment;
import org.geolatte.geom.LineSegments;
import org.geolatte.geom.LineString;
import org.geolatte.geom.LinearRing;
import org.geolatte.geom.MultiLineString;
import org.geolatte.geom.MultiPoint;
import org.geolatte.geom.Point;
import org.geolatte.geom.PointSequence;
import org.geolatte.geom.PointSequenceBuilder;
import org.geolatte.geom.PointSequenceBuilders;
import org.geolatte.geom.Points;
import org.geolatte.geom.PolyHedralSurface;
import org.geolatte.geom.Polygon;
import org.geolatte.geom.crs.CrsId;

public class MeasureInterpolatingVisitor
implements GeometryVisitor {
    private static final String INVALID_TYPE_MSG = "Operation only valid on Point, MultiPoint, LineString, and MultiLineString Geometries.";
    private final double startMeasure;
    private final double endMeasure;
    private final CrsId crsId;
    private final GeometryOperations ops;
    private final DimensionalFlag dimFlag;
    private final List<PointSequence> pointSequences = new ArrayList<PointSequence>();
    private PointSequenceBuilder currentBuilder;

    public MeasureInterpolatingVisitor(Geometry geometry, double startMeasure, double endMeasure) {
        if (startMeasure <= endMeasure) {
            this.startMeasure = startMeasure;
            this.endMeasure = endMeasure;
        } else {
            this.startMeasure = endMeasure;
            this.endMeasure = startMeasure;
        }
        this.crsId = geometry.getCrsId();
        this.ops = geometry.getGeometryOperations();
        this.dimFlag = DimensionalFlag.valueOf(geometry.is3D(), geometry.isMeasured());
    }

    @Override
    public void visit(Point point) {
        if (point.getM() >= this.startMeasure && point.getM() <= this.endMeasure) {
            this.pointSequences.add(point.getPoints());
        }
    }

    @Override
    public void visit(LineString lineString) {
        this.currentBuilder = PointSequenceBuilders.variableSized(this.dimFlag, this.crsId);
        Point lastAddedPoint = null;
        LineSegments segments = new LineSegments(lineString.getPoints());
        for (LineSegment segment : segments) {
            Point p0 = segment.getStartPoint();
            Point p1 = segment.getEndPoint();
            double rs = (this.startMeasure - p0.getM()) / (p1.getM() - p0.getM());
            double re = (this.endMeasure - p0.getM()) / (p1.getM() - p0.getM());
            double r1 = Math.min(rs, re);
            double r2 = Math.max(rs, re);
            if (this.startMeasure <= p0.getM() && p0.getM() <= this.endMeasure) {
                lastAddedPoint = this.addIfNotEqualLast(lastAddedPoint, p0);
            } else {
                this.startNewPointSequenceIfNotEmpty();
                if (r1 > 0.0 && r1 < 1.0) {
                    lastAddedPoint = this.addIfNotEqualLast(lastAddedPoint, this.interpolate(p0, p1, r1));
                }
            }
            if (this.startMeasure <= p1.getM() && p1.getM() <= this.endMeasure) {
                lastAddedPoint = this.addIfNotEqualLast(lastAddedPoint, p1);
                continue;
            }
            if (r2 > 0.0 && r2 < 1.0) {
                lastAddedPoint = this.addIfNotEqualLast(lastAddedPoint, this.interpolate(p0, p1, r2));
            }
            this.startNewPointSequenceIfNotEmpty();
        }
        PointSequence last = this.currentBuilder.toPointSequence();
        if (!last.isEmpty()) {
            this.pointSequences.add(last);
        }
    }

    private void startNewPointSequenceIfNotEmpty() {
        if (this.currentBuilder.getNumAdded() > 0) {
            this.pointSequences.add(this.currentBuilder.toPointSequence());
            this.currentBuilder = PointSequenceBuilders.variableSized(this.dimFlag, this.crsId);
        }
    }

    private Point addIfNotEqualLast(Point lastPoint, Point newPnt) {
        assert (newPnt != null);
        if (!newPnt.equals(lastPoint)) {
            this.currentBuilder.add(newPnt);
            lastPoint = newPnt;
        }
        return lastPoint;
    }

    private Point interpolate(Point p0, Point p1, double r2) {
        double x2 = p0.getX() + r2 * (p1.getX() - p0.getX());
        double y2 = p0.getY() + r2 * (p1.getY() - p0.getY());
        double m3 = p0.getM() + r2 * (p1.getM() - p0.getM());
        if (p0.is3D()) {
            double z2 = p0.getZ() + r2 * (p1.getZ() - p0.getZ());
            return Points.create3DM(x2, y2, z2, m3);
        }
        return Points.create2DM(x2, y2, m3);
    }

    @Override
    public void visit(Polygon polygon) {
        throw new IllegalArgumentException(INVALID_TYPE_MSG);
    }

    @Override
    public void visit(GeometryCollection collection) {
    }

    @Override
    public void visit(LinearRing linearRing) {
        this.visit((LineString)linearRing);
    }

    @Override
    public void visit(PolyHedralSurface surface) {
        throw new IllegalArgumentException(INVALID_TYPE_MSG);
    }

    public Geometry result() {
        int number0Dimensional = 0;
        int number1Dimensional = 0;
        for (PointSequence ps2 : this.pointSequences) {
            assert (!ps2.isEmpty());
            if (ps2.size() > 1) {
                ++number1Dimensional;
                continue;
            }
            ++number0Dimensional;
        }
        if (number0Dimensional == 0 && number1Dimensional == 0) {
            return Point.EMPTY;
        }
        if (number0Dimensional > 1 && number1Dimensional == 0) {
            Point[] pnts = new Point[number0Dimensional];
            int i2 = 0;
            for (PointSequence ps3 : this.pointSequences) {
                pnts[i2++] = new Point(ps3, this.ops);
            }
            return new MultiPoint(pnts);
        }
        if (number0Dimensional == 1 && number1Dimensional == 0) {
            return new MultiPoint(new Point[]{new Point(this.pointSequences.get(0), this.ops)});
        }
        if (number0Dimensional == 0 && number1Dimensional >= 1) {
            LineString[] lineStrings = new LineString[number1Dimensional];
            int i3 = 0;
            for (PointSequence ps4 : this.pointSequences) {
                lineStrings[i3++] = new LineString(ps4, this.ops);
            }
            return new MultiLineString(lineStrings);
        }
        if (number0Dimensional > 0 && number1Dimensional > 0) {
            Geometry[] geometries = new Geometry[number1Dimensional + number0Dimensional];
            int i4 = 0;
            for (PointSequence ps5 : this.pointSequences) {
                if (ps5.size() == 1) {
                    geometries[i4++] = new Point(ps5, this.ops);
                    continue;
                }
                geometries[i4++] = new LineString(ps5, this.ops);
            }
            return new GeometryCollection(geometries);
        }
        throw new IllegalStateException(String.format("Programming error: Case of % d 0-Dim. en %d 1-Dim not properly handled", number0Dimensional, number1Dimensional));
    }
}

