/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.common.expressions;

import org.geolatte.common.expressions.BooleanBinaryStringExpression;
import org.geolatte.common.expressions.Expression;

public abstract class StringLikeComparisonExpression
extends BooleanBinaryStringExpression {
    private char wildcard;
    private boolean caseInsensitive = false;

    public StringLikeComparisonExpression(Expression<String> left, Expression<String> right) {
        this(left, right, '%');
    }

    public StringLikeComparisonExpression(Expression<String> left, Expression<String> right, boolean caseInsensitive) {
        this(left, right, '%', caseInsensitive);
    }

    public StringLikeComparisonExpression(Expression<String> left, Expression<String> right, char wildCardCharacter) {
        this(left, right, wildCardCharacter, false);
    }

    public StringLikeComparisonExpression(Expression<String> left, Expression<String> right, char wildCardCharacter, boolean caseInsensitive) {
        super(left, right);
        this.wildcard = wildCardCharacter;
        this.caseInsensitive = caseInsensitive;
    }

    public static boolean wildCardMatch(String text, String pattern, char multiCharacterWildCardChar, boolean caseInsensitive) {
        String[] cards;
        if (caseInsensitive) {
            text = text.toLowerCase();
            pattern = pattern.toLowerCase();
        }
        String wildCardString = "" + multiCharacterWildCardChar;
        if (!Character.isLetter(multiCharacterWildCardChar)) {
            wildCardString = "\\" + wildCardString;
        }
        if ((cards = pattern.split(wildCardString)).length != 0 && pattern.charAt(0) != multiCharacterWildCardChar && text.indexOf(cards[0]) != 0) {
            return false;
        }
        for (String card : cards) {
            int idx = text.indexOf(card);
            if (idx == -1) {
                return false;
            }
            text = text.substring(idx + card.length());
        }
        return pattern.charAt(pattern.length() - 1) == multiCharacterWildCardChar || text.length() == 0;
    }

    protected char getWildcardChar() {
        return this.wildcard;
    }

    public boolean isCaseInsensitive() {
        return this.caseInsensitive;
    }
}

