/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.common.expressions;

import java.util.Date;
import org.geolatte.common.expressions.Add;
import org.geolatte.common.expressions.And;
import org.geolatte.common.expressions.BooleanConstant;
import org.geolatte.common.expressions.BooleanExpression;
import org.geolatte.common.expressions.BooleanIsEqual;
import org.geolatte.common.expressions.BooleanIsGreaterThan;
import org.geolatte.common.expressions.BooleanIsGreaterThanOrEqual;
import org.geolatte.common.expressions.BooleanIsLessThan;
import org.geolatte.common.expressions.BooleanIsLessThanOrEqual;
import org.geolatte.common.expressions.BooleanIsNotEqual;
import org.geolatte.common.expressions.BooleanProperty;
import org.geolatte.common.expressions.ComparableExpression;
import org.geolatte.common.expressions.DateConstant;
import org.geolatte.common.expressions.DateIsBetween;
import org.geolatte.common.expressions.DateProperty;
import org.geolatte.common.expressions.Expression;
import org.geolatte.common.expressions.IsAfter;
import org.geolatte.common.expressions.IsBefore;
import org.geolatte.common.expressions.IsEqual;
import org.geolatte.common.expressions.IsGreaterThan;
import org.geolatte.common.expressions.IsGreaterThanOrEqual;
import org.geolatte.common.expressions.IsLessThan;
import org.geolatte.common.expressions.IsLessThanOrEqual;
import org.geolatte.common.expressions.IsNotEqual;
import org.geolatte.common.expressions.Like;
import org.geolatte.common.expressions.Not;
import org.geolatte.common.expressions.NotLike;
import org.geolatte.common.expressions.NumberConstant;
import org.geolatte.common.expressions.NumberExpression;
import org.geolatte.common.expressions.NumberProperty;
import org.geolatte.common.expressions.Or;
import org.geolatte.common.expressions.PropertyDoesNotExist;
import org.geolatte.common.expressions.PropertyExists;
import org.geolatte.common.expressions.StringConstant;
import org.geolatte.common.expressions.StringExpression;
import org.geolatte.common.expressions.StringIsEqual;
import org.geolatte.common.expressions.StringIsGreaterThan;
import org.geolatte.common.expressions.StringIsGreaterThanOrEqual;
import org.geolatte.common.expressions.StringIsLessThan;
import org.geolatte.common.expressions.StringIsLessThanOrEqual;
import org.geolatte.common.expressions.StringIsNotEqual;
import org.geolatte.common.expressions.StringProperty;
import org.geolatte.common.expressions.geo.GeoEquals;
import org.geolatte.common.expressions.geo.GeometryConstant;
import org.geolatte.common.expressions.geo.GeometryProperty;
import org.geolatte.geom.Geometry;

public class Expressions {
    public static NumberConstant constant(Number number) {
        return new NumberConstant(number);
    }

    public static StringConstant constant(String string) {
        return new StringConstant(string);
    }

    public static BooleanConstant constant(Boolean bool) {
        return new BooleanConstant(bool);
    }

    public static DateConstant constant(Date date) {
        return new DateConstant(date);
    }

    public static GeometryConstant constant(Geometry geometry) {
        return new GeometryConstant(geometry);
    }

    public static NumberProperty numberProperty(String propertyName) {
        return new NumberProperty(propertyName);
    }

    public static BooleanProperty booleanProperty(String propertyName) {
        return new BooleanProperty(propertyName);
    }

    public static StringProperty stringProperty(String propertyName) {
        return new StringProperty(propertyName);
    }

    public static DateProperty dateProperty(String propertyName) {
        return new DateProperty(propertyName);
    }

    public static IsEqual isEqual(NumberExpression left, NumberExpression right) {
        return new IsEqual(left, right);
    }

    public static IsEqual isEqual(ComparableExpression<Number> left, Number constant) {
        return new IsEqual(left, Expressions.constant(constant));
    }

    public static IsEqual isEqual(NumberExpression left, Object constant) {
        if (!(constant instanceof Number)) {
            throw new IllegalArgumentException("constant is not a Number");
        }
        return new IsEqual(left, Expressions.constant((Number)constant));
    }

    public static BooleanIsEqual isEqual(BooleanExpression left, BooleanExpression right) {
        return new BooleanIsEqual(left, right);
    }

    public static BooleanIsEqual isEqual(ComparableExpression<Boolean> left, Boolean constant) {
        return new BooleanIsEqual(left, Expressions.constant(constant));
    }

    public static BooleanIsEqual isEqual(BooleanExpression left, Object constant) {
        if (!(constant instanceof Boolean)) {
            throw new IllegalArgumentException("constant is not a Boolean");
        }
        return new BooleanIsEqual(left, Expressions.constant((Boolean)constant));
    }

    public static StringIsEqual isEqual(StringExpression left, StringExpression right) {
        return new StringIsEqual(left, right);
    }

    public static StringIsEqual isEqual(StringExpression left, Object constant) {
        if (!(constant instanceof String)) {
            throw new IllegalArgumentException("constant is not a String");
        }
        return new StringIsEqual(left, Expressions.constant((String)constant));
    }

    public static IsGreaterThan isGreaterThan(ComparableExpression<Number> left, ComparableExpression<Number> right) {
        return new IsGreaterThan(left, right);
    }

    public static BooleanIsGreaterThan isGreaterThan(BooleanExpression left, BooleanExpression right) {
        return new BooleanIsGreaterThan(left, right);
    }

    public static StringIsGreaterThan isGreaterThan(StringExpression left, StringExpression right) {
        return new StringIsGreaterThan(left, right);
    }

    public static IsGreaterThanOrEqual isGreaterThanOrEqual(ComparableExpression<Number> left, ComparableExpression<Number> right) {
        return new IsGreaterThanOrEqual(left, right);
    }

    public static BooleanIsGreaterThanOrEqual isGreaterThanOrEqual(BooleanExpression left, BooleanExpression right) {
        return new BooleanIsGreaterThanOrEqual(left, right);
    }

    public static BooleanIsLessThanOrEqual isLessThanOrEqual(ComparableExpression<Boolean> left, Object constant) {
        if (!(constant instanceof Boolean)) {
            throw new IllegalArgumentException("constant is not a Boolean");
        }
        return new BooleanIsLessThanOrEqual(left, Expressions.constant((Boolean)constant));
    }

    public static StringIsGreaterThanOrEqual isGreaterThanOrEqual(StringExpression left, StringExpression right) {
        return new StringIsGreaterThanOrEqual(left, right);
    }

    public static IsLessThan isLessThan(ComparableExpression<Number> left, ComparableExpression<Number> right) {
        return new IsLessThan(left, right);
    }

    public static IsLessThan isLessThan(ComparableExpression<Number> left, Object constant) {
        if (!(constant instanceof Number)) {
            throw new IllegalArgumentException("constant is not a Number");
        }
        return new IsLessThan(left, Expressions.constant((Number)constant));
    }

    public static BooleanIsLessThan isLessThan(BooleanExpression left, BooleanExpression right) {
        return new BooleanIsLessThan(left, right);
    }

    public static BooleanIsLessThan isLessThan(BooleanExpression left, Object constant) {
        if (!(constant instanceof Boolean)) {
            throw new IllegalArgumentException("constant is not a Boolean");
        }
        return new BooleanIsLessThan(left, Expressions.constant((Boolean)constant));
    }

    public static StringIsLessThan isLessThan(StringExpression left, StringExpression right) {
        return new StringIsLessThan(left, right);
    }

    public static StringIsLessThan isLessThan(StringExpression left, Object constant) {
        if (!(constant instanceof String)) {
            throw new IllegalArgumentException("constant is not a String");
        }
        return new StringIsLessThan(left, Expressions.constant((String)constant));
    }

    public static IsLessThanOrEqual isLessThanOrEqual(NumberExpression left, NumberExpression right) {
        return new IsLessThanOrEqual(left, right);
    }

    public static IsLessThanOrEqual isLessThanOrEqual(NumberExpression left, Object constant) {
        if (!(constant instanceof Number)) {
            throw new IllegalArgumentException("constant is not a Number");
        }
        return new IsLessThanOrEqual(left, Expressions.constant((Number)constant));
    }

    public static StringIsLessThanOrEqual isLessThanOrEqual(StringExpression left, StringExpression right) {
        return new StringIsLessThanOrEqual(left, right);
    }

    public static StringIsLessThanOrEqual isLessThanOrEqual(StringExpression left, Object constant) {
        if (!(constant instanceof String)) {
            throw new IllegalArgumentException("constant is not a String");
        }
        return new StringIsLessThanOrEqual(left, Expressions.constant((String)constant));
    }

    public static IsNotEqual isNotEqual(NumberExpression left, NumberExpression right) {
        return new IsNotEqual(left, right);
    }

    public static IsNotEqual isNotEqual(ComparableExpression<Number> left, Object constant) {
        if (!(constant instanceof Number)) {
            throw new IllegalArgumentException("constant is not a Number");
        }
        return new IsNotEqual(left, Expressions.constant((Number)constant));
    }

    public static BooleanIsNotEqual isNotEqual(ComparableExpression<Boolean> left, ComparableExpression<Boolean> right) {
        return new BooleanIsNotEqual(left, right);
    }

    public static StringIsNotEqual isNotEqual(StringExpression left, StringExpression right) {
        return new StringIsNotEqual(left, right);
    }

    public static Add add(Expression<Number> left, Expression<Number> right) {
        return new Add(left, right);
    }

    public static Like like(Expression<String> left, Expression<String> right) {
        return new Like(left, right);
    }

    public static Like like(Expression<String> left, Expression<String> right, boolean caseInsensitive) {
        return new Like(left, right, caseInsensitive);
    }

    public static Like like(Expression<String> left, String constant) {
        return new Like(left, Expressions.constant(constant));
    }

    public static Like like(Expression<String> left, String constant, boolean caseInsensitive) {
        return new Like(left, (Expression<String>)Expressions.constant(constant), caseInsensitive);
    }

    public static NotLike notLike(Expression<String> left, Expression<String> right) {
        return new NotLike(left, right);
    }

    public static NotLike notLike(Expression<String> left, Expression<String> right, boolean caseInsensitive) {
        return new NotLike(left, right, caseInsensitive);
    }

    public static NotLike notLike(Expression<String> left, String constant) {
        return new NotLike(left, Expressions.constant(constant));
    }

    public static NotLike notLike(Expression<String> left, String constant, boolean caseInsensitive) {
        return new NotLike(left, (Expression<String>)Expressions.constant(constant), caseInsensitive);
    }

    public static Like like(Expression<String> left, Expression<String> right, char wildCardCharacter) {
        return new Like(left, right, wildCardCharacter);
    }

    public static Like like(Expression<String> left, Expression<String> right, char wildCardCharacter, boolean caseInsensitive) {
        return new Like(left, right, wildCardCharacter, caseInsensitive);
    }

    public static Like like(Expression<String> left, String constant, char wildCardCharacter) {
        return new Like(left, (Expression<String>)Expressions.constant(constant), wildCardCharacter);
    }

    public static Like like(Expression<String> left, String constant, char wildCardCharacter, boolean caseInsensitive) {
        return new Like(left, Expressions.constant(constant), wildCardCharacter, caseInsensitive);
    }

    public static NotLike notLike(Expression<String> left, Expression<String> right, char wildCardCharacter) {
        return new NotLike(left, right, wildCardCharacter);
    }

    public static NotLike notLike(Expression<String> left, Expression<String> right, char wildCardCharacter, boolean caseInsensitive) {
        return new NotLike(left, right, wildCardCharacter, caseInsensitive);
    }

    public static NotLike notLike(Expression<String> left, String constant, char wildCardCharacter) {
        return new NotLike(left, (Expression<String>)Expressions.constant(constant), wildCardCharacter);
    }

    public static NotLike notLike(Expression<String> left, String constant, char wildCardCharacter, boolean caseInsensitive) {
        return new NotLike(left, Expressions.constant(constant), wildCardCharacter, caseInsensitive);
    }

    public static And and(Expression<Boolean> left, Expression<Boolean> right) {
        return new And(left, right);
    }

    public static Or or(Expression<Boolean> left, Expression<Boolean> right) {
        return new Or(left, right);
    }

    public static Not not(Expression<Boolean> expression) {
        return new Not(expression);
    }

    public static IsBefore isBefore(Expression<Date> left, Expression<Date> right) {
        return new IsBefore(left, right);
    }

    public static IsAfter isAfter(Expression<Date> left, Expression<Date> right) {
        return new IsAfter(left, right);
    }

    public static DateIsBetween isBetween(ComparableExpression<Date> date, ComparableExpression<Date> lowDate, ComparableExpression<Date> highDate) {
        return new DateIsBetween(date, lowDate, highDate);
    }

    public static PropertyDoesNotExist doesNotExist(String propertyName) {
        return new PropertyDoesNotExist(propertyName);
    }

    public static PropertyExists exists(String propertyName) {
        return new PropertyExists(propertyName);
    }

    public static GeoEquals geoEquals(Expression<Geometry> left, Expression<Geometry> right) {
        return new GeoEquals(left, right);
    }

    public static GeometryProperty geometryProperty(String attributeName) {
        return new GeometryProperty(attributeName);
    }
}

