/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.common.dataformats.json.to;

import java.util.Arrays;
import org.geolatte.common.dataformats.json.to.CrsTo;
import org.geolatte.common.dataformats.json.to.GeoJsonTo;

public final class PolygonTo
extends GeoJsonTo {
    private double[][][] coordinates;

    public PolygonTo() {
    }

    public PolygonTo(CrsTo crs, double[][][] coordinates) {
        super(crs, PolygonTo.createBoundingBox(coordinates));
        this.coordinates = coordinates;
    }

    @Override
    public boolean isValid() {
        if (this.coordinates == null || this.coordinates.length == 0) {
            return false;
        }
        for (double[][] linearRing : this.coordinates) {
            if (linearRing == null || linearRing.length < 2) {
                return false;
            }
            int length = linearRing[0].length;
            if (length < 2 || length > 4) {
                return false;
            }
            for (double[] points : linearRing) {
                if (points.length == length) continue;
                return false;
            }
            for (int i2 = 0; i2 < linearRing[0].length; ++i2) {
                if (!(linearRing[0][i2] - linearRing[linearRing.length - 1][i2] > 1.0E-8)) continue;
                return false;
            }
        }
        return true;
    }

    public double[][][] getCoordinates() {
        return this.coordinates;
    }

    public void setCoordinates(double[][][] coordinates) {
        this.coordinates = coordinates;
        if (this.isValid()) {
            this.setBbox(PolygonTo.createBoundingBox(coordinates[0]));
        }
    }

    @Override
    public boolean equals(Object o2) {
        if (!super.equals(o2)) {
            return false;
        }
        PolygonTo polygonTo = (PolygonTo)o2;
        return Arrays.deepEquals((Object[])this.coordinates, (Object[])polygonTo.coordinates);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.coordinates != null ? Arrays.deepHashCode((Object[])this.coordinates) : 0);
        return result;
    }
}

