/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.common.dataformats.json.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import org.geolatte.common.dataformats.json.jackson.GeometrySerializer;
import org.geolatte.common.dataformats.json.jackson.JsonMapper;
import org.geolatte.geom.LineString;
import org.geolatte.geom.MultiLineString;
import org.geolatte.geom.Point;

public class MultiLineStringSerializer
extends GeometrySerializer<MultiLineString> {
    public MultiLineStringSerializer(JsonMapper containingTransformation) {
        super(containingTransformation);
    }

    @Override
    public void writeShapeSpecificSerialization(MultiLineString value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        jgen.writeFieldName("type");
        jgen.writeString("MultiLineString");
        jgen.writeArrayFieldStart("coordinates");
        JsonSerializer<Object> ser = provider.findValueSerializer(Double.class, null);
        for (int i2 = 0; i2 < value.getNumGeometries(); ++i2) {
            LineString ml2 = value.getGeometryN(i2);
            jgen.writeStartArray();
            for (int j2 = 0; j2 < ml2.getNumPoints(); ++j2) {
                Point point = ml2.getPointN(j2);
                jgen.writeStartArray();
                ser.serialize(point.getX(), jgen, provider);
                ser.serialize(point.getY(), jgen, provider);
                jgen.writeEndArray();
            }
            jgen.writeEndArray();
        }
        jgen.writeEndArray();
    }
}

