/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.common.dataformats.json.jackson;

import com.fasterxml.jackson.core.JsonParser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.geolatte.common.dataformats.json.jackson.GeoJsonDeserializer;
import org.geolatte.common.dataformats.json.jackson.JsonException;
import org.geolatte.common.dataformats.json.jackson.JsonMapper;
import org.geolatte.geom.DimensionalFlag;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.GeometryCollection;
import org.geolatte.geom.LineString;
import org.geolatte.geom.LinearRing;
import org.geolatte.geom.MultiLineString;
import org.geolatte.geom.MultiPoint;
import org.geolatte.geom.MultiPolygon;
import org.geolatte.geom.Point;
import org.geolatte.geom.PointCollectionFactory;
import org.geolatte.geom.PointSequence;
import org.geolatte.geom.PointSequenceBuilder;
import org.geolatte.geom.PointSequenceBuilders;
import org.geolatte.geom.Polygon;
import org.geolatte.geom.crs.CrsId;

public class GeometryDeserializer<T extends Geometry>
extends GeoJsonDeserializer<T> {
    public GeometryDeserializer(JsonMapper owner, Class<T> clazz) {
        super(owner, clazz);
    }

    @Override
    protected T deserialize(JsonParser jsonParser) throws IOException {
        CrsId crsId;
        String type = this.getStringParam("type", "Invalid GeoJSON, type property required.");
        Integer srid = this.getSrid();
        CrsId crsId2 = crsId = srid == null ? this.parent.getDefaultCrsId() : CrsId.valueOf(srid);
        if ("GeometryCollection".equals(type)) {
            GeometryCollection result = this.asGeomCollection(crsId);
            if (this.getDeserializerClass().isAssignableFrom(GeometryCollection.class)) {
                return (T)result;
            }
            throw new IOException("Json is a valid GeometryCollection serialization, but this does not correspond with the expected outputtype of the deserializer (" + this.getDeserializerClass().getSimpleName() + ")");
        }
        List coordinates = this.getTypedParam("coordinates", "Invalid or missing coordinates property", ArrayList.class);
        try {
            if ("Point".equals(type)) {
                Point p2 = this.asPoint(coordinates, crsId);
                if (this.getDeserializerClass().isAssignableFrom(Point.class)) {
                    return (T)p2;
                }
                throw new IOException("Json is a valid Point serialization, but this does not correspond with the expected outputtype of the deserializer (" + this.getDeserializerClass().getSimpleName() + ")");
            }
            if ("MultiPoint".equals(type)) {
                MultiPoint result = this.asMultiPoint(coordinates, crsId);
                if (this.getDeserializerClass().isAssignableFrom(MultiPoint.class)) {
                    return (T)result;
                }
                throw new IOException("Json is a valid MultiPoint serialization, but this does not correspond with the expected outputtype of the deserializer (" + this.getDeserializerClass().getSimpleName() + ")");
            }
            if ("LineString".equals(type)) {
                LineString result = this.asLineString(coordinates, crsId);
                if (this.getDeserializerClass().isAssignableFrom(LineString.class)) {
                    return (T)result;
                }
                throw new IOException("Json is a valid LineString serialization, but this does not correspond with the expected outputtype of the deserializer (" + this.getDeserializerClass().getSimpleName() + ")");
            }
            if ("MultiLineString".equals(type)) {
                MultiLineString result = this.asMultiLineString(coordinates, crsId);
                if (this.getDeserializerClass().isAssignableFrom(MultiLineString.class)) {
                    return (T)result;
                }
                throw new IOException("Json is a valid MultiLineString serialization, but this does not correspond with the expected outputtype of the deserializer (" + this.getDeserializerClass().getSimpleName() + ")");
            }
            if ("Polygon".equals(type)) {
                Polygon result = this.asPolygon(coordinates, crsId);
                if (this.getDeserializerClass().isAssignableFrom(Polygon.class)) {
                    return (T)result;
                }
                throw new IOException("Json is a valid Polygon serialization, but this does not correspond with the expected outputtype of the deserializer (" + this.getDeserializerClass().getSimpleName() + ")");
            }
            if ("MultiPolygon".equals(type)) {
                MultiPolygon result = this.asMultiPolygon(coordinates, crsId);
                if (this.getDeserializerClass().isAssignableFrom(MultiPolygon.class)) {
                    return (T)result;
                }
                throw new IOException("Json is a valid MultiPolygon serialization, but this does not correspond with the expected outputtype of the deserializer (" + this.getDeserializerClass().getSimpleName() + ")");
            }
            throw new IOException("Unknown type for a geometry deserialization");
        }
        catch (ClassCastException e2) {
            throw new IOException("Coordinate array is not of expected type with respect to given type parameter.");
        }
    }

    private GeometryCollection asGeomCollection(CrsId crsId) throws IOException {
        try {
            String subJson = this.getSubJson("geometries", "A geometrycollection requires a geometries parameter").replaceAll(" ", "");
            String noSpaces = subJson.replace(" ", "");
            if (noSpaces.contains("\"crs\":{")) {
                throw new IOException("Specification of the crs information is forbidden in child elements. Either leave it out, or specify it at the toplevel object.");
            }
            subJson = this.setCrsIds(subJson, crsId);
            List<Geometry> geometries = this.parent.collectionFromJson(subJson, Geometry.class);
            return new GeometryCollection(geometries.toArray(new Geometry[geometries.size()]));
        }
        catch (JsonException e2) {
            throw new IOException(e2);
        }
    }

    private String setCrsIds(String json, CrsId crsId) throws IOException, JsonException {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("name", crsId.getAuthority() + ":" + crsId.getCode());
        HashMap<String, Object> type = new HashMap<String, Object>();
        type.put("type", "name");
        type.put("properties", properties);
        List<HashMap> result = this.parent.collectionFromJson(json, HashMap.class);
        for (HashMap geometryJson : result) {
            geometryJson.put("crs", type);
        }
        return this.parent.toJson(result);
    }

    private MultiPolygon asMultiPolygon(List<List<List<List>>> coords, CrsId crsId) throws IOException {
        if (coords == null || coords.isEmpty()) {
            throw new IOException("A multipolygon should have at least one polyon.");
        }
        Polygon[] polygons = new Polygon[coords.size()];
        for (int i2 = 0; i2 < coords.size(); ++i2) {
            polygons[i2] = this.asPolygon(coords.get(i2), crsId);
        }
        return new MultiPolygon(polygons);
    }

    private MultiLineString asMultiLineString(List<List<List>> coords, CrsId crsId) throws IOException {
        if (coords == null || coords.isEmpty()) {
            throw new IOException("A multilinestring requires at least one line string");
        }
        LineString[] lineStrings = new LineString[coords.size()];
        for (int i2 = 0; i2 < lineStrings.length; ++i2) {
            lineStrings[i2] = this.asLineString(coords.get(i2), crsId);
        }
        return new MultiLineString(lineStrings);
    }

    private Polygon asPolygon(List<List<List>> coords, CrsId crsId) throws IOException {
        if (coords == null || coords.isEmpty()) {
            throw new IOException("A polygon requires the specification of its outer ring");
        }
        ArrayList<LinearRing> rings = new ArrayList<LinearRing>();
        try {
            for (List<List> ring : coords) {
                PointSequence ringCoords = this.getPointSequence(ring, crsId);
                rings.add(new LinearRing(ringCoords));
            }
            return new Polygon(rings.toArray(new LinearRing[0]));
        }
        catch (IllegalArgumentException e2) {
            throw new IOException("Invalid Polygon: " + e2.getMessage(), e2);
        }
    }

    private Point asPoint(List coords, CrsId crsId) throws IOException {
        if (coords != null && coords.size() >= 2) {
            ArrayList<List> coordinates = new ArrayList<List>();
            coordinates.add(coords);
            return new Point(this.getPointSequence(coordinates, crsId));
        }
        throw new IOException("A point must has exactly one coordinate (an x, a y and possibly a z value). Additional numbers in the coordinate are permitted but ignored.");
    }

    private LineString asLineString(List<List> coords, CrsId crsId) throws IOException {
        if (coords == null || coords.size() < 2) {
            throw new IOException("A linestring requires a valid series of coordinates (at least two coordinates)");
        }
        PointSequence coordinates = this.getPointSequence(coords, crsId);
        return new LineString(coordinates);
    }

    private MultiPoint asMultiPoint(List<List> coords, CrsId crsId) throws IOException {
        if (coords == null || coords.isEmpty()) {
            throw new IOException("A multipoint contains at least one point");
        }
        Point[] points = new Point[coords.size()];
        for (int i2 = 0; i2 < coords.size(); ++i2) {
            points[i2] = this.asPoint(coords.get(i2), crsId);
        }
        return new MultiPoint(points);
    }

    private PointSequence getPointSequence(List<List> entry, CrsId crsId) throws IOException {
        double[] coordinates2d = new double[entry.size() * 2];
        double[] zValues = new double[entry.size()];
        double[] mValues = new double[entry.size()];
        boolean haszValues = false;
        boolean hasmValues = false;
        for (int i2 = 0; i2 < entry.size(); ++i2) {
            List current = entry.get(i2);
            if (current.size() < 2) {
                throw new IOException("A coordinate must always contain at least two numbers");
            }
            for (Object value : current) {
                if (value instanceof Integer || value instanceof Double) continue;
                throw new IOException("A coordiante only permits numbers.");
            }
            Double type = null;
            Double x2 = this.parseDefault(String.valueOf(current.get(0)), type);
            Double y2 = this.parseDefault(String.valueOf(current.get(1)), type);
            Double z2 = null;
            Double m3 = null;
            if (current.size() >= 3) {
                z2 = this.parseDefault(String.valueOf(current.get(2)), type);
            }
            if (current.size() >= 4) {
                m3 = this.parseDefault(String.valueOf(current.get(3)), type);
            }
            if (x2 == null || y2 == null) {
                throw new IOException("Unexpected number format for coordinate?");
            }
            coordinates2d[2 * i2] = x2;
            coordinates2d[2 * i2 + 1] = y2;
            if (z2 != null) {
                zValues[i2] = z2;
                haszValues = true;
            } else {
                zValues[i2] = Double.NaN;
            }
            if (m3 != null) {
                mValues[i2] = m3;
                hasmValues = true;
                continue;
            }
            mValues[i2] = Double.NaN;
        }
        if (hasmValues && haszValues) {
            PointSequenceBuilder builder = PointSequenceBuilders.fixedSized(entry.size(), DimensionalFlag.d3DM, crsId);
            for (int i3 = 0; i3 < entry.size(); ++i3) {
                builder.add(coordinates2d[2 * i3], coordinates2d[2 * i3 + 1], zValues[i3], mValues[i3]);
            }
            return builder.toPointSequence();
        }
        if (haszValues) {
            PointSequenceBuilder builder = PointSequenceBuilders.fixedSized(entry.size(), DimensionalFlag.d3D, crsId);
            for (int i4 = 0; i4 < entry.size(); ++i4) {
                builder.add(coordinates2d[2 * i4], coordinates2d[2 * i4 + 1], zValues[i4]);
            }
            return builder.toPointSequence();
        }
        return PointCollectionFactory.create(coordinates2d, DimensionalFlag.d2D, crsId);
    }
}

