/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.common.dataformats.json.jackson;

import com.fasterxml.jackson.core.JsonParser;
import java.io.IOException;
import java.util.Map;
import org.geolatte.common.Feature;
import org.geolatte.common.dataformats.json.jackson.DefaultFeature;
import org.geolatte.common.dataformats.json.jackson.GeoJsonDeserializer;
import org.geolatte.common.dataformats.json.jackson.JsonException;
import org.geolatte.common.dataformats.json.jackson.JsonMapper;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.crs.CrsId;

public class FeatureDeserializer
extends GeoJsonDeserializer<Feature> {
    public FeatureDeserializer(JsonMapper owner) {
        super(owner, Feature.class);
    }

    @Override
    protected Feature deserialize(JsonParser jsonParser) throws IOException {
        String type = this.getStringParam("type", "Invalid Feature, type property required.");
        Integer srid = this.getSrid();
        int sridToUse = srid == null ? 4326 : srid;
        CrsId crsId = CrsId.valueOf(sridToUse);
        if ("Feature".equals(type)) {
            try {
                DefaultFeature f2 = new DefaultFeature();
                String subJson = this.getSubJson("geometry", "A geometry field is required for a Feature");
                String noSpaces = subJson.replaceAll(" ", "");
                if (noSpaces.contains("\"crs\":{")) {
                    throw new IOException("Specification of the crs information is forbidden in child elements. Either leave it out, or specify it at the toplevel object.");
                }
                Geometry theGeom = this.parent.fromJson(subJson, Geometry.class);
                f2.setGeometry("geometry", theGeom);
                Object idValue = this.getTypedParam("id", null, Object.class);
                if (idValue != null) {
                    f2.setId("id", idValue);
                }
                Map properties = this.parent.fromJson(this.getSubJson("properties", "A feature requires a properties list"), Map.class);
                for (String m3 : properties.keySet()) {
                    f2.addProperty(m3, properties.get(m3));
                }
                return f2;
            }
            catch (JsonException e2) {
                throw new IOException("Deserialization of geometry for the given feature failed", e2);
            }
        }
        throw new IOException("The type parameter of a feature must have 'Feature' as its value");
    }
}

