/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.common.cql;

import java.io.IOException;
import java.io.PushbackReader;
import java.io.StringReader;
import java.text.ParseException;
import org.geolatte.common.cql.CqlFilter;
import org.geolatte.common.cql.FilterExpressionBuilder;
import org.geolatte.common.cql.lexer.Lexer;
import org.geolatte.common.cql.lexer.LexerException;
import org.geolatte.common.cql.node.Start;
import org.geolatte.common.cql.parser.Parser;
import org.geolatte.common.cql.parser.ParserException;
import org.geolatte.common.expressions.Filter;

public class Cql {
    public static CqlFilter toFilter(String cqlExpression) {
        return new CqlFilter(cqlExpression);
    }

    public static Filter toStaticFilter(String cqlExpression, Class clazz) throws ParseException {
        try {
            Parser p2 = new Parser(new Lexer(new PushbackReader(new StringReader(cqlExpression), 1024)));
            Start tree = p2.parse();
            FilterExpressionBuilder builder = new FilterExpressionBuilder();
            tree.apply(builder);
            return new Filter(builder.getExp());
        }
        catch (ParserException e2) {
            ParseException parseException = new ParseException(e2.getMessage(), e2.getToken().getPos());
            parseException.initCause(e2);
            throw parseException;
        }
        catch (LexerException e3) {
            ParseException parseException = new ParseException(e3.getMessage(), 0);
            parseException.initCause(e3);
            throw parseException;
        }
        catch (IOException e4) {
            ParseException parseException = new ParseException(e4.getMessage(), 0);
            parseException.initCause(e4);
            throw parseException;
        }
    }
}

