/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.formatter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.IllegalFormatConversionException;
import java.util.IllegalFormatException;
import java.util.MissingFormatArgumentException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.checkerframework.checker.formatter.qual.ConversionCategory;
import org.checkerframework.checker.formatter.qual.ReturnsFormat;

public class FormatUtil {
    private static final String formatSpecifier = "%(\\d+\\$)?([-#+ 0,(\\<]*)?(\\d+)?(\\.\\d+)?([tT])?([a-zA-Z%])";
    private static Pattern fsPattern = Pattern.compile("%(\\d+\\$)?([-#+ 0,(\\<]*)?(\\d+)?(\\.\\d+)?([tT])?([a-zA-Z%])");

    @ReturnsFormat
    public static String asFormat(String format, ConversionCategory ... cc2) throws IllegalFormatException {
        ConversionCategory[] fcc = FormatUtil.formatParameterCategories(format);
        if (fcc.length != cc2.length) {
            throw new ExcessiveOrMissingFormatArgumentException(cc2.length, fcc.length);
        }
        for (int i2 = 0; i2 < cc2.length; ++i2) {
            if (cc2[i2] == fcc[i2]) continue;
            throw new IllegalFormatConversionCategoryException(cc2[i2], fcc[i2]);
        }
        return format;
    }

    public static void tryFormatSatisfiability(String format) throws IllegalFormatException {
        String unused = String.format(format, (Object[])null);
    }

    public static ConversionCategory[] formatParameterCategories(String format) throws IllegalFormatException {
        FormatUtil.tryFormatSatisfiability(format);
        int last = -1;
        int lasto = -1;
        int maxindex = -1;
        Conversion[] cs2 = FormatUtil.parse(format);
        HashMap<Integer, ConversionCategory> conv = new HashMap<Integer, ConversionCategory>();
        for (Conversion c2 : cs2) {
            int index = c2.index();
            switch (index) {
                case -1: {
                    break;
                }
                case 0: {
                    last = ++lasto;
                    break;
                }
                default: {
                    last = index - 1;
                }
            }
            maxindex = Math.max(maxindex, last);
            conv.put(last, ConversionCategory.intersect(conv.containsKey(last) ? (ConversionCategory)((Object)conv.get(last)) : ConversionCategory.UNUSED, c2.category()));
        }
        ConversionCategory[] res = new ConversionCategory[maxindex + 1];
        for (int i2 = 0; i2 <= maxindex; ++i2) {
            res[i2] = conv.containsKey(i2) ? (ConversionCategory)((Object)conv.get(i2)) : ConversionCategory.UNUSED;
        }
        return res;
    }

    private static int indexFromFormat(Matcher m3) {
        String s2 = m3.group(1);
        int index = s2 != null ? Integer.parseInt(s2.substring(0, s2.length() - 1)) : (m3.group(2) != null && m3.group(2).contains(String.valueOf('<')) ? -1 : 0);
        return index;
    }

    private static char conversionCharFromFormat(Matcher m3) {
        String dt2 = m3.group(5);
        if (dt2 == null) {
            return m3.group(6).charAt(0);
        }
        return dt2.charAt(0);
    }

    private static Conversion[] parse(String format) {
        ArrayList<Conversion> cs2 = new ArrayList<Conversion>();
        Matcher m3 = fsPattern.matcher(format);
        block3: while (m3.find()) {
            char c2 = FormatUtil.conversionCharFromFormat(m3);
            switch (c2) {
                case '%': 
                case 'n': {
                    continue block3;
                }
            }
            cs2.add(new Conversion(c2, FormatUtil.indexFromFormat(m3)));
        }
        return cs2.toArray(new Conversion[cs2.size()]);
    }

    public static class IllegalFormatConversionCategoryException
    extends IllegalFormatConversionException {
        private static final long serialVersionUID = 17000126L;
        private final ConversionCategory expected;
        private final ConversionCategory found;

        public IllegalFormatConversionCategoryException(ConversionCategory expected, ConversionCategory found) {
            super(expected.chars.length() == 0 ? (char)'-' : (char)expected.chars.charAt(0), found.types == null ? Object.class : found.types[0]);
            this.expected = expected;
            this.found = found;
        }

        public ConversionCategory getExpected() {
            return this.expected;
        }

        public ConversionCategory getFound() {
            return this.found;
        }

        @Override
        public String getMessage() {
            return String.format("Expected category %s but found %s.", new Object[]{this.expected, this.found});
        }
    }

    public static class ExcessiveOrMissingFormatArgumentException
    extends MissingFormatArgumentException {
        private static final long serialVersionUID = 17000126L;
        private final int expected;
        private final int found;

        public ExcessiveOrMissingFormatArgumentException(int expected, int found) {
            super("-");
            this.expected = expected;
            this.found = found;
        }

        public int getExpected() {
            return this.expected;
        }

        public int getFound() {
            return this.found;
        }

        @Override
        public String getMessage() {
            return String.format("Expected %d arguments but found %d.", this.expected, this.found);
        }
    }

    private static class Conversion {
        private final int index;
        private final ConversionCategory cath;

        public Conversion(char c2, int index) {
            this.index = index;
            this.cath = ConversionCategory.fromConversionChar(c2);
        }

        int index() {
            return this.index;
        }

        ConversionCategory category() {
            return this.cath;
        }
    }
}

